/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.spark.source.TestIcebergSourceTablesBase;
import org.junit.Before;

public class TestIcebergSourceHadoopTables
extends TestIcebergSourceTablesBase {
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    File tableDir = null;
    String tableLocation = null;

    @Before
    public void setupTable() throws Exception {
        this.tableDir = this.temp.newFolder();
        this.tableDir.delete();
        this.tableLocation = this.tableDir.toURI().toString();
    }

    @Override
    public Table createTable(TableIdentifier ident, Schema schema, PartitionSpec spec) {
        if (spec.equals((Object)PartitionSpec.unpartitioned())) {
            return TABLES.create(schema, this.tableLocation);
        }
        return TABLES.create(schema, spec, this.tableLocation);
    }

    @Override
    public Table loadTable(TableIdentifier ident, String entriesSuffix) {
        return TABLES.load(this.loadLocation(ident, entriesSuffix));
    }

    @Override
    public String loadLocation(TableIdentifier ident, String entriesSuffix) {
        return String.format("%s#%s", this.loadLocation(ident), entriesSuffix);
    }

    @Override
    public String loadLocation(TableIdentifier ident) {
        return this.tableLocation;
    }
}

