/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.spark.source.TestIcebergSourceTablesBase;
import org.junit.After;
import org.junit.BeforeClass;

public class TestIcebergSourceHiveTables
extends TestIcebergSourceTablesBase {
    private static TableIdentifier currentIdentifier;

    @BeforeClass
    public static void start() {
        Namespace db = Namespace.of((String[])new String[]{"db"});
        if (!catalog.namespaceExists(db)) {
            catalog.createNamespace(db);
        }
    }

    @After
    public void dropTable() throws IOException {
        Table table = catalog.loadTable(currentIdentifier);
        Path tablePath = new Path(table.location());
        FileSystem fs = tablePath.getFileSystem(spark.sessionState().newHadoopConf());
        fs.delete(tablePath, true);
        catalog.dropTable(currentIdentifier, false);
    }

    @Override
    public Table createTable(TableIdentifier ident, Schema schema, PartitionSpec spec) {
        currentIdentifier = ident;
        return catalog.createTable(ident, schema, spec);
    }

    @Override
    public Table loadTable(TableIdentifier ident, String entriesSuffix) {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{ident.namespace().level(0), ident.name(), entriesSuffix});
        return catalog.loadTable(identifier);
    }

    @Override
    public String loadLocation(TableIdentifier ident, String entriesSuffix) {
        return String.format("%s.%s", this.loadLocation(ident), entriesSuffix);
    }

    @Override
    public String loadLocation(TableIdentifier ident) {
        return ident.toString();
    }
}

