/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import org.apache.iceberg.spark.IcebergSpark;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.VarcharType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestIcebergSpark {
    private static SparkSession spark = null;

    @BeforeClass
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
    }

    @AfterClass
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        currentSpark.stop();
    }

    @Test
    public void testRegisterIntegerBucketUDF() {
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_int_16", (DataType)DataTypes.IntegerType, (int)16);
        List results = spark.sql("SELECT iceberg_bucket_int_16(1)").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)((Integer)Transforms.bucket((Type)Types.IntegerType.get(), (int)16).apply((Object)1)).intValue(), (long)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterShortBucketUDF() {
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_short_16", (DataType)DataTypes.ShortType, (int)16);
        List results = spark.sql("SELECT iceberg_bucket_short_16(1S)").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)((Integer)Transforms.bucket((Type)Types.IntegerType.get(), (int)16).apply((Object)1)).intValue(), (long)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterByteBucketUDF() {
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_byte_16", (DataType)DataTypes.ByteType, (int)16);
        List results = spark.sql("SELECT iceberg_bucket_byte_16(1Y)").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)((Integer)Transforms.bucket((Type)Types.IntegerType.get(), (int)16).apply((Object)1)).intValue(), (long)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterLongBucketUDF() {
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_long_16", (DataType)DataTypes.LongType, (int)16);
        List results = spark.sql("SELECT iceberg_bucket_long_16(1L)").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)((Integer)Transforms.bucket((Type)Types.LongType.get(), (int)16).apply((Object)1L)).intValue(), (long)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterStringBucketUDF() {
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_string_16", (DataType)DataTypes.StringType, (int)16);
        List results = spark.sql("SELECT iceberg_bucket_string_16('hello')").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)((Integer)Transforms.bucket((Type)Types.StringType.get(), (int)16).apply((Object)"hello")).intValue(), (long)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterCharBucketUDF() {
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_char_16", (DataType)new CharType(5), (int)16);
        List results = spark.sql("SELECT iceberg_bucket_char_16('hello')").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)((Integer)Transforms.bucket((Type)Types.StringType.get(), (int)16).apply((Object)"hello")).intValue(), (long)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterVarCharBucketUDF() {
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_varchar_16", (DataType)new VarcharType(5), (int)16);
        List results = spark.sql("SELECT iceberg_bucket_varchar_16('hello')").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)((Integer)Transforms.bucket((Type)Types.StringType.get(), (int)16).apply((Object)"hello")).intValue(), (long)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterDateBucketUDF() {
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_date_16", (DataType)DataTypes.DateType, (int)16);
        List results = spark.sql("SELECT iceberg_bucket_date_16(DATE '2021-06-30')").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)((Integer)Transforms.bucket((Type)Types.DateType.get(), (int)16).apply((Object)DateTimeUtils.fromJavaDate((Date)Date.valueOf("2021-06-30")))).intValue(), (long)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterTimestampBucketUDF() {
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_timestamp_16", (DataType)DataTypes.TimestampType, (int)16);
        List results = spark.sql("SELECT iceberg_bucket_timestamp_16(TIMESTAMP '2021-06-30 00:00:00.000')").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)((Integer)Transforms.bucket((Type)Types.TimestampType.withZone(), (int)16).apply((Object)DateTimeUtils.fromJavaTimestamp((Timestamp)Timestamp.valueOf("2021-06-30 00:00:00.000")))).intValue(), (long)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterBinaryBucketUDF() {
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_binary_16", (DataType)DataTypes.BinaryType, (int)16);
        List results = spark.sql("SELECT iceberg_bucket_binary_16(X'0020001F')").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)((Integer)Transforms.bucket((Type)Types.BinaryType.get(), (int)16).apply((Object)ByteBuffer.wrap(new byte[]{0, 32, 0, 31}))).intValue(), (long)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterDecimalBucketUDF() {
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_decimal_16", (DataType)new DecimalType(4, 2), (int)16);
        List results = spark.sql("SELECT iceberg_bucket_decimal_16(11.11)").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)((Integer)Transforms.bucket((Type)Types.DecimalType.of((int)4, (int)2), (int)16).apply((Object)new BigDecimal("11.11"))).intValue(), (long)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterBooleanBucketUDF() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_boolean_16", (DataType)DataTypes.BooleanType, (int)16)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot bucket by type: boolean");
    }

    @Test
    public void testRegisterDoubleBucketUDF() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_double_16", (DataType)DataTypes.DoubleType, (int)16)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot bucket by type: double");
    }

    @Test
    public void testRegisterFloatBucketUDF() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket_float_16", (DataType)DataTypes.FloatType, (int)16)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot bucket by type: float");
    }

    @Test
    public void testRegisterIntegerTruncateUDF() {
        IcebergSpark.registerTruncateUDF((SparkSession)spark, (String)"iceberg_truncate_int_4", (DataType)DataTypes.IntegerType, (int)4);
        List results = spark.sql("SELECT iceberg_truncate_int_4(1)").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)Transforms.truncate((Type)Types.IntegerType.get(), (int)4).apply((Object)1), (Object)((Row)results.get(0)).getInt(0));
    }

    @Test
    public void testRegisterLongTruncateUDF() {
        IcebergSpark.registerTruncateUDF((SparkSession)spark, (String)"iceberg_truncate_long_4", (DataType)DataTypes.LongType, (int)4);
        List results = spark.sql("SELECT iceberg_truncate_long_4(1L)").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)Transforms.truncate((Type)Types.LongType.get(), (int)4).apply((Object)1L), (Object)((Row)results.get(0)).getLong(0));
    }

    @Test
    public void testRegisterDecimalTruncateUDF() {
        IcebergSpark.registerTruncateUDF((SparkSession)spark, (String)"iceberg_truncate_decimal_4", (DataType)new DecimalType(4, 2), (int)4);
        List results = spark.sql("SELECT iceberg_truncate_decimal_4(11.11)").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)Transforms.truncate((Type)Types.DecimalType.of((int)4, (int)2), (int)4).apply((Object)new BigDecimal("11.11")), (Object)((Row)results.get(0)).getDecimal(0));
    }

    @Test
    public void testRegisterStringTruncateUDF() {
        IcebergSpark.registerTruncateUDF((SparkSession)spark, (String)"iceberg_truncate_string_4", (DataType)DataTypes.StringType, (int)4);
        List results = spark.sql("SELECT iceberg_truncate_string_4('hello')").collectAsList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)Transforms.truncate((Type)Types.StringType.get(), (int)4).apply((Object)"hello"), (Object)((Row)results.get(0)).getString(0));
    }
}

