/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.SparkTestBase;
import org.apache.iceberg.spark.source.LogMessage;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestIdentityPartitionData
extends SparkTestBase {
    private static final Configuration CONF = new Configuration();
    private static final HadoopTables TABLES = new HadoopTables(CONF);
    private final String format;
    private final boolean vectorized;
    private static final Schema LOG_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"date", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"level", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"message", (Type)Types.StringType.get())});
    private static final List<LogMessage> LOGS = ImmutableList.of((Object)LogMessage.debug("2020-02-02", "debug event 1"), (Object)LogMessage.info("2020-02-02", "info event 1"), (Object)LogMessage.debug("2020-02-02", "debug event 2"), (Object)LogMessage.info("2020-02-03", "info event 2"), (Object)LogMessage.debug("2020-02-03", "debug event 3"), (Object)LogMessage.info("2020-02-03", "info event 3"), (Object)LogMessage.error("2020-02-03", "error event 1"), (Object)LogMessage.debug("2020-02-04", "debug event 4"), (Object)LogMessage.warn("2020-02-04", "warn event 1"), (Object)LogMessage.debug("2020-02-04", "debug event 5"));
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private PartitionSpec spec = PartitionSpec.builderFor((Schema)LOG_SCHEMA).identity("date").identity("level").build();
    private Table table = null;
    private Dataset<Row> logs = null;

    @Parameterized.Parameters(name="format = {0}, vectorized = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{"parquet", false}, {"parquet", true}, {"avro", false}, {"orc", false}, {"orc", true}};
    }

    public TestIdentityPartitionData(String format, boolean vectorized) {
        this.format = format;
        this.vectorized = vectorized;
    }

    private void setupParquet() throws Exception {
        File location = this.temp.newFolder("logs");
        File hiveLocation = this.temp.newFolder("hive");
        String hiveTable = "hivetable";
        Assert.assertTrue((String)"Temp folder should exist", (boolean)location.exists());
        ImmutableMap properties = ImmutableMap.of((Object)"write.format.default", (Object)this.format);
        this.logs = spark.createDataFrame(LOGS, LogMessage.class).select("id", new String[]{"date", "level", "message"});
        spark.sql(String.format("DROP TABLE IF EXISTS %s", hiveTable));
        this.logs.orderBy("date", new String[]{"level", "id"}).write().partitionBy(new String[]{"date", "level"}).format("parquet").option("path", hiveLocation.toString()).saveAsTable(hiveTable);
        this.table = TABLES.create(SparkSchemaUtil.schemaForTable((SparkSession)spark, (String)hiveTable), SparkSchemaUtil.specForTable((SparkSession)spark, (String)hiveTable), (Map)properties, location.toString());
        SparkTableUtil.importSparkTable((SparkSession)spark, (TableIdentifier)new TableIdentifier(hiveTable), (Table)this.table, (String)location.toString());
    }

    @Before
    public void setupTable() throws Exception {
        if (this.format.equals("parquet")) {
            this.setupParquet();
        } else {
            File location = this.temp.newFolder("logs");
            Assert.assertTrue((String)"Temp folder should exist", (boolean)location.exists());
            ImmutableMap properties = ImmutableMap.of((Object)"write.format.default", (Object)this.format);
            this.table = TABLES.create(LOG_SCHEMA, this.spec, (Map)properties, location.toString());
            this.logs = spark.createDataFrame(LOGS, LogMessage.class).select("id", new String[]{"date", "level", "message"});
            this.logs.orderBy("date", new String[]{"level", "id"}).write().format("iceberg").mode("append").save(location.toString());
        }
    }

    @Test
    public void testFullProjection() {
        List expected = this.logs.orderBy("id", new String[0]).collectAsList();
        List actual = spark.read().format("iceberg").option("vectorization-enabled", String.valueOf(this.vectorized)).load(this.table.location()).orderBy("id", new String[0]).select("id", new String[]{"date", "level", "message"}).collectAsList();
        Assert.assertEquals((String)"Rows should match", (Object)expected, (Object)actual);
    }

    @Test
    public void testProjections() {
        String[][] cases;
        for (Object[] objectArray : cases = new String[][]{{"date"}, {"level"}, {"message"}, {"date", "message"}, {"level", "message"}, {"date", "level"}, {"message", "date"}, {"message", "level"}, {"level", "date"}, {"date", "level", "message"}, {"level", "date", "message"}, {"date", "message", "level"}, {"level", "message", "date"}, {"message", "date", "level"}, {"message", "level", "date"}}) {
            List expected = this.logs.select("id", (String[])objectArray).orderBy("id", new String[0]).collectAsList();
            List actual = spark.read().format("iceberg").option("vectorization-enabled", String.valueOf(this.vectorized)).load(this.table.location()).select("id", (String[])objectArray).orderBy("id", new String[0]).collectAsList();
            Assert.assertEquals((String)("Rows should match for ordering: " + Arrays.toString(objectArray)), (Object)expected, (Object)actual);
        }
    }
}

