/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestMetadataTablesWithPartitionEvolution
extends SparkCatalogTestBase {
    private final FileFormat fileFormat;
    private final int formatVersion;

    @Parameterized.Parameters(name="catalog = {0}, impl = {1}, conf = {2}, fileFormat = {3}, formatVersion = {4}")
    public static Object[][] parameters() {
        return new Object[][]{{"testhive", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default"), FileFormat.ORC, 1}, {"testhive", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default"), FileFormat.ORC, 2}, {"testhadoop", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hadoop"), FileFormat.PARQUET, 1}, {"testhadoop", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hadoop"), FileFormat.PARQUET, 2}, {"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"clients", (Object)"1", (Object)"parquet-enabled", (Object)"false", (Object)"cache-enabled", (Object)"false"), FileFormat.AVRO, 1}, {"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"clients", (Object)"1", (Object)"parquet-enabled", (Object)"false", (Object)"cache-enabled", (Object)"false"), FileFormat.AVRO, 2}};
    }

    public TestMetadataTablesWithPartitionEvolution(String catalogName, String implementation, Map<String, String> config, FileFormat fileFormat, int formatVersion) {
        super(catalogName, implementation, config);
        this.fileFormat = fileFormat;
        this.formatVersion = formatVersion;
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testFilesMetadataTable() throws ParseException {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, data string) USING iceberg", this.tableName);
        this.initTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            Dataset<Row> df = this.loadMetadataTable(tableType);
            Assert.assertTrue((String)"Partition must be skipped", (boolean)df.schema().getFieldIndex("partition").isEmpty());
        }
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(new Object[]{null}), (Object)this.row("b1")), "STRUCT<data:STRING>", tableType);
        }
        table.updateSpec().addField((Term)Expressions.bucket((String)"category", (int)8)).commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8:INT>", tableType);
        }
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row(null, 2), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8:INT>", tableType);
        }
        table.updateSpec().renameField("category_bucket_8", "category_bucket_8_another_name").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row(null, 2), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8_another_name:INT>", tableType);
        }
    }

    @Test
    public void testFilesMetadataTableFilter() throws ParseException {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, data string) USING iceberg TBLPROPERTIES ('commit.manifest-merge.enabled' 'false')", this.tableName);
        this.initTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            Dataset<Row> df = this.loadMetadataTable(tableType);
            Assert.assertTrue((String)"Partition must be skipped", (boolean)df.schema().getFieldIndex("partition").isEmpty());
        }
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2")), "STRUCT<data:STRING>", tableType, "partition.data = 'd2'");
        }
        table.updateSpec().addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", tableType, "partition.data = 'd2'");
        }
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", tableType, "partition.category = 'c2'");
        }
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (3, 'c3', 'd2')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (4, 'c4', 'd2')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (5, 'c2', 'd5')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", tableType, "partition.data = 'd2'");
        }
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c2"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", tableType, "partition.category = 'c2'");
        }
        table.updateSpec().renameField("category", "category_another_name").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (6, 'c2', 'd6')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c2"), (Object)this.row(null, "c2"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category_another_name:STRING>", tableType, "partition.category_another_name = 'c2'");
        }
    }

    @Test
    public void testEntriesMetadataTable() throws ParseException {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, data string) USING iceberg", this.tableName);
        this.initTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            Dataset<Row> df = this.loadMetadataTable(tableType);
            StructType dataFileType = (StructType)df.schema().apply("data_file").dataType();
            Assert.assertTrue((String)"Partition must be skipped", (boolean)dataFileType.getFieldIndex("").isEmpty());
        }
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(new Object[]{null}), (Object)this.row("b1")), "STRUCT<data:STRING>", tableType);
        }
        table.updateSpec().addField((Term)Expressions.bucket((String)"category", (int)8)).commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8:INT>", tableType);
        }
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row(null, 2), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8:INT>", tableType);
        }
        table.updateSpec().renameField("category_bucket_8", "category_bucket_8_another_name").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row(null, 2), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8_another_name:INT>", tableType);
        }
    }

    @Test
    public void testPartitionsTableAddRemoveFields() throws ParseException {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, data string) USING iceberg ", this.tableName);
        this.initTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        Dataset<Row> df = this.loadMetadataTable(MetadataTableType.PARTITIONS);
        Assert.assertTrue((String)"Partition must be skipped", (boolean)df.schema().getFieldIndex("partition").isEmpty());
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(new Object[]{null}), (Object)this.row("d1"), (Object)this.row("d2")), "STRUCT<data:STRING>", MetadataTableType.PARTITIONS);
        table.updateSpec().addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row("d1", null), (Object)this.row("d1", "c1"), (Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row(null, "c1"), (Object)this.row(null, "c2"), (Object)this.row("d1", null), (Object)this.row("d1", "c1"), (Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
    }

    @Test
    public void testPartitionsTableRenameFields() throws ParseException {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, data string) USING iceberg", this.tableName);
        this.initTable();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d1", "c1"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
        table.updateSpec().renameField("category", "category_another_name").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d1", "c1"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category_another_name:STRING>", MetadataTableType.PARTITIONS);
    }

    @Test
    public void testPartitionsTableSwitchFields() throws Exception {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, data string) USING iceberg", this.tableName);
        this.initTable();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d1", "c1"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c1"), (Object)this.row(null, "c2"), (Object)this.row("d1", "c1"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (3, 'c3', 'd3')", this.tableName);
        if (this.formatVersion == 1) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c1", null), (Object)this.row(null, "c1", "d1"), (Object)this.row(null, "c2", null), (Object)this.row(null, "c2", "d2"), (Object)this.row(null, "c3", "d3"), (Object)this.row("d1", "c1", null), (Object)this.row("d2", "c2", null)), "STRUCT<data_1000:STRING,category:STRING,data:STRING>", MetadataTableType.PARTITIONS);
        } else {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c1"), (Object)this.row(null, "c2"), (Object)this.row("d1", "c1"), (Object)this.row("d2", "c2"), (Object)this.row("d3", "c3")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
        }
    }

    @Test
    public void testPartitionTableFilterAddRemoveFields() throws ParseException {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, data string) USING iceberg", this.tableName);
        this.initTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2")), "STRUCT<data:STRING>", MetadataTableType.PARTITIONS, "partition.data = 'd2'");
        table.updateSpec().addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS, "partition.data = 'd2'");
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS, "partition.category = 'c2'");
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (3, 'c3', 'd2')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (4, 'c4', 'd2')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (5, 'c2', 'd5')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS, "partition.data = 'd2'");
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c2"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS, "partition.category = 'c2'");
    }

    @Test
    public void testPartitionTableFilterSwitchFields() throws Exception {
        Assume.assumeTrue((this.formatVersion == 1 ? 1 : 0) != 0);
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, data string) USING iceberg", this.tableName);
        this.initTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c2", null), (Object)this.row(null, "c2", "d2"), (Object)this.row("d2", "c2", null)), "STRUCT<data_1000:STRING,category:STRING,data:STRING>", MetadataTableType.PARTITIONS, "partition.category = 'c2'");
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c1", "d1")), "STRUCT<data_1000:STRING,category:STRING,data:STRING>", MetadataTableType.PARTITIONS, "partition.data = 'd1'");
    }

    @Test
    public void testPartitionsTableFilterRenameFields() throws ParseException {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, data string) USING iceberg", this.tableName);
        this.initTable();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        table.updateSpec().renameField("category", "category_another_name").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d1", "c1")), "STRUCT<data:STRING,category_another_name:STRING>", MetadataTableType.PARTITIONS, "partition.category_another_name = 'c1'");
    }

    @Test
    public void testMetadataTablesWithUnknownTransforms() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, data string) USING iceberg", this.tableName);
        this.initTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        PartitionSpec unknownSpec = PartitionSpecParser.fromJson((Schema)table.schema(), (String)"{ \"spec-id\": 1, \"fields\": [ { \"name\": \"id_zero\", \"transform\": \"zero\", \"source-id\": 1 } ] }");
        TableOperations ops = ((HasTableOperations)table).operations();
        TableMetadata base = ops.current();
        ops.commit(base, base.updatePartitionSpec(unknownSpec));
        this.sql("REFRESH TABLE %s", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES, MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            AssertHelpers.assertThrows((String)"Should complain about the partition type", ValidationException.class, (String)"Cannot build table partition type, unknown transforms", () -> this.loadMetadataTable(tableType));
        }
    }

    @Test
    public void testPartitionColumnNamedPartition() {
        this.sql("CREATE TABLE %s (id int, partition int) USING iceberg PARTITIONED BY (partition)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, 1), (2, 1), (3, 2), (2, 2)", this.tableName);
        ImmutableList expected = ImmutableList.of((Object)this.row(1, 1), (Object)this.row(2, 1), (Object)this.row(3, 2), (Object)this.row(2, 2));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT * FROM %s", this.tableName));
        Assert.assertEquals((long)2L, (long)this.sql("SELECT * FROM %s.files", this.tableName).size());
    }

    private void assertPartitions(List<Object[]> expectedPartitions, String expectedTypeAsString, MetadataTableType tableType) throws ParseException {
        this.assertPartitions(expectedPartitions, expectedTypeAsString, tableType, null);
    }

    private void assertPartitions(List<Object[]> expectedPartitions, String expectedTypeAsString, MetadataTableType tableType, String filter) throws ParseException {
        Dataset df = this.loadMetadataTable(tableType);
        if (filter != null) {
            df = df.filter(filter);
        }
        DataType expectedType = spark.sessionState().sqlParser().parseDataType(expectedTypeAsString);
        switch (tableType) {
            case PARTITIONS: 
            case FILES: 
            case ALL_DATA_FILES: {
                DataType actualFilesType = df.schema().apply("partition").dataType();
                Assert.assertEquals((String)"Partition type must match", (Object)expectedType, (Object)actualFilesType);
                break;
            }
            case ENTRIES: 
            case ALL_ENTRIES: {
                StructType dataFileType = (StructType)df.schema().apply("data_file").dataType();
                DataType actualEntriesType = dataFileType.apply("partition").dataType();
                Assert.assertEquals((String)"Partition type must match", (Object)expectedType, (Object)actualEntriesType);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported metadata table type: " + tableType);
            }
        }
        switch (tableType) {
            case PARTITIONS: 
            case FILES: 
            case ALL_DATA_FILES: {
                List actualFilesPartitions = df.orderBy("partition", new String[0]).select("partition.*", new String[0]).collectAsList();
                this.assertEquals("Partitions must match", expectedPartitions, this.rowsToJava(actualFilesPartitions));
                break;
            }
            case ENTRIES: 
            case ALL_ENTRIES: {
                List actualEntriesPartitions = df.orderBy("data_file.partition", new String[0]).select("data_file.partition.*", new String[0]).collectAsList();
                this.assertEquals("Partitions must match", expectedPartitions, this.rowsToJava(actualEntriesPartitions));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported metadata table type: " + tableType);
            }
        }
    }

    private Dataset<Row> loadMetadataTable(MetadataTableType tableType) {
        return spark.read().format("iceberg").load(this.tableName + "." + tableType.name());
    }

    private void initTable() {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", this.tableName, "write.format.default", this.fileFormat.name());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%d')", this.tableName, "format-version", this.formatVersion);
    }
}

