/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.spark.source.TestTables;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.TableCatalog;

public class TestSparkCatalog<T extends TableCatalog & SupportsNamespaces>
extends SparkSessionCatalog<T> {
    private static final Map<Identifier, org.apache.spark.sql.connector.catalog.Table> tableMap = Maps.newHashMap();

    public static void setTable(Identifier ident, org.apache.spark.sql.connector.catalog.Table table) {
        Preconditions.checkArgument((!tableMap.containsKey(ident) ? 1 : 0) != 0, (Object)("Cannot set " + ident + ". It is already set"));
        tableMap.put(ident, table);
    }

    public org.apache.spark.sql.connector.catalog.Table loadTable(Identifier ident) throws NoSuchTableException {
        if (tableMap.containsKey(ident)) {
            return tableMap.get(ident);
        }
        TableIdentifier tableIdentifier = Spark3Util.identifierToTableIdentifier((Identifier)ident);
        Namespace namespace = tableIdentifier.namespace();
        TestTables.TestTable table = TestTables.load(tableIdentifier.toString());
        if (table == null && namespace.equals((Object)Namespace.of((String[])new String[]{"default"}))) {
            table = TestTables.load(tableIdentifier.name());
        }
        return new SparkTable((Table)table, false);
    }

    public static void clearTables() {
        tableMap.clear();
    }
}

