/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDeleteFrom
extends SparkCatalogTestBase {
    public TestDeleteFrom(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testDeleteFromUnpartitionedTable() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "c")});
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.coalesce(1).writeTo(this.tableName).append();
        this.assertEquals("Should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c")), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        AssertHelpers.assertThrows((String)"Should not delete when not all rows of a file match the filter", AnalysisException.class, (String)"Cannot delete from", () -> this.sql("DELETE FROM %s WHERE id < 2", this.tableName));
        this.sql("DELETE FROM %s WHERE id < 4", this.tableName);
        this.assertEquals("Should have no rows after successful delete", (List<Object[]>)ImmutableList.of(), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @Test
    public void testDeleteFromTableAtSnapshot() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "c")});
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.coalesce(1).writeTo(this.tableName).append();
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        String prefix = "snapshot_id_";
        AssertHelpers.assertThrows((String)"Should not be able to delete from a table at a specific snapshot", IllegalArgumentException.class, (String)"Cannot delete from table at a specific snapshot", () -> this.sql("DELETE FROM %s.%s WHERE id < 4", this.tableName, prefix + snapshotId));
    }

    @Test
    public void testDeleteFromPartitionedTable() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (truncate(id, 2))", this.tableName);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "c")});
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.coalesce(1).writeTo(this.tableName).append();
        this.assertEquals("Should have 3 rows in 2 partitions", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c")), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        AssertHelpers.assertThrows((String)"Should not delete when not all rows of a file match the filter", AnalysisException.class, (String)"Cannot delete from table", () -> this.sql("DELETE FROM %s WHERE id > 2", this.tableName));
        this.sql("DELETE FROM %s WHERE id < 2", this.tableName);
        this.assertEquals("Should have two rows in the second partition", (List<Object[]>)ImmutableList.of((Object)this.row(2L, "b"), (Object)this.row(3L, "c")), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @Test
    public void testDeleteFromWhereFalse() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a'), (2, 'b'), (3, 'c')", this.tableName);
        this.assertEquals("Should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c")), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 1 snapshot", (long)1L, (long)Iterables.size((Iterable)table.snapshots()));
        this.sql("DELETE FROM %s WHERE false", this.tableName);
        table.refresh();
        Assert.assertEquals((String)"Delete should not produce a new snapshot", (long)1L, (long)Iterables.size((Iterable)table.snapshots()));
    }

    @Test
    public void testTruncate() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a'), (2, 'b'), (3, 'c')", this.tableName);
        this.assertEquals("Should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c")), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 1 snapshot", (long)1L, (long)Iterables.size((Iterable)table.snapshots()));
        this.sql("TRUNCATE TABLE %s", this.tableName);
        this.assertEquals("Should have expected rows", (List<Object[]>)ImmutableList.of(), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }
}

