/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.functions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPartitionedWrites
extends SparkCatalogTestBase {
    public TestPartitionedWrites(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Before
    public void createTables() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (truncate(id, 3))", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, 'a'), (2, 'b'), (3, 'c')", this.tableName);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testInsertAppend() {
        Assert.assertEquals((String)"Should have 3 rows", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.tableName));
        this.sql("INSERT INTO %s VALUES (4, 'd'), (5, 'e')", this.tableName);
        Assert.assertEquals((String)"Should have 5 rows after insert", (Object)5L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.tableName));
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @Test
    public void testInsertOverwrite() {
        Assert.assertEquals((String)"Should have 3 rows", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.tableName));
        this.sql("INSERT OVERWRITE %s VALUES (4, 'd'), (5, 'e')", this.tableName);
        Assert.assertEquals((String)"Should have 4 rows after overwrite", (Object)4L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.tableName));
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @Test
    public void testDataFrameV2Append() throws NoSuchTableException {
        Assert.assertEquals((String)"Should have 3 rows", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.tableName));
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.tableName).append();
        Assert.assertEquals((String)"Should have 5 rows after insert", (Object)5L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.tableName));
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @Test
    public void testDataFrameV2DynamicOverwrite() throws NoSuchTableException {
        Assert.assertEquals((String)"Should have 3 rows", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.tableName));
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.tableName).overwritePartitions();
        Assert.assertEquals((String)"Should have 4 rows after overwrite", (Object)4L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.tableName));
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @Test
    public void testDataFrameV2Overwrite() throws NoSuchTableException {
        Assert.assertEquals((String)"Should have 3 rows", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.tableName));
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.tableName).overwrite(functions.col((String)"id").$less((Object)3));
        Assert.assertEquals((String)"Should have 3 rows after overwrite", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.tableName));
        ImmutableList expected = ImmutableList.of((Object)this.row(3L, "c"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @Test
    public void testViewsReturnRecentResults() {
        Assert.assertEquals((String)"Should have 3 rows", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.tableName));
        Dataset query = spark.sql("SELECT * FROM " + this.tableName + " WHERE id = 1");
        query.createOrReplaceTempView("tmp");
        this.assertEquals("View should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a")), this.sql("SELECT * FROM tmp", new Object[0]));
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", this.tableName);
        this.assertEquals("View should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(1L, "a")), this.sql("SELECT * FROM tmp", new Object[0]));
    }

    @Test
    public void testWriteWithOutputSpec() throws NoSuchTableException {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
        int originalSpecId = table.spec().specId();
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(10, "a"));
        spark.createDataFrame((List)data, SimpleRecord.class).toDF().writeTo(this.tableName).append();
        ImmutableList expected = ImmutableList.of((Object)this.row(10L, "a", table.spec().specId()));
        this.assertEquals("Rows must match", (List<Object[]>)expected, this.sql("SELECT id, data, _spec_id FROM %s WHERE id >= 10 ORDER BY id", this.tableName));
        data = ImmutableList.of((Object)new SimpleRecord(11, "b"), (Object)new SimpleRecord(12, "c"));
        spark.createDataFrame((List)data, SimpleRecord.class).toDF().writeTo(this.tableName).option("output-spec-id", Integer.toString(originalSpecId)).append();
        expected = ImmutableList.of((Object)this.row(10L, "a", table.spec().specId()), (Object)this.row(11L, "b", originalSpecId), (Object)this.row(12L, "c", originalSpecId));
        this.assertEquals("Rows must match", (List<Object[]>)expected, this.sql("SELECT id, data, _spec_id FROM %s WHERE id >= 10 ORDER BY id", this.tableName));
        Dataset actualPartitionRows = spark.read().format("iceberg").load(this.tableName + ".partitions").select("spec_id", new String[]{"partition.id_trunc", "partition.data"}).orderBy("spec_id", new String[]{"partition.id_trunc"});
        expected = ImmutableList.of((Object)this.row(originalSpecId, 9L, null), (Object)this.row(originalSpecId, 12L, null), (Object)this.row(table.spec().specId(), 9L, "a"));
        this.assertEquals("There are 3 partitions, one with the original spec ID and two with the new one", (List<Object[]>)expected, this.rowsToJava(actualPartitionRows.collectAsList()));
        data = ImmutableList.of((Object)new SimpleRecord(13, "d"));
        spark.createDataFrame((List)data, SimpleRecord.class).toDF().writeTo(this.tableName).option("output-spec-id", Integer.toString(table.spec().specId())).append();
        expected = ImmutableList.of((Object)this.row(10L, "a", table.spec().specId()), (Object)this.row(11L, "b", originalSpecId), (Object)this.row(12L, "c", originalSpecId), (Object)this.row(13L, "d", table.spec().specId()));
        this.assertEquals("Rows must match", (List<Object[]>)expected, this.sql("SELECT id, data, _spec_id FROM %s WHERE id >= 10 ORDER BY id", this.tableName));
    }
}

