/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.events.ScanEvent;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.spark.sql.Dataset;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestSelect
extends SparkCatalogTestBase {
    private int scanEventCount = 0;
    private ScanEvent lastScanEvent = null;
    private String binaryTableName = this.tableName("binary_table");

    public TestSelect(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
        Listeners.register(event -> {
            ++this.scanEventCount;
            this.lastScanEvent = event;
        }, ScanEvent.class);
    }

    @Before
    public void createTables() {
        this.sql("CREATE TABLE %s (id bigint, data string, float float) USING iceberg", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, 'a', 1.0), (2, 'b', 2.0), (3, 'c', float('NaN'))", this.tableName);
        this.scanEventCount = 0;
        this.lastScanEvent = null;
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        this.sql("DROP TABLE IF EXISTS %s", this.binaryTableName);
    }

    @Test
    public void testSelect() {
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a", Float.valueOf(1.0f)), (Object)this.row(2L, "b", Float.valueOf(2.0f)), (Object)this.row(3L, "c", Float.valueOf(Float.NaN)));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT * FROM %s", this.tableName));
    }

    @Test
    public void testSelectRewrite() {
        ImmutableList expected = ImmutableList.of((Object)this.row(3L, "c", Float.valueOf(Float.NaN)));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT * FROM %s where float = float('NaN')", this.tableName));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should push down expected filter", (Object)"(float IS NOT NULL AND is_nan(float))", (Object)Spark3Util.describe((Expression)this.lastScanEvent.filter()));
    }

    @Test
    public void testProjection() {
        ImmutableList expected = ImmutableList.of((Object)this.row(1L), (Object)this.row(2L), (Object)this.row(3L));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT id FROM %s", this.tableName));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should not push down a filter", (Object)Expressions.alwaysTrue(), (Object)this.lastScanEvent.filter());
        Assert.assertEquals((String)"Should project only the id column", (Object)this.validationCatalog.loadTable(this.tableIdent).schema().select(new String[]{"id"}).asStruct(), (Object)this.lastScanEvent.projection().asStruct());
    }

    @Test
    public void testExpressionPushdown() {
        ImmutableList expected = ImmutableList.of((Object)this.row("b"));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT data FROM %s WHERE id = 2", this.tableName));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should push down expected filter", (Object)"(id IS NOT NULL AND id = 2)", (Object)Spark3Util.describe((Expression)this.lastScanEvent.filter()));
        Assert.assertEquals((String)"Should project only id and data columns", (Object)this.validationCatalog.loadTable(this.tableIdent).schema().select(new String[]{"id", "data"}).asStruct(), (Object)this.lastScanEvent.projection().asStruct());
    }

    @Test
    public void testMetadataTables() {
        Assume.assumeFalse((String)"Spark session catalog does not support metadata tables", (boolean)"spark_catalog".equals(this.catalogName));
        this.assertEquals("Snapshot metadata table", (List<Object[]>)ImmutableList.of((Object)this.row(ANY, ANY, null, "append", ANY, ANY)), this.sql("SELECT * FROM %s.snapshots", this.tableName));
    }

    @Test
    public void testSnapshotInTableName() {
        Assume.assumeFalse((String)"Spark session catalog does not support extended table names", (boolean)"spark_catalog".equals(this.catalogName));
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        List<Object[]> expected = this.sql("SELECT * FROM %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        String prefix = "snapshot_id_";
        List<Object[]> actual = this.sql("SELECT * FROM %s.%s", this.tableName, prefix + snapshotId);
        this.assertEquals("Snapshot at specific ID, prefix " + prefix, expected, actual);
        Dataset df = spark.read().format("iceberg").option("snapshot-id", snapshotId).load(this.tableName);
        List<Object[]> fromDF = this.rowsToJava(df.collectAsList());
        this.assertEquals("Snapshot at specific ID " + snapshotId, expected, fromDF);
    }

    @Test
    public void testTimestampInTableName() {
        Assume.assumeFalse((String)"Spark session catalog does not support extended table names", (boolean)"spark_catalog".equals(this.catalogName));
        long snapshotTs = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().timestampMillis();
        long timestamp = this.waitUntilAfter(snapshotTs + 2L);
        List<Object[]> expected = this.sql("SELECT * FROM %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        String prefix = "at_timestamp_";
        List<Object[]> actual = this.sql("SELECT * FROM %s.%s", this.tableName, prefix + timestamp);
        this.assertEquals("Snapshot at timestamp, prefix " + prefix, expected, actual);
        Dataset df = spark.read().format("iceberg").option("as-of-timestamp", timestamp).load(this.tableName);
        List<Object[]> fromDF = this.rowsToJava(df.collectAsList());
        this.assertEquals("Snapshot at timestamp " + timestamp, expected, fromDF);
    }

    @Test
    public void testSpecifySnapshotAndTimestamp() {
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        long timestamp = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().timestampMillis() + 2L;
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        AssertHelpers.assertThrows((String)"Should not be able to specify both snapshot id and timestamp", IllegalArgumentException.class, (String)String.format("Cannot specify both snapshot-id (%s) and as-of-timestamp (%s)", snapshotId, timestamp), () -> spark.read().format("iceberg").option("snapshot-id", snapshotId).option("as-of-timestamp", timestamp).load(this.tableName).collectAsList());
    }

    @Test
    public void testBinaryInFilter() {
        this.sql("CREATE TABLE %s (id bigint, binary binary) USING iceberg", this.binaryTableName);
        this.sql("INSERT INTO %s VALUES (1, X''), (2, X'1111'), (3, X'11')", this.binaryTableName);
        ImmutableList expected = ImmutableList.of((Object)this.row(2L, new byte[]{17, 17}));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT id, binary FROM %s where binary > X'11'", this.binaryTableName));
    }

    @Test
    public void testComplexTypeFilter() {
        String complexTypeTableName = this.tableName("complex_table");
        this.sql("CREATE TABLE %s (id INT, complex STRUCT<c1:INT,c2:STRING>) USING iceberg", complexTypeTableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, named_struct(\"c1\", 3, \"c2\", \"v1\"))", complexTypeTableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, named_struct(\"c1\", 2, \"c2\", \"v2\"))", complexTypeTableName);
        List<Object[]> result = this.sql("SELECT id FROM %s WHERE complex = named_struct(\"c1\", 3, \"c2\", \"v1\")", complexTypeTableName);
        this.assertEquals("Should return all expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1)), result);
        this.sql("DROP TABLE IF EXISTS %s", complexTypeTableName);
    }
}

