/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import org.apache.iceberg.Table;
import org.apache.iceberg.actions.ExpireSnapshots;
import org.apache.iceberg.io.SupportsBulkOperations;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.actions.ExpireSnapshotsSparkAction;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireSnapshotsProcedure
extends BaseProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(ExpireSnapshotsProcedure.class);
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("older_than", DataTypes.TimestampType), ProcedureParameter.optional("retain_last", DataTypes.IntegerType), ProcedureParameter.optional("max_concurrent_deletes", DataTypes.IntegerType), ProcedureParameter.optional("stream_results", DataTypes.BooleanType), ProcedureParameter.optional("snapshot_ids", (DataType)DataTypes.createArrayType((DataType)DataTypes.LongType))};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("deleted_data_files_count", DataTypes.LongType, true, Metadata.empty()), new StructField("deleted_position_delete_files_count", DataTypes.LongType, true, Metadata.empty()), new StructField("deleted_equality_delete_files_count", DataTypes.LongType, true, Metadata.empty()), new StructField("deleted_manifest_files_count", DataTypes.LongType, true, Metadata.empty()), new StructField("deleted_manifest_lists_count", DataTypes.LongType, true, Metadata.empty()), new StructField("deleted_statistics_files_count", DataTypes.LongType, true, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<ExpireSnapshotsProcedure>(){

            @Override
            protected ExpireSnapshotsProcedure doBuild() {
                return new ExpireSnapshotsProcedure(this.tableCatalog());
            }
        };
    }

    private ExpireSnapshotsProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        Long olderThanMillis = args.isNullAt(1) ? null : Long.valueOf(DateTimeUtil.microsToMillis((long)args.getLong(1)));
        Integer retainLastNum = args.isNullAt(2) ? null : Integer.valueOf(args.getInt(2));
        Integer maxConcurrentDeletes = args.isNullAt(3) ? null : Integer.valueOf(args.getInt(3));
        Boolean streamResult = args.isNullAt(4) ? null : Boolean.valueOf(args.getBoolean(4));
        long[] snapshotIds = args.isNullAt(5) ? null : args.getArray(5).toLongArray();
        Preconditions.checkArgument((maxConcurrentDeletes == null || maxConcurrentDeletes > 0 ? 1 : 0) != 0, (String)"max_concurrent_deletes should have value > 0, value: %s", (Object)maxConcurrentDeletes);
        return this.modifyIcebergTable(tableIdent, table -> {
            ExpireSnapshotsSparkAction action = this.actions().expireSnapshots((Table)table);
            if (olderThanMillis != null) {
                action.expireOlderThan(olderThanMillis);
            }
            if (retainLastNum != null) {
                action.retainLast(retainLastNum);
            }
            if (maxConcurrentDeletes != null) {
                if (table.io() instanceof SupportsBulkOperations) {
                    LOG.warn("max_concurrent_deletes only works with FileIOs that do not support bulk deletes. Thistable is currently using {} which supports bulk deletes so the parameter will be ignored. See that IO's documentation to learn how to adjust parallelism for that particular IO's bulk delete.", (Object)table.io().getClass().getName());
                } else {
                    action.executeDeleteWith(this.executorService(maxConcurrentDeletes, "expire-snapshots"));
                }
            }
            if (snapshotIds != null) {
                for (long snapshotId : snapshotIds) {
                    action.expireSnapshotId(snapshotId);
                }
            }
            if (streamResult != null) {
                action.option("stream-results", Boolean.toString(streamResult));
            }
            ExpireSnapshots.Result result = (ExpireSnapshots.Result)action.execute();
            return this.toOutputRows(result);
        });
    }

    private InternalRow[] toOutputRows(ExpireSnapshots.Result result) {
        InternalRow row = this.newInternalRow(result.deletedDataFilesCount(), result.deletedPositionDeleteFilesCount(), result.deletedEqualityDeleteFilesCount(), result.deletedManifestsCount(), result.deletedManifestListsCount(), result.deletedStatisticsFilesCount());
        return new InternalRow[]{row};
    }

    @Override
    public String description() {
        return "ExpireSnapshotProcedure";
    }
}

