/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.iceberg.AddedRowsScanTask;
import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.ChangelogUtil;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeletedDataFileScanTask;
import org.apache.iceberg.DeletedRowsScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.source.BaseReader;
import org.apache.iceberg.spark.source.BaseRowReader;
import org.apache.spark.rdd.InputFileBlockHolder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.unsafe.types.UTF8String;

class ChangelogRowReader
extends BaseRowReader<ChangelogScanTask> {
    ChangelogRowReader(Table table, ScanTaskGroup<ChangelogScanTask> taskGroup, Schema expectedSchema, boolean caseSensitive) {
        super(table, taskGroup, ChangelogUtil.dropChangelogMetadata((Schema)expectedSchema), caseSensitive);
    }

    @Override
    protected CloseableIterator<InternalRow> open(ChangelogScanTask task) {
        JoinedRow cdcRow = new JoinedRow();
        cdcRow.withRight(ChangelogRowReader.changelogMetadata(task));
        CloseableIterable<InternalRow> rows = this.openChangelogScanTask(task);
        CloseableIterable cdcRows = CloseableIterable.transform(rows, arg_0 -> ((JoinedRow)cdcRow).withLeft(arg_0));
        return cdcRows.iterator();
    }

    private static InternalRow changelogMetadata(ChangelogScanTask task) {
        GenericInternalRow metadataRow = new GenericInternalRow(3);
        metadataRow.update(0, (Object)UTF8String.fromString((String)task.operation().name()));
        metadataRow.update(1, (Object)task.changeOrdinal());
        metadataRow.update(2, (Object)task.commitSnapshotId());
        return metadataRow;
    }

    private CloseableIterable<InternalRow> openChangelogScanTask(ChangelogScanTask task) {
        if (task instanceof AddedRowsScanTask) {
            return this.openAddedRowsScanTask((AddedRowsScanTask)task);
        }
        if (task instanceof DeletedRowsScanTask) {
            throw new UnsupportedOperationException("Deleted rows scan task is not supported yet");
        }
        if (task instanceof DeletedDataFileScanTask) {
            return this.openDeletedDataFileScanTask((DeletedDataFileScanTask)task);
        }
        throw new IllegalArgumentException("Unsupported changelog scan task type: " + task.getClass().getName());
    }

    CloseableIterable<InternalRow> openAddedRowsScanTask(AddedRowsScanTask task) {
        String filePath = ((DataFile)task.file()).path().toString();
        BaseReader.SparkDeleteFilter deletes = new BaseReader.SparkDeleteFilter(filePath, task.deletes(), this.counter());
        return deletes.filter(this.rows((ContentScanTask<DataFile>)task, deletes.requiredSchema()));
    }

    private CloseableIterable<InternalRow> openDeletedDataFileScanTask(DeletedDataFileScanTask task) {
        String filePath = ((DataFile)task.file()).path().toString();
        BaseReader.SparkDeleteFilter deletes = new BaseReader.SparkDeleteFilter(filePath, task.existingDeletes(), this.counter());
        return deletes.filter(this.rows((ContentScanTask<DataFile>)task, deletes.requiredSchema()));
    }

    private CloseableIterable<InternalRow> rows(ContentScanTask<DataFile> task, Schema readSchema) {
        Map<Integer, DataFile> idToConstant = this.constantsMap(task, readSchema);
        String filePath = ((DataFile)task.file()).path().toString();
        InputFileBlockHolder.set((String)filePath, (long)task.start(), (long)task.length());
        InputFile location = this.getInputFile(filePath);
        Preconditions.checkNotNull((Object)location, (Object)"Could not find InputFile");
        return this.newIterable(location, ((DataFile)task.file()).format(), task.start(), task.length(), task.residual(), readSchema, idToConstant);
    }

    @Override
    protected Stream<ContentFile<?>> referencedFiles(ChangelogScanTask task) {
        if (task instanceof AddedRowsScanTask) {
            return ChangelogRowReader.addedRowsScanTaskFiles((AddedRowsScanTask)task);
        }
        if (task instanceof DeletedRowsScanTask) {
            throw new UnsupportedOperationException("Deleted rows scan task is not supported yet");
        }
        if (task instanceof DeletedDataFileScanTask) {
            return ChangelogRowReader.deletedDataFileScanTaskFiles((DeletedDataFileScanTask)task);
        }
        throw new IllegalArgumentException("Unsupported changelog scan task type: " + task.getClass().getName());
    }

    private static Stream<ContentFile<?>> deletedDataFileScanTaskFiles(DeletedDataFileScanTask task) {
        DeletedDataFileScanTask deletedDataFileScanTask = task;
        DataFile file = (DataFile)deletedDataFileScanTask.file();
        List existingDeletes = deletedDataFileScanTask.existingDeletes();
        return Stream.concat(Stream.of(file), existingDeletes.stream());
    }

    private static Stream<ContentFile<?>> addedRowsScanTaskFiles(AddedRowsScanTask task) {
        AddedRowsScanTask addedRowsScanTask = task;
        DataFile file = (DataFile)addedRowsScanTask.file();
        List deletes = addedRowsScanTask.deletes();
        return Stream.concat(Stream.of(file), deletes.stream());
    }
}

