/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.spark.SparkFilters;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.CommandExecutionMode$;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class SparkExpressionConverter$ {
    public static SparkExpressionConverter$ MODULE$;

    static {
        new SparkExpressionConverter$();
    }

    public Expression convertToIcebergExpression(org.apache.spark.sql.catalyst.expressions.Expression sparkExpression) {
        Option option = DataSourceStrategy$.MODULE$.translateFilter(sparkExpression, true);
        if (option instanceof Some) {
            Some some = (Some)option;
            org.apache.spark.sql.sources.Filter filter = (org.apache.spark.sql.sources.Filter)some.value();
            Expression converted = SparkFilters.convert(filter);
            if (converted == null) {
                throw new IllegalArgumentException(new StringBuilder(51).append("Cannot convert Spark filter: ").append(filter).append(" to Iceberg expression").toString());
            }
            return converted;
        }
        throw new IllegalArgumentException(new StringBuilder(57).append("Cannot translate Spark expression: ").append(sparkExpression).append(" to data source filter").toString());
    }

    public org.apache.spark.sql.catalyst.expressions.Expression collectResolvedSparkExpression(SparkSession session, String tableName, String where) throws AnalysisException {
        ObjectRef expression = ObjectRef.create(null);
        String prefix = String.format("SELECT 42 from %s where ", tableName);
        LogicalPlan logicalPlan = session.sessionState().sqlParser().parsePlan(new StringBuilder(0).append(prefix).append(where).toString());
        LogicalPlan optimizedLogicalPlan = session.sessionState().executePlan(logicalPlan, CommandExecutionMode$.MODULE$.ALL()).optimizedPlan();
        optimizedLogicalPlan.collectFirst((PartialFunction)new Serializable(expression){
            public static final long serialVersionUID = 0L;
            private final ObjectRef expression$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Filter) {
                    Filter filter = (Filter)A1;
                    this.expression$1.elem = (org.apache.spark.sql.catalyst.expressions.Expression)filter.expressions().head();
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof Filter;
            }
            {
                this.expression$1 = expression$1;
            }
        });
        return (org.apache.spark.sql.catalyst.expressions.Expression)expression.elem;
    }

    private SparkExpressionConverter$() {
        MODULE$ = this;
    }
}

