/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.ExceptionUtil;

public class CommitMetadata {
    private static final ThreadLocal<Map<String, String>> COMMIT_PROPERTIES = ThreadLocal.withInitial(ImmutableMap::of);

    private CommitMetadata() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, E extends Exception> R withCommitProperties(Map<String, String> properties, Callable<R> callable, Class<E> exClass) throws E {
        COMMIT_PROPERTIES.set(properties);
        try {
            R r = callable.call();
            return r;
        }
        catch (Throwable e) {
            ExceptionUtil.castAndThrow((Throwable)e, exClass);
            R r = null;
            return r;
        }
        finally {
            COMMIT_PROPERTIES.set((Map<String, String>)ImmutableMap.of());
        }
    }

    public static Map<String, String> commitProperties() {
        return COMMIT_PROPERTIES.get();
    }
}

