/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.RewriteStrategy;
import org.apache.iceberg.actions.SortStrategy;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.spark.FileRewriteCoordinator;
import org.apache.iceberg.spark.FileScanTaskSetManager;
import org.apache.iceberg.spark.SparkDistributionAndOrderingUtil;
import org.apache.iceberg.spark.SparkTableCache;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SortOrderUtil;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.utils.DistributionAndOrderingUtils$;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.internal.SQLConf;

public class SparkSortStrategy
extends SortStrategy {
    public static final String COMPRESSION_FACTOR = "compression-factor";
    private final Table table;
    private final SparkSession spark;
    private final SparkTableCache tableCache = SparkTableCache.get();
    private final FileScanTaskSetManager manager = FileScanTaskSetManager.get();
    private final FileRewriteCoordinator rewriteCoordinator = FileRewriteCoordinator.get();
    private double sizeEstimateMultiple;

    public SparkSortStrategy(Table table, SparkSession spark) {
        this.table = table;
        this.spark = spark;
    }

    public Table table() {
        return this.table;
    }

    public Set<String> validOptions() {
        return ImmutableSet.builder().addAll((Iterable)super.validOptions()).add((Object)COMPRESSION_FACTOR).build();
    }

    public RewriteStrategy options(Map<String, String> options) {
        this.sizeEstimateMultiple = PropertyUtil.propertyAsDouble(options, (String)COMPRESSION_FACTOR, (double)1.0);
        Preconditions.checkArgument((this.sizeEstimateMultiple > 0.0 ? 1 : 0) != 0, (String)"Invalid compression factor: %s (not positive)", (Object)this.sizeEstimateMultiple);
        return super.options(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataFile> rewriteFiles(List<FileScanTask> filesToRewrite) {
        String groupID = UUID.randomUUID().toString();
        boolean requiresRepartition = !filesToRewrite.get(0).spec().equals((Object)this.table.spec());
        org.apache.spark.sql.connector.expressions.SortOrder[] ordering = requiresRepartition ? SparkDistributionAndOrderingUtil.convert(SortOrderUtil.buildSortOrder((Table)this.table, (SortOrder)this.sortOrder())) : SparkDistributionAndOrderingUtil.convert(this.sortOrder());
        OrderedDistribution distribution = Distributions.ordered((org.apache.spark.sql.connector.expressions.SortOrder[])ordering);
        try {
            this.tableCache.add(groupID, this.table);
            this.manager.stageTasks(this.table, groupID, filesToRewrite);
            SparkSession cloneSession = this.spark.cloneSession();
            cloneSession.conf().set(SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), false);
            long numOutputFiles = this.numOutputFiles((long)((double)this.inputFileSize(filesToRewrite) * this.sizeEstimateMultiple));
            cloneSession.conf().set(SQLConf.SHUFFLE_PARTITIONS().key(), Math.max(1L, numOutputFiles));
            Dataset scanDF = cloneSession.read().format("iceberg").option("file-scan-task-set-id", groupID).load(groupID);
            SQLConf sqlConf = cloneSession.sessionState().conf();
            LogicalPlan sortPlan = this.sortPlan((Distribution)distribution, ordering, scanDF.logicalPlan(), sqlConf);
            Dataset sortedDf = new Dataset(cloneSession, sortPlan, scanDF.encoder());
            sortedDf.write().format("iceberg").option("rewritten-file-scan-task-set-id", groupID).option("target-file-size-bytes", this.writeMaxFileSize()).option("use-table-distribution-and-ordering", "false").mode("append").save(groupID);
            Set<DataFile> set = this.rewriteCoordinator.fetchNewDataFiles(this.table, groupID);
            return set;
        }
        finally {
            this.tableCache.remove(groupID);
            this.manager.removeTasks(this.table, groupID);
            this.rewriteCoordinator.clearRewrite(this.table, groupID);
        }
    }

    protected SparkSession spark() {
        return this.spark;
    }

    protected LogicalPlan sortPlan(Distribution distribution, org.apache.spark.sql.connector.expressions.SortOrder[] ordering, LogicalPlan plan, SQLConf conf) {
        return DistributionAndOrderingUtils$.MODULE$.prepareQuery(distribution, ordering, plan, conf);
    }

    protected double sizeEstimateMultiple() {
        return this.sizeEstimateMultiple;
    }

    protected SparkTableCache tableCache() {
        return this.tableCache;
    }

    protected FileScanTaskSetManager manager() {
        return this.manager;
    }

    protected FileRewriteCoordinator rewriteCoordinator() {
        return this.rewriteCoordinator;
    }
}

