/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.iceberg.arrow.vectorized.GenericArrowVectorAccessorFactory;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.unsafe.types.UTF8String;

final class ArrowVectorAccessorFactory
extends GenericArrowVectorAccessorFactory<Decimal, UTF8String, ColumnarArray, ArrowColumnVector> {
    ArrowVectorAccessorFactory() {
        super(() -> new DecimalFactoryImpl(), () -> new StringFactoryImpl(), () -> new StructChildFactoryImpl(), () -> new ArrayFactoryImpl());
    }

    private static final class StructChildFactoryImpl
    implements GenericArrowVectorAccessorFactory.StructChildFactory<ArrowColumnVector> {
        private StructChildFactoryImpl() {
        }

        public Class<ArrowColumnVector> getGenericClass() {
            return ArrowColumnVector.class;
        }

        public ArrowColumnVector of(ValueVector childVector) {
            return new ArrowColumnVector(childVector);
        }
    }

    private static final class ArrayFactoryImpl
    implements GenericArrowVectorAccessorFactory.ArrayFactory<ArrowColumnVector, ColumnarArray> {
        private ArrayFactoryImpl() {
        }

        public ArrowColumnVector ofChild(ValueVector childVector) {
            return new ArrowColumnVector(childVector);
        }

        public ColumnarArray ofRow(ValueVector vector, ArrowColumnVector childData, int rowId) {
            ArrowBuf offsets = vector.getOffsetBuffer();
            int index = rowId * 4;
            int start = offsets.getInt((long)index);
            int end = offsets.getInt((long)(index + 4));
            return new ColumnarArray((ColumnVector)childData, start, end - start);
        }
    }

    private static final class StringFactoryImpl
    implements GenericArrowVectorAccessorFactory.StringFactory<UTF8String> {
        private StringFactoryImpl() {
        }

        public Class<UTF8String> getGenericClass() {
            return UTF8String.class;
        }

        public UTF8String ofRow(VarCharVector vector, int rowId) {
            int start = vector.getStartOffset(rowId);
            int end = vector.getEndOffset(rowId);
            return UTF8String.fromAddress(null, (long)(vector.getDataBuffer().memoryAddress() + (long)start), (int)(end - start));
        }

        public UTF8String ofBytes(byte[] bytes) {
            return UTF8String.fromBytes((byte[])bytes);
        }

        public UTF8String ofByteBuffer(ByteBuffer byteBuffer) {
            if (byteBuffer.hasArray()) {
                return UTF8String.fromBytes((byte[])byteBuffer.array(), (int)(byteBuffer.arrayOffset() + byteBuffer.position()), (int)byteBuffer.remaining());
            }
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return UTF8String.fromBytes((byte[])bytes);
        }
    }

    private static final class DecimalFactoryImpl
    implements GenericArrowVectorAccessorFactory.DecimalFactory<Decimal> {
        private DecimalFactoryImpl() {
        }

        public Class<Decimal> getGenericClass() {
            return Decimal.class;
        }

        public Decimal ofLong(long value, int precision, int scale) {
            return Decimal.apply((long)value, (int)precision, (int)scale);
        }

        public Decimal ofBigDecimal(BigDecimal value, int precision, int scale) {
            return Decimal.apply((BigDecimal)value, (int)precision, (int)scale);
        }
    }
}

