/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.DeleteOrphanFiles;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.actions.DeleteOrphanFilesSparkAction;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.runtime.BoxedUnit;

public class RemoveOrphanFilesProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("older_than", DataTypes.TimestampType), ProcedureParameter.optional("location", DataTypes.StringType), ProcedureParameter.optional("dry_run", DataTypes.BooleanType), ProcedureParameter.optional("max_concurrent_deletes", DataTypes.IntegerType), ProcedureParameter.optional("file_list_view", DataTypes.StringType), ProcedureParameter.optional("equal_schemes", STRING_MAP), ProcedureParameter.optional("equal_authorities", STRING_MAP), ProcedureParameter.optional("prefix_mismatch_mode", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("orphan_file_location", DataTypes.StringType, false, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RemoveOrphanFilesProcedure>(){

            @Override
            protected RemoveOrphanFilesProcedure doBuild() {
                return new RemoveOrphanFilesProcedure(this.tableCatalog());
            }
        };
    }

    private RemoveOrphanFilesProcedure(TableCatalog catalog) {
        super(catalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        Long olderThanMillis = args.isNullAt(1) ? null : Long.valueOf(DateTimeUtil.microsToMillis((long)args.getLong(1)));
        String location = args.isNullAt(2) ? null : args.getString(2);
        boolean dryRun = args.isNullAt(3) ? false : args.getBoolean(3);
        Integer maxConcurrentDeletes = args.isNullAt(4) ? null : Integer.valueOf(args.getInt(4));
        String fileListView = args.isNullAt(5) ? null : args.getString(5);
        Preconditions.checkArgument((maxConcurrentDeletes == null || maxConcurrentDeletes > 0 ? 1 : 0) != 0, (String)"max_concurrent_deletes should have value > 0, value: %s", (Object)maxConcurrentDeletes);
        HashMap equalSchemes = Maps.newHashMap();
        if (!args.isNullAt(6)) {
            args.getMap(6).foreach(DataTypes.StringType, DataTypes.StringType, (k, v) -> {
                equalSchemes.put(k.toString(), v.toString());
                return BoxedUnit.UNIT;
            });
        }
        HashMap equalAuthorities = Maps.newHashMap();
        if (!args.isNullAt(7)) {
            args.getMap(7).foreach(DataTypes.StringType, DataTypes.StringType, (k, v) -> {
                equalSchemes.put(k.toString(), v.toString());
                return BoxedUnit.UNIT;
            });
        }
        DeleteOrphanFiles.PrefixMismatchMode prefixMismatchMode = args.isNullAt(8) ? null : DeleteOrphanFiles.PrefixMismatchMode.fromString((String)args.getString(8));
        return this.withIcebergTable(tableIdent, table -> {
            DeleteOrphanFilesSparkAction action = this.actions().deleteOrphanFiles((Table)table);
            if (olderThanMillis != null) {
                boolean isTesting = Boolean.parseBoolean(this.spark().conf().get("spark.testing", "false"));
                if (!isTesting) {
                    this.validateInterval(olderThanMillis);
                }
                action.olderThan(olderThanMillis);
            }
            if (location != null) {
                action.location(location);
            }
            if (dryRun) {
                action.deleteWith(file -> {});
            }
            if (maxConcurrentDeletes != null) {
                action.executeDeleteWith(this.executorService(maxConcurrentDeletes, "remove-orphans"));
            }
            if (fileListView != null) {
                action.compareToFileList((Dataset<Row>)this.spark().table(fileListView));
            }
            action.equalSchemes((Map)equalSchemes);
            action.equalAuthorities((Map)equalAuthorities);
            if (prefixMismatchMode != null) {
                action.prefixMismatchMode(prefixMismatchMode);
            }
            DeleteOrphanFiles.Result result = action.execute();
            return this.toOutputRows(result);
        });
    }

    private InternalRow[] toOutputRows(DeleteOrphanFiles.Result result) {
        Iterable orphanFileLocations = result.orphanFileLocations();
        int orphanFileLocationsCount = Iterables.size((Iterable)orphanFileLocations);
        InternalRow[] rows = new InternalRow[orphanFileLocationsCount];
        int index = 0;
        for (String fileLocation : orphanFileLocations) {
            rows[index] = this.newInternalRow(UTF8String.fromString((String)fileLocation));
            ++index;
        }
        return rows;
    }

    private void validateInterval(long olderThanMillis) {
        long intervalMillis = System.currentTimeMillis() - olderThanMillis;
        if (intervalMillis < TimeUnit.DAYS.toMillis(1L)) {
            throw new IllegalArgumentException("Cannot remove orphan files with an interval less than 24 hours. Executing this procedure with a short interval may corrupt the table if other operations are happening at the same time. If you are absolutely confident that no concurrent operations will be affected by removing orphan files with such a short interval, you can use the Action API to remove orphan files with an arbitrary interval.");
        }
    }

    @Override
    public String description() {
        return "RemoveOrphanFilesProcedure";
    }
}

