/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkFilters;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.SparkScan;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.TableScanUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsRuntimeFiltering;
import org.apache.spark.sql.sources.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SparkBatchQueryScan
extends SparkScan
implements SupportsRuntimeFiltering {
    private static final Logger LOG = LoggerFactory.getLogger(SparkBatchQueryScan.class);
    private final TableScan scan;
    private final Long snapshotId;
    private final Long startSnapshotId;
    private final Long endSnapshotId;
    private final Long asOfTimestamp;
    private final String branch;
    private final String tag;
    private final List<Expression> runtimeFilterExpressions;
    private Set<Integer> specIds = null;
    private List<FileScanTask> files = null;
    private List<CombinedScanTask> tasks = null;

    SparkBatchQueryScan(SparkSession spark, Table table, TableScan scan, SparkReadConf readConf, Schema expectedSchema, List<Expression> filters) {
        super(spark, table, readConf, expectedSchema, filters);
        this.scan = scan;
        this.snapshotId = readConf.snapshotId();
        this.startSnapshotId = readConf.startSnapshotId();
        this.endSnapshotId = readConf.endSnapshotId();
        this.asOfTimestamp = readConf.asOfTimestamp();
        this.branch = readConf.branch();
        this.tag = readConf.tag();
        this.runtimeFilterExpressions = Lists.newArrayList();
        if (scan == null) {
            this.specIds = Collections.emptySet();
            this.files = Collections.emptyList();
            this.tasks = Collections.emptyList();
        }
    }

    Long snapshotId() {
        return this.snapshotId;
    }

    private Set<Integer> specIds() {
        if (this.specIds == null) {
            HashSet specIdSet = Sets.newHashSet();
            for (FileScanTask file : this.files()) {
                specIdSet.add(file.spec().specId());
            }
            this.specIds = specIdSet;
        }
        return this.specIds;
    }

    private List<FileScanTask> files() {
        if (this.files == null) {
            try (CloseableIterable filesIterable = this.scan.planFiles();){
                this.files = Lists.newArrayList((Iterable)filesIterable);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close table scan: " + this.scan, e);
            }
        }
        return this.files;
    }

    @Override
    protected List<CombinedScanTask> tasks() {
        if (this.tasks == null) {
            CloseableIterable splitFiles = TableScanUtil.splitFiles((CloseableIterable)CloseableIterable.withNoopClose(this.files()), (long)this.scan.targetSplitSize());
            CloseableIterable scanTasks = TableScanUtil.planTasks((CloseableIterable)splitFiles, (long)this.scan.targetSplitSize(), (int)this.scan.splitLookback(), (long)this.scan.splitOpenFileCost());
            this.tasks = Lists.newArrayList((Iterable)scanTasks);
        }
        return this.tasks;
    }

    public NamedReference[] filterAttributes() {
        HashSet partitionFieldSourceIds = Sets.newHashSet();
        for (Integer specId : this.specIds()) {
            PartitionSpec spec = (PartitionSpec)this.table().specs().get(specId);
            for (PartitionField field : spec.fields()) {
                partitionFieldSourceIds.add(field.sourceId());
            }
        }
        Map<Integer, String> quotedNameById = SparkSchemaUtil.indexQuotedNameById(this.expectedSchema());
        return (NamedReference[])partitionFieldSourceIds.stream().filter(fieldId -> this.expectedSchema().findField(fieldId.intValue()) != null).map(fieldId -> Spark3Util.toNamedReference((String)quotedNameById.get(fieldId))).toArray(NamedReference[]::new);
    }

    public void filter(Filter[] filters) {
        Expression runtimeFilterExpr = this.convertRuntimeFilters(filters);
        if (runtimeFilterExpr != Expressions.alwaysTrue()) {
            HashMap evaluatorsBySpecId = Maps.newHashMap();
            for (Integer specId : this.specIds()) {
                PartitionSpec spec = (PartitionSpec)this.table().specs().get(specId);
                Expression inclusiveExpr = Projections.inclusive((PartitionSpec)spec, (boolean)this.caseSensitive()).project(runtimeFilterExpr);
                Evaluator inclusive = new Evaluator(spec.partitionType(), inclusiveExpr);
                evaluatorsBySpecId.put(specId, inclusive);
            }
            LOG.info("Trying to filter {} files using runtime filter {}", (Object)this.files().size(), (Object)ExpressionUtil.toSanitizedString((Expression)runtimeFilterExpr));
            List filteredFiles = this.files().stream().filter(file -> {
                Evaluator evaluator = (Evaluator)evaluatorsBySpecId.get(file.spec().specId());
                return evaluator.eval(((DataFile)file.file()).partition());
            }).collect(Collectors.toList());
            LOG.info("{}/{} files matched runtime filter {}", new Object[]{filteredFiles.size(), this.files().size(), ExpressionUtil.toSanitizedString((Expression)runtimeFilterExpr)});
            if (filteredFiles.size() < this.files().size()) {
                this.specIds = null;
                this.files = filteredFiles;
                this.tasks = null;
            }
            this.runtimeFilterExpressions.add(runtimeFilterExpr);
        }
    }

    private Expression convertRuntimeFilters(Filter[] filters) {
        True runtimeFilterExpr = Expressions.alwaysTrue();
        for (Filter filter : filters) {
            Expression expr = SparkFilters.convert(filter);
            if (expr != null) {
                try {
                    Binder.bind((Types.StructType)this.expectedSchema().asStruct(), (Expression)expr, (boolean)this.caseSensitive());
                    runtimeFilterExpr = Expressions.and((Expression)runtimeFilterExpr, (Expression)expr);
                }
                catch (ValidationException e) {
                    LOG.warn("Failed to bind {} to expected schema, skipping runtime filter", (Object)expr, (Object)e);
                }
                continue;
            }
            LOG.warn("Unsupported runtime filter {}", (Object)filter);
        }
        return runtimeFilterExpr;
    }

    @Override
    public Statistics estimateStatistics() {
        if (this.scan == null) {
            return this.estimateStatistics(null);
        }
        if (this.snapshotId != null) {
            Snapshot snapshot = this.table().snapshot(this.snapshotId.longValue());
            return this.estimateStatistics(snapshot);
        }
        if (this.asOfTimestamp != null) {
            long snapshotIdAsOfTime = SnapshotUtil.snapshotIdAsOfTime((Table)this.table(), (long)this.asOfTimestamp);
            Snapshot snapshot = this.table().snapshot(snapshotIdAsOfTime);
            return this.estimateStatistics(snapshot);
        }
        if (this.branch != null) {
            Snapshot snapshot = this.table().snapshot(this.branch);
            return this.estimateStatistics(snapshot);
        }
        if (this.tag != null) {
            Snapshot snapshot = this.table().snapshot(this.tag);
            return this.estimateStatistics(snapshot);
        }
        Snapshot snapshot = this.table().currentSnapshot();
        return this.estimateStatistics(snapshot);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparkBatchQueryScan that = (SparkBatchQueryScan)o;
        return this.table().name().equals(that.table().name()) && this.readSchema().equals((Object)that.readSchema()) && this.filterExpressions().toString().equals(that.filterExpressions().toString()) && this.runtimeFilterExpressions.toString().equals(that.runtimeFilterExpressions.toString()) && Objects.equals(this.snapshotId, that.snapshotId) && Objects.equals(this.startSnapshotId, that.startSnapshotId) && Objects.equals(this.endSnapshotId, that.endSnapshotId) && Objects.equals(this.asOfTimestamp, that.asOfTimestamp) && Objects.equals(this.branch, that.branch) && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.table().name(), this.readSchema(), this.filterExpressions().toString(), this.runtimeFilterExpressions.toString(), this.snapshotId, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, this.branch, this.tag);
    }

    public String toString() {
        return String.format("IcebergScan(table=%s, type=%s, filters=%s, runtimeFilters=%s, caseSensitive=%s)", this.table(), this.expectedSchema().asStruct(), this.filterExpressions(), this.runtimeFilterExpressions, this.caseSensitive());
    }
}

