/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.Zorder;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.io.BaseEncoding;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.source.HasIcebergCatalog;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.transforms.PartitionSpecVisitor;
import org.apache.iceberg.transforms.SortOrderVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.Pair;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.CatalystTypeConverters;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Buffer;

public class Spark3Util {
    private static final Set<String> RESERVED_PROPERTIES = ImmutableSet.of((Object)"location", (Object)"provider");
    private static final Joiner DOT = Joiner.on((String)".");

    private Spark3Util() {
    }

    public static CaseInsensitiveStringMap setOption(String key, String value, CaseInsensitiveStringMap options) {
        HashMap newOptions = Maps.newHashMap();
        newOptions.putAll(options);
        newOptions.put(key, value);
        return new CaseInsensitiveStringMap((Map)newOptions);
    }

    public static Map<String, String> rebuildCreateProperties(Map<String, String> createProperties) {
        ImmutableMap.Builder tableProperties = ImmutableMap.builder();
        createProperties.entrySet().stream().filter(entry -> !RESERVED_PROPERTIES.contains(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tableProperties).put(arg_0));
        String provider = createProperties.get("provider");
        if ("parquet".equalsIgnoreCase(provider)) {
            tableProperties.put((Object)"write.format.default", (Object)"parquet");
        } else if ("avro".equalsIgnoreCase(provider)) {
            tableProperties.put((Object)"write.format.default", (Object)"avro");
        } else if ("orc".equalsIgnoreCase(provider)) {
            tableProperties.put((Object)"write.format.default", (Object)"orc");
        } else if (provider != null && !"iceberg".equalsIgnoreCase(provider)) {
            throw new IllegalArgumentException("Unsupported format in USING: " + provider);
        }
        return tableProperties.build();
    }

    public static UpdateProperties applyPropertyChanges(UpdateProperties pendingUpdate, List<TableChange> changes) {
        for (TableChange change : changes) {
            if (change instanceof TableChange.SetProperty) {
                TableChange.SetProperty set = (TableChange.SetProperty)change;
                pendingUpdate.set(set.property(), set.value());
                continue;
            }
            if (change instanceof TableChange.RemoveProperty) {
                TableChange.RemoveProperty remove = (TableChange.RemoveProperty)change;
                pendingUpdate.remove(remove.property());
                continue;
            }
            throw new UnsupportedOperationException("Cannot apply unknown table change: " + change);
        }
        return pendingUpdate;
    }

    public static UpdateSchema applySchemaChanges(UpdateSchema pendingUpdate, List<TableChange> changes) {
        for (TableChange change : changes) {
            TableChange.UpdateColumnType update;
            if (change instanceof TableChange.AddColumn) {
                Spark3Util.apply(pendingUpdate, (TableChange.AddColumn)change);
                continue;
            }
            if (change instanceof TableChange.UpdateColumnType) {
                update = (TableChange.UpdateColumnType)change;
                Type newType = SparkSchemaUtil.convert(update.newDataType());
                Preconditions.checkArgument((boolean)newType.isPrimitiveType(), (String)"Cannot update '%s', not a primitive type: %s", (Object)DOT.join((Object[])update.fieldNames()), (Object)update.newDataType());
                pendingUpdate.updateColumn(DOT.join((Object[])update.fieldNames()), newType.asPrimitiveType());
                continue;
            }
            if (change instanceof TableChange.UpdateColumnComment) {
                update = (TableChange.UpdateColumnComment)change;
                pendingUpdate.updateColumnDoc(DOT.join((Object[])update.fieldNames()), update.newComment());
                continue;
            }
            if (change instanceof TableChange.RenameColumn) {
                TableChange.RenameColumn rename = (TableChange.RenameColumn)change;
                pendingUpdate.renameColumn(DOT.join((Object[])rename.fieldNames()), rename.newName());
                continue;
            }
            if (change instanceof TableChange.DeleteColumn) {
                TableChange.DeleteColumn delete = (TableChange.DeleteColumn)change;
                pendingUpdate.deleteColumn(DOT.join((Object[])delete.fieldNames()));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnNullability) {
                update = (TableChange.UpdateColumnNullability)change;
                if (update.nullable()) {
                    pendingUpdate.makeColumnOptional(DOT.join((Object[])update.fieldNames()));
                    continue;
                }
                pendingUpdate.requireColumn(DOT.join((Object[])update.fieldNames()));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnPosition) {
                Spark3Util.apply(pendingUpdate, (TableChange.UpdateColumnPosition)change);
                continue;
            }
            throw new UnsupportedOperationException("Cannot apply unknown table change: " + change);
        }
        return pendingUpdate;
    }

    private static void apply(UpdateSchema pendingUpdate, TableChange.UpdateColumnPosition update) {
        Preconditions.checkArgument((update.position() != null ? 1 : 0) != 0, (Object)"Invalid position: null");
        if (update.position() instanceof TableChange.After) {
            TableChange.After after = (TableChange.After)update.position();
            String referenceField = Spark3Util.peerName(update.fieldNames(), after.column());
            pendingUpdate.moveAfter(DOT.join((Object[])update.fieldNames()), referenceField);
        } else if (update.position() instanceof TableChange.First) {
            pendingUpdate.moveFirst(DOT.join((Object[])update.fieldNames()));
        } else {
            throw new IllegalArgumentException("Unknown position for reorder: " + update.position());
        }
    }

    private static void apply(UpdateSchema pendingUpdate, TableChange.AddColumn add) {
        Preconditions.checkArgument((boolean)add.isNullable(), (String)"Incompatible change: cannot add required column: %s", (Object)Spark3Util.leafName(add.fieldNames()));
        Type type = SparkSchemaUtil.convert(add.dataType());
        pendingUpdate.addColumn(Spark3Util.parentName(add.fieldNames()), Spark3Util.leafName(add.fieldNames()), type, add.comment());
        if (add.position() instanceof TableChange.After) {
            TableChange.After after = (TableChange.After)add.position();
            String referenceField = Spark3Util.peerName(add.fieldNames(), after.column());
            pendingUpdate.moveAfter(DOT.join((Object[])add.fieldNames()), referenceField);
        } else if (add.position() instanceof TableChange.First) {
            pendingUpdate.moveFirst(DOT.join((Object[])add.fieldNames()));
        } else {
            Preconditions.checkArgument((add.position() == null ? 1 : 0) != 0, (String)"Cannot add '%s' at unknown position: %s", (Object)DOT.join((Object[])add.fieldNames()), (Object)add.position());
        }
    }

    public static Table toIcebergTable(org.apache.spark.sql.connector.catalog.Table table) {
        Preconditions.checkArgument((boolean)(table instanceof SparkTable), (String)"Table %s is not an Iceberg table", (Object)table);
        SparkTable sparkTable = (SparkTable)table;
        return sparkTable.table();
    }

    public static Transform[] toTransforms(Schema schema, List<PartitionField> fields) {
        SpecTransformToSparkTransform visitor = new SpecTransformToSparkTransform(schema);
        ArrayList transforms = Lists.newArrayList();
        for (PartitionField field : fields) {
            Transform transform = (Transform)PartitionSpecVisitor.visit((Schema)schema, (PartitionField)field, (PartitionSpecVisitor)visitor);
            if (transform == null) continue;
            transforms.add(transform);
        }
        return transforms.toArray(new Transform[0]);
    }

    public static Transform[] toTransforms(PartitionSpec spec) {
        SpecTransformToSparkTransform visitor = new SpecTransformToSparkTransform(spec.schema());
        List transforms = PartitionSpecVisitor.visit((PartitionSpec)spec, (PartitionSpecVisitor)visitor);
        return (Transform[])transforms.stream().filter(Objects::nonNull).toArray(Transform[]::new);
    }

    public static NamedReference toNamedReference(String name) {
        return Expressions.column((String)name);
    }

    public static Term toIcebergTerm(org.apache.spark.sql.connector.expressions.Expression expr) {
        if (expr instanceof Transform) {
            Transform transform = (Transform)expr;
            Preconditions.checkArgument(("zorder".equals(transform.name()) || transform.references().length == 1 ? 1 : 0) != 0, (String)"Cannot convert transform with more than one column reference: %s", (Object)transform);
            String colName = DOT.join((Object[])transform.references()[0].fieldNames());
            switch (transform.name().toLowerCase(Locale.ROOT)) {
                case "identity": {
                    return org.apache.iceberg.expressions.Expressions.ref((String)colName);
                }
                case "bucket": {
                    return org.apache.iceberg.expressions.Expressions.bucket((String)colName, (int)Spark3Util.findWidth(transform));
                }
                case "years": {
                    return org.apache.iceberg.expressions.Expressions.year((String)colName);
                }
                case "months": {
                    return org.apache.iceberg.expressions.Expressions.month((String)colName);
                }
                case "date": 
                case "days": {
                    return org.apache.iceberg.expressions.Expressions.day((String)colName);
                }
                case "date_hour": 
                case "hours": {
                    return org.apache.iceberg.expressions.Expressions.hour((String)colName);
                }
                case "truncate": {
                    return org.apache.iceberg.expressions.Expressions.truncate((String)colName, (int)Spark3Util.findWidth(transform));
                }
                case "zorder": {
                    return new Zorder(Stream.of(transform.references()).map(ref -> DOT.join((Object[])ref.fieldNames())).map(org.apache.iceberg.expressions.Expressions::ref).collect(Collectors.toList()));
                }
            }
            throw new UnsupportedOperationException("Transform is not supported: " + transform);
        }
        if (expr instanceof NamedReference) {
            NamedReference ref2 = (NamedReference)expr;
            return org.apache.iceberg.expressions.Expressions.ref((String)DOT.join((Object[])ref2.fieldNames()));
        }
        throw new UnsupportedOperationException("Cannot convert unknown expression: " + expr);
    }

    public static PartitionSpec toPartitionSpec(Schema schema, Transform[] partitioning) {
        if (partitioning == null || partitioning.length == 0) {
            return PartitionSpec.unpartitioned();
        }
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema);
        block20: for (Transform transform : partitioning) {
            Preconditions.checkArgument((transform.references().length == 1 ? 1 : 0) != 0, (String)"Cannot convert transform with more than one column reference: %s", (Object)transform);
            String colName = DOT.join((Object[])transform.references()[0].fieldNames());
            switch (transform.name().toLowerCase(Locale.ROOT)) {
                case "identity": {
                    builder.identity(colName);
                    continue block20;
                }
                case "bucket": {
                    builder.bucket(colName, Spark3Util.findWidth(transform));
                    continue block20;
                }
                case "years": {
                    builder.year(colName);
                    continue block20;
                }
                case "months": {
                    builder.month(colName);
                    continue block20;
                }
                case "date": 
                case "days": {
                    builder.day(colName);
                    continue block20;
                }
                case "date_hour": 
                case "hours": {
                    builder.hour(colName);
                    continue block20;
                }
                case "truncate": {
                    builder.truncate(colName, Spark3Util.findWidth(transform));
                    continue block20;
                }
                default: {
                    throw new UnsupportedOperationException("Transform is not supported: " + transform);
                }
            }
        }
        return builder.build();
    }

    private static int findWidth(Transform transform) {
        for (org.apache.spark.sql.connector.expressions.Expression expr : transform.arguments()) {
            if (!(expr instanceof Literal)) continue;
            if (((Literal)expr).dataType() instanceof IntegerType) {
                Literal lit = (Literal)expr;
                Preconditions.checkArgument(((Integer)lit.value() > 0 ? 1 : 0) != 0, (String)"Unsupported width for transform: %s", (Object)transform.describe());
                return (Integer)lit.value();
            }
            if (!(((Literal)expr).dataType() instanceof LongType)) continue;
            Literal lit = (Literal)expr;
            Preconditions.checkArgument(((Long)lit.value() > 0L && (Long)lit.value() < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Unsupported width for transform: %s", (Object)transform.describe());
            if ((Long)lit.value() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            return ((Long)lit.value()).intValue();
        }
        throw new IllegalArgumentException("Cannot find width for transform: " + transform.describe());
    }

    private static String leafName(String[] fieldNames) {
        Preconditions.checkArgument((fieldNames.length > 0 ? 1 : 0) != 0, (Object)"Invalid field name: at least one name is required");
        return fieldNames[fieldNames.length - 1];
    }

    private static String peerName(String[] fieldNames, String fieldName) {
        if (fieldNames.length > 1) {
            Object[] peerNames = Arrays.copyOf(fieldNames, fieldNames.length);
            peerNames[fieldNames.length - 1] = fieldName;
            return DOT.join(peerNames);
        }
        return fieldName;
    }

    private static String parentName(String[] fieldNames) {
        if (fieldNames.length > 1) {
            return DOT.join((Object[])Arrays.copyOfRange(fieldNames, 0, fieldNames.length - 1));
        }
        return null;
    }

    public static String describe(List<org.apache.iceberg.expressions.Expression> exprs) {
        return exprs.stream().map(Spark3Util::describe).collect(Collectors.joining(", "));
    }

    public static String describe(org.apache.iceberg.expressions.Expression expr) {
        return (String)ExpressionVisitors.visit((org.apache.iceberg.expressions.Expression)expr, (ExpressionVisitors.ExpressionVisitor)DescribeExpressionVisitor.INSTANCE);
    }

    public static String describe(Schema schema) {
        return (String)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)DescribeSchemaVisitor.INSTANCE);
    }

    public static String describe(Type type) {
        return (String)TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)DescribeSchemaVisitor.INSTANCE);
    }

    public static String describe(SortOrder order) {
        return Joiner.on((String)", ").join((java.lang.Iterable)SortOrderVisitor.visit((SortOrder)order, (SortOrderVisitor)DescribeSortOrderVisitor.INSTANCE));
    }

    public static boolean extensionsEnabled(SparkSession spark) {
        String extensions = spark.conf().get("spark.sql.extensions", "");
        return extensions.contains("IcebergSparkSessionExtensions");
    }

    public static Table loadIcebergTable(SparkSession spark, String name) throws ParseException, NoSuchTableException {
        CatalogAndIdentifier catalogAndIdentifier = Spark3Util.catalogAndIdentifier(spark, name);
        TableCatalog catalog = Spark3Util.asTableCatalog(catalogAndIdentifier.catalog);
        org.apache.spark.sql.connector.catalog.Table sparkTable = catalog.loadTable(catalogAndIdentifier.identifier);
        return Spark3Util.toIcebergTable(sparkTable);
    }

    public static Catalog loadIcebergCatalog(SparkSession spark, String catalogName) {
        CatalogPlugin catalogPlugin = spark.sessionState().catalogManager().catalog(catalogName);
        Preconditions.checkArgument((boolean)(catalogPlugin instanceof HasIcebergCatalog), (Object)String.format("Cannot load Iceberg catalog from catalog %s because it does not contain an Iceberg Catalog. Actual Class: %s", catalogName, catalogPlugin.getClass().getName()));
        return ((HasIcebergCatalog)catalogPlugin).icebergCatalog();
    }

    public static CatalogAndIdentifier catalogAndIdentifier(SparkSession spark, String name) throws ParseException {
        return Spark3Util.catalogAndIdentifier(spark, name, spark.sessionState().catalogManager().currentCatalog());
    }

    public static CatalogAndIdentifier catalogAndIdentifier(SparkSession spark, String name, CatalogPlugin defaultCatalog) throws ParseException {
        ParserInterface parser = spark.sessionState().sqlParser();
        IndexedSeq multiPartIdentifier = parser.parseMultipartIdentifier(name).toIndexedSeq();
        List javaMultiPartIdentifier = JavaConverters.seqAsJavaList((Seq)multiPartIdentifier);
        return Spark3Util.catalogAndIdentifier(spark, javaMultiPartIdentifier, defaultCatalog);
    }

    public static CatalogAndIdentifier catalogAndIdentifier(String description, SparkSession spark, String name) {
        return Spark3Util.catalogAndIdentifier(description, spark, name, spark.sessionState().catalogManager().currentCatalog());
    }

    public static CatalogAndIdentifier catalogAndIdentifier(String description, SparkSession spark, String name, CatalogPlugin defaultCatalog) {
        try {
            return Spark3Util.catalogAndIdentifier(spark, name, defaultCatalog);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse " + description + ": " + name, e);
        }
    }

    public static CatalogAndIdentifier catalogAndIdentifier(SparkSession spark, List<String> nameParts) {
        return Spark3Util.catalogAndIdentifier(spark, nameParts, spark.sessionState().catalogManager().currentCatalog());
    }

    public static CatalogAndIdentifier catalogAndIdentifier(SparkSession spark, List<String> nameParts, CatalogPlugin defaultCatalog) {
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        String[] currentNamespace = defaultCatalog.equals(catalogManager.currentCatalog()) ? catalogManager.currentNamespace() : defaultCatalog.defaultNamespace();
        Pair<CatalogPlugin, Identifier> catalogIdentifier = SparkUtil.catalogAndIdentifier(nameParts, catalogName -> {
            try {
                return catalogManager.catalog(catalogName);
            }
            catch (Exception e) {
                return null;
            }
        }, Identifier::of, defaultCatalog, currentNamespace);
        return new CatalogAndIdentifier(catalogIdentifier);
    }

    private static TableCatalog asTableCatalog(CatalogPlugin catalog) {
        if (catalog instanceof TableCatalog) {
            return (TableCatalog)catalog;
        }
        throw new IllegalArgumentException(String.format("Cannot use catalog %s(%s): not a TableCatalog", catalog.name(), catalog.getClass().getName()));
    }

    public static TableIdentifier identifierToTableIdentifier(Identifier identifier) {
        return TableIdentifier.of((Namespace)Namespace.of((String[])identifier.namespace()), (String)identifier.name());
    }

    public static String quotedFullIdentifier(String catalogName, Identifier identifier) {
        ImmutableList parts = ImmutableList.builder().add((Object)catalogName).addAll(Arrays.asList(identifier.namespace())).add((Object)identifier.name()).build();
        return CatalogV2Implicits.MultipartIdentifierHelper((Seq)((Iterator)JavaConverters.asScalaIteratorConverter(parts.iterator()).asScala()).toSeq()).quoted();
    }

    @Deprecated
    public static List<SparkTableUtil.SparkPartition> getPartitions(SparkSession spark, Path rootPath, String format, Map<String, String> partitionFilter) {
        return Spark3Util.getPartitions(spark, rootPath, format, partitionFilter, null);
    }

    public static List<SparkTableUtil.SparkPartition> getPartitions(SparkSession spark, Path rootPath, String format, Map<String, String> partitionFilter, PartitionSpec partitionSpec) {
        FileStatusCache fileStatusCache = FileStatusCache.getOrCreate((SparkSession)spark);
        Option userSpecifiedSchema = partitionSpec == null ? Option.empty() : Option.apply((Object)SparkSchemaUtil.convert(new Schema(partitionSpec.partitionType().fields())));
        InMemoryFileIndex fileIndex = new InMemoryFileIndex(spark, ((Iterable)JavaConverters.collectionAsScalaIterableConverter((Collection)ImmutableList.of((Object)rootPath)).asScala()).toSeq(), Map$.MODULE$.empty(), userSpecifiedSchema, fileStatusCache, Option.empty(), Option.empty());
        org.apache.spark.sql.execution.datasources.PartitionSpec spec = fileIndex.partitionSpec();
        StructType schema = spec.partitionColumns();
        if (schema.isEmpty()) {
            return Lists.newArrayList();
        }
        List<Expression> filterExpressions = SparkUtil.partitionMapToExpression(schema, partitionFilter);
        IndexedSeq scalaPartitionFilters = ((Buffer)JavaConverters.asScalaBufferConverter(filterExpressions).asScala()).toIndexedSeq();
        ArrayList dataFilters = Lists.newArrayList();
        IndexedSeq scalaDataFilters = ((Buffer)JavaConverters.asScalaBufferConverter((List)dataFilters).asScala()).toIndexedSeq();
        IndexedSeq filteredPartitions = fileIndex.listFiles((Seq)scalaPartitionFilters, (Seq)scalaDataFilters).toIndexedSeq();
        return ((List)JavaConverters.seqAsJavaListConverter((Seq)filteredPartitions).asJava()).stream().map(partition -> {
            HashMap values = Maps.newHashMap();
            ((java.lang.Iterable)JavaConverters.asJavaIterableConverter((Iterable)schema).asJava()).forEach(field -> {
                int fieldIndex = schema.fieldIndex(field.name());
                Object catalystValue = partition.values().get(fieldIndex, field.dataType());
                Object value = CatalystTypeConverters.convertToScala((Object)catalystValue, (DataType)field.dataType());
                values.put(field.name(), String.valueOf(value));
            });
            FileStatus fileStatus = (FileStatus)((List)JavaConverters.seqAsJavaListConverter((Seq)partition.files()).asJava()).get(0);
            return new SparkTableUtil.SparkPartition(values, fileStatus.getPath().getParent().toString(), format);
        }).collect(Collectors.toList());
    }

    public static org.apache.spark.sql.catalyst.TableIdentifier toV1TableIdentifier(Identifier identifier) {
        String[] namespace = identifier.namespace();
        Preconditions.checkArgument((namespace.length <= 1 ? 1 : 0) != 0, (String)"Cannot convert %s to a Spark v1 identifier, namespace contains more than 1 part", (Object)identifier);
        String table = identifier.name();
        Option database = namespace.length == 1 ? Option.apply((Object)namespace[0]) : Option.empty();
        return org.apache.spark.sql.catalyst.TableIdentifier.apply((String)table, (Option)database);
    }

    private static class DescribeSortOrderVisitor
    implements SortOrderVisitor<String> {
        private static final DescribeSortOrderVisitor INSTANCE = new DescribeSortOrderVisitor();

        private DescribeSortOrderVisitor() {
        }

        public String field(String sourceName, int sourceId, SortDirection direction, NullOrder nullOrder) {
            return String.format("%s %s %s", sourceName, direction, nullOrder);
        }

        public String bucket(String sourceName, int sourceId, int numBuckets, SortDirection direction, NullOrder nullOrder) {
            return String.format("bucket(%s, %s) %s %s", numBuckets, sourceName, direction, nullOrder);
        }

        public String truncate(String sourceName, int sourceId, int width, SortDirection direction, NullOrder nullOrder) {
            return String.format("truncate(%s, %s) %s %s", sourceName, width, direction, nullOrder);
        }

        public String year(String sourceName, int sourceId, SortDirection direction, NullOrder nullOrder) {
            return String.format("years(%s) %s %s", sourceName, direction, nullOrder);
        }

        public String month(String sourceName, int sourceId, SortDirection direction, NullOrder nullOrder) {
            return String.format("months(%s) %s %s", sourceName, direction, nullOrder);
        }

        public String day(String sourceName, int sourceId, SortDirection direction, NullOrder nullOrder) {
            return String.format("days(%s) %s %s", sourceName, direction, nullOrder);
        }

        public String hour(String sourceName, int sourceId, SortDirection direction, NullOrder nullOrder) {
            return String.format("hours(%s) %s %s", sourceName, direction, nullOrder);
        }

        public String unknown(String sourceName, int sourceId, String transform, SortDirection direction, NullOrder nullOrder) {
            return String.format("%s(%s) %s %s", transform, sourceName, direction, nullOrder);
        }
    }

    public static class CatalogAndIdentifier {
        private final CatalogPlugin catalog;
        private final Identifier identifier;

        public CatalogAndIdentifier(CatalogPlugin catalog, Identifier identifier) {
            this.catalog = catalog;
            this.identifier = identifier;
        }

        public CatalogAndIdentifier(Pair<CatalogPlugin, Identifier> identifier) {
            this.catalog = (CatalogPlugin)identifier.first();
            this.identifier = (Identifier)identifier.second();
        }

        public CatalogPlugin catalog() {
            return this.catalog;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    private static class DescribeExpressionVisitor
    extends ExpressionVisitors.ExpressionVisitor<String> {
        private static final DescribeExpressionVisitor INSTANCE = new DescribeExpressionVisitor();

        private DescribeExpressionVisitor() {
        }

        public String alwaysTrue() {
            return "true";
        }

        public String alwaysFalse() {
            return "false";
        }

        public String not(String result) {
            return "NOT (" + result + ")";
        }

        public String and(String leftResult, String rightResult) {
            return "(" + leftResult + " AND " + rightResult + ")";
        }

        public String or(String leftResult, String rightResult) {
            return "(" + leftResult + " OR " + rightResult + ")";
        }

        public <T> String predicate(BoundPredicate<T> pred) {
            throw new UnsupportedOperationException("Cannot convert bound predicates to SQL");
        }

        public <T> String predicate(UnboundPredicate<T> pred) {
            switch (pred.op()) {
                case IS_NULL: {
                    return pred.ref().name() + " IS NULL";
                }
                case NOT_NULL: {
                    return pred.ref().name() + " IS NOT NULL";
                }
                case IS_NAN: {
                    return "is_nan(" + pred.ref().name() + ")";
                }
                case NOT_NAN: {
                    return "not_nan(" + pred.ref().name() + ")";
                }
                case LT: {
                    return pred.ref().name() + " < " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case LT_EQ: {
                    return pred.ref().name() + " <= " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case GT: {
                    return pred.ref().name() + " > " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case GT_EQ: {
                    return pred.ref().name() + " >= " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case EQ: {
                    return pred.ref().name() + " = " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case NOT_EQ: {
                    return pred.ref().name() + " != " + DescribeExpressionVisitor.sqlString(pred.literal());
                }
                case STARTS_WITH: {
                    return pred.ref().name() + " LIKE '" + pred.literal().value() + "%'";
                }
                case NOT_STARTS_WITH: {
                    return pred.ref().name() + " NOT LIKE '" + pred.literal().value() + "%'";
                }
                case IN: {
                    return pred.ref().name() + " IN (" + DescribeExpressionVisitor.sqlString(pred.literals()) + ")";
                }
                case NOT_IN: {
                    return pred.ref().name() + " NOT IN (" + DescribeExpressionVisitor.sqlString(pred.literals()) + ")";
                }
            }
            throw new UnsupportedOperationException("Cannot convert predicate to SQL: " + pred);
        }

        private static <T> String sqlString(List<org.apache.iceberg.expressions.Literal<T>> literals) {
            return literals.stream().map(DescribeExpressionVisitor::sqlString).collect(Collectors.joining(", "));
        }

        private static String sqlString(org.apache.iceberg.expressions.Literal<?> lit) {
            if (lit.value() instanceof String) {
                return "'" + lit.value() + "'";
            }
            if (lit.value() instanceof ByteBuffer) {
                byte[] bytes = ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)lit.value()));
                return "X'" + BaseEncoding.base16().encode(bytes) + "'";
            }
            return lit.value().toString();
        }
    }

    public static class DescribeSchemaVisitor
    extends TypeUtil.SchemaVisitor<String> {
        private static final Joiner COMMA = Joiner.on((char)',');
        private static final DescribeSchemaVisitor INSTANCE = new DescribeSchemaVisitor();

        private DescribeSchemaVisitor() {
        }

        public String schema(Schema schema, String structResult) {
            return structResult;
        }

        public String struct(Types.StructType struct, List<String> fieldResults) {
            return "struct<" + COMMA.join(fieldResults) + ">";
        }

        public String field(Types.NestedField field, String fieldResult) {
            return field.name() + ": " + fieldResult + (field.isRequired() ? " not null" : "");
        }

        public String list(Types.ListType list, String elementResult) {
            return "list<" + elementResult + ">";
        }

        public String map(Types.MapType map, String keyResult, String valueResult) {
            return "map<" + keyResult + ", " + valueResult + ">";
        }

        public String primitive(Type.PrimitiveType primitive) {
            switch (primitive.typeId()) {
                case BOOLEAN: {
                    return "boolean";
                }
                case INTEGER: {
                    return "int";
                }
                case LONG: {
                    return "bigint";
                }
                case FLOAT: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
                case DATE: {
                    return "date";
                }
                case TIME: {
                    return "time";
                }
                case TIMESTAMP: {
                    return "timestamp";
                }
                case STRING: 
                case UUID: {
                    return "string";
                }
                case FIXED: 
                case BINARY: {
                    return "binary";
                }
                case DECIMAL: {
                    Types.DecimalType decimal = (Types.DecimalType)primitive;
                    return "decimal(" + decimal.precision() + "," + decimal.scale() + ")";
                }
            }
            throw new UnsupportedOperationException("Cannot convert type to SQL: " + primitive);
        }
    }

    private static class SpecTransformToSparkTransform
    implements PartitionSpecVisitor<Transform> {
        private final Map<Integer, String> quotedNameById;

        SpecTransformToSparkTransform(Schema schema) {
            this.quotedNameById = SparkSchemaUtil.indexQuotedNameById(schema);
        }

        public Transform identity(String sourceName, int sourceId) {
            return Expressions.identity((String)this.quotedName(sourceId));
        }

        public Transform bucket(String sourceName, int sourceId, int numBuckets) {
            return Expressions.bucket((int)numBuckets, (String[])new String[]{this.quotedName(sourceId)});
        }

        public Transform truncate(String sourceName, int sourceId, int width) {
            NamedReference column = Expressions.column((String)this.quotedName(sourceId));
            return Expressions.apply((String)"truncate", (org.apache.spark.sql.connector.expressions.Expression[])new org.apache.spark.sql.connector.expressions.Expression[]{Expressions.literal((Object)width), column});
        }

        public Transform year(String sourceName, int sourceId) {
            return Expressions.years((String)this.quotedName(sourceId));
        }

        public Transform month(String sourceName, int sourceId) {
            return Expressions.months((String)this.quotedName(sourceId));
        }

        public Transform day(String sourceName, int sourceId) {
            return Expressions.days((String)this.quotedName(sourceId));
        }

        public Transform hour(String sourceName, int sourceId) {
            return Expressions.hours((String)this.quotedName(sourceId));
        }

        public Transform alwaysNull(int fieldId, String sourceName, int sourceId) {
            return null;
        }

        public Transform unknown(int fieldId, String sourceName, int sourceId, String transform) {
            return Expressions.apply((String)transform, (org.apache.spark.sql.connector.expressions.Expression[])new org.apache.spark.sql.connector.expressions.Expression[]{Expressions.column((String)this.quotedName(sourceId))});
        }

        private String quotedName(int id) {
            return this.quotedNameById.get(id);
        }
    }
}

