/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.TableMigrationUtil;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkExceptionUtil;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Builder;
import scala.runtime.AbstractPartialFunction;

public class SparkTableUtil {
    private static final String DUPLICATE_FILE_MESSAGE = "Cannot complete import because data files to be imported already exist within the target table: %s.  This is disabled by default as Iceberg is not designed for multiple references to the same file within the same table.  If you are sure, you may set 'check_duplicate_files' to false to force the import.";

    private SparkTableUtil() {
    }

    public static Dataset<Row> partitionDF(SparkSession spark, String table) {
        List<SparkPartition> partitions = SparkTableUtil.getPartitions(spark, table);
        return spark.createDataFrame(partitions, SparkPartition.class).toDF(new String[]{"partition", "uri", "format"});
    }

    public static Dataset<Row> partitionDFByFilter(SparkSession spark, String table, String expression) {
        List<SparkPartition> partitions = SparkTableUtil.getPartitionsByFilter(spark, table, expression);
        return spark.createDataFrame(partitions, SparkPartition.class).toDF(new String[]{"partition", "uri", "format"});
    }

    public static List<SparkPartition> getPartitions(SparkSession spark, String table) {
        try {
            TableIdentifier tableIdent = spark.sessionState().sqlParser().parseTableIdentifier(table);
            return SparkTableUtil.getPartitions(spark, tableIdent, null);
        }
        catch (ParseException e) {
            throw SparkExceptionUtil.toUncheckedException(e, "Unable to parse table identifier: %s", table);
        }
    }

    public static List<SparkPartition> getPartitions(SparkSession spark, TableIdentifier tableIdent, java.util.Map<String, String> partitionFilter) {
        try {
            Option scalaPartitionFilter;
            SessionCatalog catalog = spark.sessionState().catalog();
            CatalogTable catalogTable = catalog.getTableMetadata(tableIdent);
            if (partitionFilter != null && !partitionFilter.isEmpty()) {
                Builder builder = Map$.MODULE$.newBuilder();
                partitionFilter.forEach((key, value) -> builder.$plus$eq((Object)Tuple2.apply((Object)key, (Object)value)));
                scalaPartitionFilter = Option.apply((Object)builder.result());
            } else {
                scalaPartitionFilter = Option.empty();
            }
            IndexedSeq partitions = catalog.listPartitions(tableIdent, scalaPartitionFilter).toIndexedSeq();
            return ((List)JavaConverters.seqAsJavaListConverter((Seq)partitions).asJava()).stream().map(catalogPartition -> SparkTableUtil.toSparkPartition(catalogPartition, catalogTable)).collect(Collectors.toList());
        }
        catch (NoSuchDatabaseException e) {
            throw SparkExceptionUtil.toUncheckedException(e, "Unknown table: %s. Database not found in catalog.", tableIdent);
        }
        catch (NoSuchTableException e) {
            throw SparkExceptionUtil.toUncheckedException(e, "Unknown table: %s. Table not found in catalog.", tableIdent);
        }
    }

    public static List<SparkPartition> getPartitionsByFilter(SparkSession spark, String table, String predicate) {
        Expression unresolvedPredicateExpr;
        TableIdentifier tableIdent;
        try {
            tableIdent = spark.sessionState().sqlParser().parseTableIdentifier(table);
        }
        catch (ParseException e) {
            throw SparkExceptionUtil.toUncheckedException(e, "Unable to parse the table identifier: %s", table);
        }
        try {
            unresolvedPredicateExpr = spark.sessionState().sqlParser().parseExpression(predicate);
        }
        catch (ParseException e) {
            throw SparkExceptionUtil.toUncheckedException(e, "Unable to parse the predicate expression: %s", predicate);
        }
        Expression resolvedPredicateExpr = SparkTableUtil.resolveAttrs(spark, table, unresolvedPredicateExpr);
        return SparkTableUtil.getPartitionsByFilter(spark, tableIdent, resolvedPredicateExpr);
    }

    public static List<SparkPartition> getPartitionsByFilter(SparkSession spark, TableIdentifier tableIdent, Expression predicateExpr) {
        try {
            SessionCatalog catalog = spark.sessionState().catalog();
            CatalogTable catalogTable = catalog.getTableMetadata(tableIdent);
            Expression resolvedPredicateExpr = !predicateExpr.resolved() ? SparkTableUtil.resolveAttrs(spark, tableIdent.quotedString(), predicateExpr) : predicateExpr;
            IndexedSeq predicates = ((Iterable)JavaConverters.collectionAsScalaIterableConverter((Collection)ImmutableList.of((Object)resolvedPredicateExpr)).asScala()).toIndexedSeq();
            IndexedSeq partitions = catalog.listPartitionsByFilter(tableIdent, (Seq)predicates).toIndexedSeq();
            return ((List)JavaConverters.seqAsJavaListConverter((Seq)partitions).asJava()).stream().map(catalogPartition -> SparkTableUtil.toSparkPartition(catalogPartition, catalogTable)).collect(Collectors.toList());
        }
        catch (NoSuchDatabaseException e) {
            throw SparkExceptionUtil.toUncheckedException(e, "Unknown table: %s. Database not found in catalog.", tableIdent);
        }
        catch (NoSuchTableException e) {
            throw SparkExceptionUtil.toUncheckedException(e, "Unknown table: %s. Table not found in catalog.", tableIdent);
        }
    }

    @Deprecated
    public static List<DataFile> listPartition(SparkPartition partition, PartitionSpec spec, SerializableConfiguration conf, MetricsConfig metricsConfig) {
        return SparkTableUtil.listPartition(partition, spec, conf, metricsConfig, null);
    }

    @Deprecated
    public static List<DataFile> listPartition(SparkPartition partition, PartitionSpec spec, SerializableConfiguration conf, MetricsConfig metricsConfig, NameMapping mapping) {
        return TableMigrationUtil.listPartition((java.util.Map)partition.values, (String)partition.uri, (String)partition.format, (PartitionSpec)spec, (Configuration)conf.get(), (MetricsConfig)metricsConfig, (NameMapping)mapping);
    }

    private static SparkPartition toSparkPartition(CatalogTablePartition partition, CatalogTable table) {
        Option locationUri = partition.storage().locationUri();
        Option serde = partition.storage().serde();
        Preconditions.checkArgument((boolean)locationUri.nonEmpty(), (Object)"Partition URI should be defined");
        Preconditions.checkArgument((serde.nonEmpty() || table.provider().nonEmpty() ? 1 : 0) != 0, (Object)"Partition format should be defined");
        String uri = Util.uriToString((URI)((URI)locationUri.get()));
        String format = serde.nonEmpty() ? (String)serde.get() : (String)table.provider().get();
        java.util.Map partitionSpec = (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)partition.spec()).asJava();
        return new SparkPartition(partitionSpec, uri, format);
    }

    private static Expression resolveAttrs(SparkSession spark, String table, Expression expr) {
        final Function2 resolver = spark.sessionState().analyzer().resolver();
        final LogicalPlan plan = spark.table(table).queryExecution().analyzed();
        return (Expression)expr.transform((PartialFunction)new AbstractPartialFunction<Expression, Expression>(){

            public Expression apply(Expression attr) {
                UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)attr;
                Option namedExpressionOption = plan.resolve(unresolvedAttribute.nameParts(), resolver);
                if (namedExpressionOption.isDefined()) {
                    return (Expression)namedExpressionOption.get();
                }
                throw new IllegalArgumentException(String.format("Could not resolve %s using columns: %s", attr, plan.output()));
            }

            public boolean isDefinedAt(Expression attr) {
                return attr instanceof UnresolvedAttribute;
            }
        });
    }

    private static Iterator<ManifestFile> buildManifest(SerializableConfiguration conf, PartitionSpec spec, String basePath, Iterator<Tuple2<String, DataFile>> fileTuples) {
        if (fileTuples.hasNext()) {
            HadoopFileIO io = new HadoopFileIO(conf.get());
            TaskContext ctx = TaskContext.get();
            String suffix = String.format("stage-%d-task-%d-manifest-%s", ctx.stageId(), ctx.taskAttemptId(), UUID.randomUUID());
            Path location = new Path(basePath, suffix);
            String outputPath = FileFormat.AVRO.addExtension(location.toString());
            OutputFile outputFile = io.newOutputFile(outputPath);
            ManifestWriter writer = ManifestFiles.write((PartitionSpec)spec, (OutputFile)outputFile);
            try (ManifestWriter writerRef = writer;){
                fileTuples.forEachRemaining(fileTuple -> writerRef.add((ContentFile)fileTuple._2));
            }
            catch (IOException e) {
                throw SparkExceptionUtil.toUncheckedException(e, "Unable to close the manifest writer: %s", outputPath);
            }
            ManifestFile manifestFile = writer.toManifestFile();
            return ImmutableList.of((Object)manifestFile).iterator();
        }
        return Collections.emptyIterator();
    }

    public static void importSparkTable(SparkSession spark, TableIdentifier sourceTableIdent, Table targetTable, String stagingDir, java.util.Map<String, String> partitionFilter, boolean checkDuplicateFiles) {
        SessionCatalog catalog = spark.sessionState().catalog();
        String db = sourceTableIdent.database().nonEmpty() ? (String)sourceTableIdent.database().get() : catalog.getCurrentDatabase();
        TableIdentifier sourceTableIdentWithDB = new TableIdentifier(sourceTableIdent.table(), (Option)Some.apply((Object)db));
        if (!catalog.tableExists(sourceTableIdentWithDB)) {
            throw new org.apache.iceberg.exceptions.NoSuchTableException("Table %s does not exist", new Object[]{sourceTableIdentWithDB});
        }
        try {
            PartitionSpec spec = SparkSchemaUtil.specForTable(spark, sourceTableIdentWithDB.unquotedString());
            if (Objects.equal((Object)spec, (Object)PartitionSpec.unpartitioned())) {
                SparkTableUtil.importUnpartitionedSparkTable(spark, sourceTableIdentWithDB, targetTable, checkDuplicateFiles);
            } else {
                List<SparkPartition> sourceTablePartitions = SparkTableUtil.getPartitions(spark, sourceTableIdent, partitionFilter);
                Preconditions.checkArgument((!sourceTablePartitions.isEmpty() ? 1 : 0) != 0, (String)"Cannot find any partitions in table %s", (Object)sourceTableIdent);
                SparkTableUtil.importSparkPartitions(spark, sourceTablePartitions, targetTable, spec, stagingDir, checkDuplicateFiles);
            }
        }
        catch (AnalysisException e) {
            throw SparkExceptionUtil.toUncheckedException(e, "Unable to get partition spec for table: %s", sourceTableIdentWithDB);
        }
    }

    public static void importSparkTable(SparkSession spark, TableIdentifier sourceTableIdent, Table targetTable, String stagingDir, boolean checkDuplicateFiles) {
        SparkTableUtil.importSparkTable(spark, sourceTableIdent, targetTable, stagingDir, Collections.emptyMap(), checkDuplicateFiles);
    }

    public static void importSparkTable(SparkSession spark, TableIdentifier sourceTableIdent, Table targetTable, String stagingDir) {
        SparkTableUtil.importSparkTable(spark, sourceTableIdent, targetTable, stagingDir, Collections.emptyMap(), false);
    }

    private static void importUnpartitionedSparkTable(SparkSession spark, TableIdentifier sourceTableIdent, Table targetTable, boolean checkDuplicateFiles) {
        try {
            CatalogTable sourceTable = spark.sessionState().catalog().getTableMetadata(sourceTableIdent);
            Option format = sourceTable.storage().serde().nonEmpty() ? sourceTable.storage().serde() : sourceTable.provider();
            Preconditions.checkArgument((boolean)format.nonEmpty(), (Object)"Could not determine table format");
            java.util.Map partition = Collections.emptyMap();
            PartitionSpec spec = PartitionSpec.unpartitioned();
            Configuration conf = spark.sessionState().newHadoopConf();
            MetricsConfig metricsConfig = MetricsConfig.forTable((Table)targetTable);
            String nameMappingString = (String)targetTable.properties().get("schema.name-mapping.default");
            NameMapping nameMapping = nameMappingString != null ? NameMappingParser.fromJson((String)nameMappingString) : null;
            List files = TableMigrationUtil.listPartition(partition, (String)Util.uriToString((URI)sourceTable.location()), (String)((String)format.get()), (PartitionSpec)spec, (Configuration)conf, (MetricsConfig)metricsConfig, (NameMapping)nameMapping);
            if (checkDuplicateFiles) {
                Dataset importedFiles = spark.createDataset(Lists.transform((List)files, f -> f.path().toString()), Encoders.STRING()).toDF(new String[]{"file_path"});
                Dataset existingFiles = SparkTableUtil.loadMetadataTable(spark, targetTable, MetadataTableType.ENTRIES).filter("status != 2");
                Column joinCond = existingFiles.col("data_file.file_path").equalTo((Object)importedFiles.col("file_path"));
                Dataset duplicates = importedFiles.join(existingFiles, joinCond).select("file_path", new String[0]).as(Encoders.STRING());
                Preconditions.checkState((boolean)duplicates.isEmpty(), (Object)String.format(DUPLICATE_FILE_MESSAGE, Joiner.on((String)",").join((Object[])((String[])duplicates.take(10)))));
            }
            AppendFiles append = targetTable.newAppend();
            files.forEach(arg_0 -> ((AppendFiles)append).appendFile(arg_0));
            append.commit();
        }
        catch (NoSuchDatabaseException e) {
            throw SparkExceptionUtil.toUncheckedException(e, "Unknown table: %s. Database not found in catalog.", sourceTableIdent);
        }
        catch (NoSuchTableException e) {
            throw SparkExceptionUtil.toUncheckedException(e, "Unknown table: %s. Table not found in catalog.", sourceTableIdent);
        }
    }

    public static void importSparkPartitions(SparkSession spark, List<SparkPartition> partitions, Table targetTable, PartitionSpec spec, String stagingDir, boolean checkDuplicateFiles) {
        Configuration conf = spark.sessionState().newHadoopConf();
        SerializableConfiguration serializableConf = new SerializableConfiguration(conf);
        int parallelism = Math.min(partitions.size(), spark.sessionState().conf().parallelPartitionDiscoveryParallelism());
        int numShufflePartitions = spark.sessionState().conf().numShufflePartitions();
        MetricsConfig metricsConfig = MetricsConfig.fromProperties((java.util.Map)targetTable.properties());
        String nameMappingString = (String)targetTable.properties().get("schema.name-mapping.default");
        NameMapping nameMapping = nameMappingString != null ? NameMappingParser.fromJson((String)nameMappingString) : null;
        JavaSparkContext sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD partitionRDD = sparkContext.parallelize(partitions, parallelism);
        Dataset partitionDS = spark.createDataset(partitionRDD.rdd(), Encoders.javaSerialization(SparkPartition.class));
        Dataset filesToImport = partitionDS.flatMap((FlatMapFunction & Serializable)sparkPartition -> SparkTableUtil.listPartition(sparkPartition, spec, serializableConf, metricsConfig, nameMapping).iterator(), Encoders.javaSerialization(DataFile.class));
        if (checkDuplicateFiles) {
            Dataset importedFiles = filesToImport.map((MapFunction & Serializable)f -> f.path().toString(), Encoders.STRING()).toDF(new String[]{"file_path"});
            Dataset existingFiles = SparkTableUtil.loadMetadataTable(spark, targetTable, MetadataTableType.ENTRIES).filter("status != 2");
            Column joinCond = existingFiles.col("data_file.file_path").equalTo((Object)importedFiles.col("file_path"));
            Dataset duplicates = importedFiles.join(existingFiles, joinCond).select("file_path", new String[0]).as(Encoders.STRING());
            Preconditions.checkState((boolean)duplicates.isEmpty(), (Object)String.format(DUPLICATE_FILE_MESSAGE, Joiner.on((String)",").join((Object[])((String[])duplicates.take(10)))));
        }
        List manifests = filesToImport.repartition(numShufflePartitions).map((MapFunction & Serializable)file -> Tuple2.apply((Object)file.path().toString(), (Object)file), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.javaSerialization(DataFile.class))).orderBy(new Column[]{functions.col((String)"_1")}).mapPartitions((MapPartitionsFunction & Serializable)fileTuple -> SparkTableUtil.buildManifest(serializableConf, spec, stagingDir, fileTuple), Encoders.javaSerialization(ManifestFile.class)).collectAsList();
        try {
            boolean snapshotIdInheritanceEnabled = PropertyUtil.propertyAsBoolean((java.util.Map)targetTable.properties(), (String)"compatibility.snapshot-id-inheritance.enabled", (boolean)false);
            AppendFiles append = targetTable.newAppend();
            manifests.forEach(arg_0 -> ((AppendFiles)append).appendManifest(arg_0));
            append.commit();
            if (!snapshotIdInheritanceEnabled) {
                SparkTableUtil.deleteManifests(targetTable.io(), manifests);
            }
        }
        catch (Throwable e) {
            SparkTableUtil.deleteManifests(targetTable.io(), manifests);
            throw e;
        }
    }

    public static void importSparkPartitions(SparkSession spark, List<SparkPartition> partitions, Table targetTable, PartitionSpec spec, String stagingDir) {
        SparkTableUtil.importSparkPartitions(spark, partitions, targetTable, spec, stagingDir, false);
    }

    public static List<SparkPartition> filterPartitions(List<SparkPartition> partitions, java.util.Map<String, String> partitionFilter) {
        if (partitionFilter.isEmpty()) {
            return partitions;
        }
        return partitions.stream().filter(p -> p.getValues().entrySet().containsAll(partitionFilter.entrySet())).collect(Collectors.toList());
    }

    private static void deleteManifests(FileIO io, List<ManifestFile> manifests) {
        Tasks.foreach(manifests).executeWith(ThreadPools.getWorkerPool()).noRetry().suppressFailureWhenFinished().run(item -> io.deleteFile(item.path()));
    }

    @Deprecated
    public static Dataset<Row> loadCatalogMetadataTable(SparkSession spark, Table table, MetadataTableType type) {
        return SparkTableUtil.loadMetadataTable(spark, table, type);
    }

    public static Dataset<Row> loadMetadataTable(SparkSession spark, Table table, MetadataTableType type) {
        return SparkTableUtil.loadMetadataTable(spark, table, type, (java.util.Map<String, String>)ImmutableMap.of());
    }

    public static Dataset<Row> loadMetadataTable(SparkSession spark, Table table, MetadataTableType type, java.util.Map<String, String> extraOptions) {
        SparkTable metadataTable = new SparkTable(MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)type), false);
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap(extraOptions);
        return Dataset.ofRows((SparkSession)spark, (LogicalPlan)DataSourceV2Relation.create((org.apache.spark.sql.connector.catalog.Table)metadataTable, (Option)Some.empty(), (Option)Some.empty(), (CaseInsensitiveStringMap)options));
    }

    public static class SparkPartition
    implements Serializable {
        private final java.util.Map<String, String> values;
        private final String uri;
        private final String format;

        public SparkPartition(java.util.Map<String, String> values, String uri, String format) {
            this.values = Maps.newHashMap(values);
            this.uri = uri;
            this.format = format;
        }

        public java.util.Map<String, String> getValues() {
            return this.values;
        }

        public String getUri() {
            return this.uri;
        }

        public String getFormat() {
            return this.format;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("values", this.values).add("uri", (Object)this.uri).add("format", (Object)this.format).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SparkPartition that = (SparkPartition)o;
            return Objects.equal(this.values, that.values) && Objects.equal((Object)this.uri, (Object)that.uri) && Objects.equal((Object)this.format, (Object)that.format);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.values, this.uri, this.format});
        }
    }
}

