/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.util.NaNUtil;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.filter.And;
import org.apache.spark.sql.connector.expressions.filter.Not;
import org.apache.spark.sql.connector.expressions.filter.Or;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkV2Filters {
    private static final String TRUE = "ALWAYS_TRUE";
    private static final String FALSE = "ALWAYS_FALSE";
    private static final String EQ = "=";
    private static final String EQ_NULL_SAFE = "<=>";
    private static final String GT = ">";
    private static final String GT_EQ = ">=";
    private static final String LT = "<";
    private static final String LT_EQ = "<=";
    private static final String IN = "IN";
    private static final String IS_NULL = "IS_NULL";
    private static final String NOT_NULL = "IS_NOT_NULL";
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String NOT = "NOT";
    private static final String STARTS_WITH = "STARTS_WITH";
    private static final Map<String, Expression.Operation> FILTERS = ImmutableMap.builder().put((Object)"ALWAYS_TRUE", (Object)Expression.Operation.TRUE).put((Object)"ALWAYS_FALSE", (Object)Expression.Operation.FALSE).put((Object)"=", (Object)Expression.Operation.EQ).put((Object)"<=>", (Object)Expression.Operation.EQ).put((Object)">", (Object)Expression.Operation.GT).put((Object)">=", (Object)Expression.Operation.GT_EQ).put((Object)"<", (Object)Expression.Operation.LT).put((Object)"<=", (Object)Expression.Operation.LT_EQ).put((Object)"IN", (Object)Expression.Operation.IN).put((Object)"IS_NULL", (Object)Expression.Operation.IS_NULL).put((Object)"IS_NOT_NULL", (Object)Expression.Operation.NOT_NULL).put((Object)"AND", (Object)Expression.Operation.AND).put((Object)"OR", (Object)Expression.Operation.OR).put((Object)"NOT", (Object)Expression.Operation.NOT).put((Object)"STARTS_WITH", (Object)Expression.Operation.STARTS_WITH).buildOrThrow();

    private SparkV2Filters() {
    }

    public static org.apache.iceberg.expressions.Expression convert(Predicate predicate) {
        Expression.Operation op = FILTERS.get(predicate.name());
        if (op != null) {
            switch (op) {
                case TRUE: {
                    return Expressions.alwaysTrue();
                }
                case FALSE: {
                    return Expressions.alwaysFalse();
                }
                case IS_NULL: {
                    return SparkV2Filters.isRef((Expression)SparkV2Filters.child(predicate)) ? Expressions.isNull((String)SparkUtil.toColumnName((NamedReference)SparkV2Filters.child(predicate))) : null;
                }
                case NOT_NULL: {
                    return SparkV2Filters.isRef((Expression)SparkV2Filters.child(predicate)) ? Expressions.notNull((String)SparkUtil.toColumnName((NamedReference)SparkV2Filters.child(predicate))) : null;
                }
                case LT: {
                    if (SparkV2Filters.isRef((Expression)SparkV2Filters.leftChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.rightChild(predicate))) {
                        String columnName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.leftChild(predicate));
                        return Expressions.lessThan((String)columnName, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate)));
                    }
                    if (SparkV2Filters.isRef((Expression)SparkV2Filters.rightChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.leftChild(predicate))) {
                        String columnName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.rightChild(predicate));
                        return Expressions.greaterThan((String)columnName, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.leftChild(predicate)));
                    }
                    return null;
                }
                case LT_EQ: {
                    if (SparkV2Filters.isRef((Expression)SparkV2Filters.leftChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.rightChild(predicate))) {
                        String columnName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.leftChild(predicate));
                        return Expressions.lessThanOrEqual((String)columnName, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate)));
                    }
                    if (SparkV2Filters.isRef((Expression)SparkV2Filters.rightChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.leftChild(predicate))) {
                        String columnName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.rightChild(predicate));
                        return Expressions.greaterThanOrEqual((String)columnName, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.leftChild(predicate)));
                    }
                    return null;
                }
                case GT: {
                    if (SparkV2Filters.isRef((Expression)SparkV2Filters.leftChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.rightChild(predicate))) {
                        String columnName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.leftChild(predicate));
                        return Expressions.greaterThan((String)columnName, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate)));
                    }
                    if (SparkV2Filters.isRef((Expression)SparkV2Filters.rightChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.leftChild(predicate))) {
                        String columnName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.rightChild(predicate));
                        return Expressions.lessThan((String)columnName, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.leftChild(predicate)));
                    }
                    return null;
                }
                case GT_EQ: {
                    if (SparkV2Filters.isRef((Expression)SparkV2Filters.leftChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.rightChild(predicate))) {
                        String columnName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.leftChild(predicate));
                        return Expressions.greaterThanOrEqual((String)columnName, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate)));
                    }
                    if (SparkV2Filters.isRef((Expression)SparkV2Filters.rightChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.leftChild(predicate))) {
                        String columnName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.rightChild(predicate));
                        return Expressions.lessThanOrEqual((String)columnName, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.leftChild(predicate)));
                    }
                    return null;
                }
                case EQ: {
                    Object value;
                    String columnName;
                    if (SparkV2Filters.isRef((Expression)SparkV2Filters.leftChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.rightChild(predicate))) {
                        columnName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.leftChild(predicate));
                        value = SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate));
                    } else if (SparkV2Filters.isRef((Expression)SparkV2Filters.rightChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.leftChild(predicate))) {
                        columnName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.rightChild(predicate));
                        value = SparkV2Filters.convertLiteral((Literal)SparkV2Filters.leftChild(predicate));
                    } else {
                        return null;
                    }
                    if (predicate.name().equals(EQ)) {
                        Preconditions.checkNotNull((Object)value, (String)"Expression is always false (eq is not null-safe): %s", (Object)predicate);
                        return SparkV2Filters.handleEqual(columnName, value);
                    }
                    if (value == null) {
                        return Expressions.isNull((String)columnName);
                    }
                    return SparkV2Filters.handleEqual(columnName, value);
                }
                case IN: {
                    if (SparkV2Filters.isSupportedInPredicate(predicate)) {
                        return Expressions.in((String)SparkUtil.toColumnName((NamedReference)SparkV2Filters.childAtIndex(predicate, 0)), (Iterable)Arrays.stream(predicate.children()).skip(1L).map(val -> SparkV2Filters.convertLiteral((Literal)val)).filter(Objects::nonNull).collect(Collectors.toList()));
                    }
                    return null;
                }
                case NOT: {
                    org.apache.iceberg.expressions.Expression child;
                    Not notPredicate = (Not)predicate;
                    Predicate childPredicate = notPredicate.child();
                    if (childPredicate.name().equals(IN) && SparkV2Filters.isSupportedInPredicate(childPredicate)) {
                        UnboundPredicate notIn = Expressions.notIn((String)SparkUtil.toColumnName((NamedReference)SparkV2Filters.childAtIndex(childPredicate, 0)), (Iterable)Arrays.stream(childPredicate.children()).skip(1L).map(val -> SparkV2Filters.convertLiteral((Literal)val)).filter(Objects::nonNull).collect(Collectors.toList()));
                        return Expressions.and((org.apache.iceberg.expressions.Expression)Expressions.notNull((String)SparkUtil.toColumnName((NamedReference)SparkV2Filters.childAtIndex(childPredicate, 0))), (org.apache.iceberg.expressions.Expression)notIn);
                    }
                    if (SparkV2Filters.hasNoInFilter(childPredicate) && (child = SparkV2Filters.convert(childPredicate)) != null) {
                        return Expressions.not((org.apache.iceberg.expressions.Expression)child);
                    }
                    return null;
                }
                case AND: {
                    And andPredicate = (And)predicate;
                    org.apache.iceberg.expressions.Expression left = SparkV2Filters.convert(andPredicate.left());
                    org.apache.iceberg.expressions.Expression right = SparkV2Filters.convert(andPredicate.right());
                    if (left != null && right != null) {
                        return Expressions.and((org.apache.iceberg.expressions.Expression)left, (org.apache.iceberg.expressions.Expression)right);
                    }
                    return null;
                }
                case OR: {
                    Or orPredicate = (Or)predicate;
                    org.apache.iceberg.expressions.Expression left = SparkV2Filters.convert(orPredicate.left());
                    org.apache.iceberg.expressions.Expression right = SparkV2Filters.convert(orPredicate.right());
                    if (left != null && right != null) {
                        return Expressions.or((org.apache.iceberg.expressions.Expression)left, (org.apache.iceberg.expressions.Expression)right);
                    }
                    return null;
                }
                case STARTS_WITH: {
                    String colName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.leftChild(predicate));
                    return Expressions.startsWith((String)colName, (String)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate)).toString());
                }
            }
        }
        return null;
    }

    private static <T> T child(Predicate predicate) {
        Expression[] children = predicate.children();
        Preconditions.checkArgument((children.length == 1 ? 1 : 0) != 0, (String)"Predicate should have one child: %s", (Object)predicate);
        return (T)children[0];
    }

    private static <T> T leftChild(Predicate predicate) {
        Expression[] children = predicate.children();
        Preconditions.checkArgument((children.length == 2 ? 1 : 0) != 0, (String)"Predicate should have two children: %s", (Object)predicate);
        return (T)children[0];
    }

    private static <T> T rightChild(Predicate predicate) {
        Expression[] children = predicate.children();
        Preconditions.checkArgument((children.length == 2 ? 1 : 0) != 0, (String)"Predicate should have two children: %s", (Object)predicate);
        return (T)children[1];
    }

    private static <T> T childAtIndex(Predicate predicate, int index) {
        return (T)predicate.children()[index];
    }

    private static boolean isRef(Expression expr) {
        return expr instanceof NamedReference;
    }

    private static boolean isLiteral(Expression expr) {
        return expr instanceof Literal;
    }

    private static Object convertLiteral(Literal<?> literal) {
        if (literal.value() instanceof UTF8String) {
            return ((UTF8String)literal.value()).toString();
        }
        return literal.value();
    }

    private static org.apache.iceberg.expressions.Expression handleEqual(String attribute, Object value) {
        if (NaNUtil.isNaN((Object)value)) {
            return Expressions.isNaN((String)attribute);
        }
        return Expressions.equal((String)attribute, (Object)value);
    }

    private static boolean hasNoInFilter(Predicate predicate) {
        Expression.Operation op = FILTERS.get(predicate.name());
        if (op != null) {
            switch (op) {
                case AND: {
                    And andPredicate = (And)predicate;
                    return SparkV2Filters.hasNoInFilter(andPredicate.left()) && SparkV2Filters.hasNoInFilter(andPredicate.right());
                }
                case OR: {
                    Or orPredicate = (Or)predicate;
                    return SparkV2Filters.hasNoInFilter(orPredicate.left()) && SparkV2Filters.hasNoInFilter(orPredicate.right());
                }
                case NOT: {
                    Not notPredicate = (Not)predicate;
                    return SparkV2Filters.hasNoInFilter(notPredicate.child());
                }
                case IN: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isSupportedInPredicate(Predicate predicate) {
        if (!SparkV2Filters.isRef((Expression)SparkV2Filters.childAtIndex(predicate, 0))) {
            return false;
        }
        return Arrays.stream(predicate.children()).skip(1L).allMatch(SparkV2Filters::isLiteral);
    }
}

