/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.SizeBasedPositionDeletesRewriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.PositionDeletesRewriteCoordinator;
import org.apache.iceberg.spark.ScanTaskSetManager;
import org.apache.iceberg.spark.SparkTableCache;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.internal.SQLConf;

class SparkBinPackPositionDeletesRewriter
extends SizeBasedPositionDeletesRewriter {
    private final SparkSession spark;
    private final SparkTableCache tableCache = SparkTableCache.get();
    private final ScanTaskSetManager taskSetManager = ScanTaskSetManager.get();
    private final PositionDeletesRewriteCoordinator coordinator = PositionDeletesRewriteCoordinator.get();

    SparkBinPackPositionDeletesRewriter(SparkSession spark, Table table) {
        super(table);
        this.spark = spark.cloneSession();
        this.spark.conf().set(SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), false);
    }

    public String description() {
        return "BIN-PACK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DeleteFile> rewrite(List<PositionDeletesScanTask> group) {
        String groupId = UUID.randomUUID().toString();
        Table deletesTable = MetadataTableUtils.createMetadataTableInstance((Table)this.table(), (MetadataTableType)MetadataTableType.POSITION_DELETES);
        try {
            this.tableCache.add(groupId, deletesTable);
            this.taskSetManager.stageTasks(deletesTable, groupId, group);
            this.doRewrite(groupId, group);
            Set set = this.coordinator.fetchNewFiles(deletesTable, groupId);
            return set;
        }
        finally {
            this.tableCache.remove(groupId);
            this.taskSetManager.removeTasks(deletesTable, groupId);
            this.coordinator.clearRewrite(deletesTable, groupId);
        }
    }

    protected void doRewrite(String groupId, List<PositionDeletesScanTask> group) {
        Preconditions.checkArgument((group.size() > 0 ? 1 : 0) != 0, (Object)"Empty group");
        Types.StructType partitionType = group.get(0).spec().partitionType();
        StructLike partition = group.get(0).partition();
        Dataset posDeletes = this.spark.read().format("iceberg").option("scan-task-set-id", groupId).option("split-size", this.splitSize(this.inputSize(group))).option("file-open-cost", "0").load(groupId);
        Dataset<Row> dataFiles = this.dataFiles(partitionType, partition);
        Column joinCond = posDeletes.col("file_path").equalTo((Object)dataFiles.col("file_path"));
        Dataset validDeletes = posDeletes.join(dataFiles, joinCond, "leftsemi");
        validDeletes.sortWithinPartitions("file_path", new String[]{"pos"}).write().format("iceberg").option("rewritten-file-scan-task-set-id", groupId).option("target-delete-file-size-bytes", this.writeMaxFileSize()).mode("append").save(groupId);
    }

    private Dataset<Row> dataFiles(Types.StructType partitionType, StructLike partition) {
        List fields = partitionType.fields();
        Optional<Column> condition = IntStream.range(0, fields.size()).mapToObj(i -> {
            Class type = ((Types.NestedField)fields.get(i)).type().typeId().javaClass();
            Object value = partition.get(i, type);
            Column col = functions.col((String)("partition." + ((Types.NestedField)fields.get(i)).name()));
            return col.equalTo(value);
        }).reduce(Column::and);
        if (condition.isPresent()) {
            return SparkTableUtil.loadMetadataTable(this.spark, this.table(), MetadataTableType.DATA_FILES).filter(condition.get());
        }
        return SparkTableUtil.loadMetadataTable(this.spark, this.table(), MetadataTableType.DATA_FILES);
    }
}

