/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.RewriteDataFiles;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Zorder;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.ExtendedParser;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.actions.RewriteDataFilesSparkAction;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.execution.datasources.SparkExpressionConverter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.runtime.BoxedUnit;

class RewriteDataFilesProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("strategy", DataTypes.StringType), ProcedureParameter.optional("sort_order", DataTypes.StringType), ProcedureParameter.optional("options", STRING_MAP), ProcedureParameter.optional("where", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("rewritten_data_files_count", DataTypes.IntegerType, false, Metadata.empty()), new StructField("added_data_files_count", DataTypes.IntegerType, false, Metadata.empty()), new StructField("rewritten_bytes_count", DataTypes.LongType, false, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RewriteDataFilesProcedure>(){

            @Override
            protected RewriteDataFilesProcedure doBuild() {
                return new RewriteDataFilesProcedure(this.tableCatalog());
            }
        };
    }

    private RewriteDataFilesProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        return this.modifyIcebergTable(tableIdent, table -> {
            String sortOrderString;
            String quotedFullIdentifier = Spark3Util.quotedFullIdentifier(this.tableCatalog().name(), tableIdent);
            RewriteDataFilesSparkAction action = this.actions().rewriteDataFiles((Table)table);
            String strategy = args.isNullAt(1) ? null : args.getString(1);
            String string = sortOrderString = args.isNullAt(2) ? null : args.getString(2);
            if (strategy != null || sortOrderString != null) {
                action = this.checkAndApplyStrategy(action, strategy, sortOrderString, table.schema());
            }
            if (!args.isNullAt(3)) {
                action = this.checkAndApplyOptions(args, action);
            }
            String where = args.isNullAt(4) ? null : args.getString(4);
            action = this.checkAndApplyFilter(action, where, quotedFullIdentifier);
            RewriteDataFiles.Result result = (RewriteDataFiles.Result)action.execute();
            return this.toOutputRows(result);
        });
    }

    private RewriteDataFiles checkAndApplyFilter(RewriteDataFiles action, String where, String tableName) {
        if (where != null) {
            try {
                Expression expression = SparkExpressionConverter.collectResolvedSparkExpression(this.spark(), tableName, where);
                return action.filter(SparkExpressionConverter.convertToIcebergExpression(expression));
            }
            catch (AnalysisException e) {
                throw new IllegalArgumentException("Cannot parse predicates in where option: " + where);
            }
        }
        return action;
    }

    private RewriteDataFiles checkAndApplyOptions(InternalRow args, RewriteDataFiles action) {
        HashMap options = Maps.newHashMap();
        args.getMap(3).foreach(DataTypes.StringType, DataTypes.StringType, (k, v) -> {
            options.put(k.toString(), v.toString());
            return BoxedUnit.UNIT;
        });
        return (RewriteDataFiles)action.options((Map)options);
    }

    private RewriteDataFiles checkAndApplyStrategy(RewriteDataFiles action, String strategy, String sortOrderString, Schema schema) {
        ArrayList zOrderTerms = Lists.newArrayList();
        ArrayList sortOrderFields = Lists.newArrayList();
        if (sortOrderString != null) {
            ExtendedParser.parseSortOrder(this.spark(), sortOrderString).forEach(field -> {
                if (field.term() instanceof Zorder) {
                    zOrderTerms.add((Zorder)field.term());
                } else {
                    sortOrderFields.add(field);
                }
            });
            if (!zOrderTerms.isEmpty() && !sortOrderFields.isEmpty()) {
                throw new IllegalArgumentException("Cannot mix identity sort columns and a Zorder sort expression: " + sortOrderString);
            }
        }
        if (strategy == null || strategy.equalsIgnoreCase("sort")) {
            if (!zOrderTerms.isEmpty()) {
                String[] columnNames = (String[])zOrderTerms.stream().flatMap(zOrder -> zOrder.refs().stream().map(NamedReference::name)).toArray(String[]::new);
                return action.zOrder(columnNames);
            }
            if (!sortOrderFields.isEmpty()) {
                return action.sort(this.buildSortOrder(sortOrderFields, schema));
            }
            return action.sort();
        }
        if (strategy.equalsIgnoreCase("binpack")) {
            RewriteDataFiles rewriteDataFiles = action.binPack();
            if (sortOrderString != null) {
                return rewriteDataFiles.sort(this.buildSortOrder(sortOrderFields, schema));
            }
            return rewriteDataFiles;
        }
        throw new IllegalArgumentException("unsupported strategy: " + strategy + ". Only binpack or sort is supported");
    }

    private SortOrder buildSortOrder(List<ExtendedParser.RawOrderField> rawOrderFields, Schema schema) {
        SortOrder.Builder builder = SortOrder.builderFor((Schema)schema);
        rawOrderFields.forEach(rawField -> builder.sortBy(rawField.term(), rawField.direction(), rawField.nullOrder()));
        return builder.build();
    }

    private InternalRow[] toOutputRows(RewriteDataFiles.Result result) {
        int rewrittenDataFilesCount = result.rewrittenDataFilesCount();
        long rewrittenBytesCount = result.rewrittenBytesCount();
        int addedDataFilesCount = result.addedDataFilesCount();
        InternalRow row = this.newInternalRow(rewrittenDataFilesCount, addedDataFilesCount, rewrittenBytesCount);
        return new InternalRow[]{row};
    }

    @Override
    public String description() {
        return "RewriteDataFilesProcedure";
    }
}

