/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.RewritePositionDeleteFiles;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.actions.RewritePositionDeleteFilesSparkAction;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.ProcedureInput;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class RewritePositionDeleteFilesProcedure
extends BaseProcedure {
    private static final ProcedureParameter TABLE_PARAM = ProcedureParameter.required("table", DataTypes.StringType);
    private static final ProcedureParameter OPTIONS_PARAM = ProcedureParameter.optional("options", STRING_MAP);
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{TABLE_PARAM, OPTIONS_PARAM};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("rewritten_delete_files_count", DataTypes.IntegerType, false, Metadata.empty()), new StructField("added_delete_files_count", DataTypes.IntegerType, false, Metadata.empty()), new StructField("rewritten_bytes_count", DataTypes.LongType, false, Metadata.empty()), new StructField("added_bytes_count", DataTypes.LongType, false, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RewritePositionDeleteFilesProcedure>(){

            @Override
            protected RewritePositionDeleteFilesProcedure doBuild() {
                return new RewritePositionDeleteFilesProcedure(this.tableCatalog());
            }
        };
    }

    private RewritePositionDeleteFilesProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        ProcedureInput input = new ProcedureInput(this.spark(), this.tableCatalog(), PARAMETERS, args);
        Identifier tableIdent = input.ident(TABLE_PARAM);
        Map<String, String> options = input.asStringMap(OPTIONS_PARAM, (Map<String, String>)ImmutableMap.of());
        return this.modifyIcebergTable(tableIdent, table -> {
            RewritePositionDeleteFiles.Result result = ((RewritePositionDeleteFilesSparkAction)this.actions().rewritePositionDeletes((Table)table).options(options)).execute();
            return new InternalRow[]{this.toOutputRow(result)};
        });
    }

    private InternalRow toOutputRow(RewritePositionDeleteFiles.Result result) {
        return this.newInternalRow(result.rewrittenDeleteFilesCount(), result.addedDeleteFilesCount(), result.rewrittenBytesCount(), result.addedBytesCount());
    }

    @Override
    public String description() {
        return "RewritePositionDeleteFilesProcedure";
    }
}

