/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.IcebergBuild;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.iceberg.spark.functions.IcebergVersionFunction;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFunctionCatalog
extends SparkTestBaseWithCatalog {
    private static final String[] EMPTY_NAMESPACE = new String[0];
    private static final String[] SYSTEM_NAMESPACE = new String[]{"system"};
    private static final String[] DEFAULT_NAMESPACE = new String[]{"default"};
    private static final String[] DB_NAMESPACE = new String[]{"db"};
    private final FunctionCatalog asFunctionCatalog;

    public TestFunctionCatalog() {
        this.asFunctionCatalog = this.castToFunctionCatalog(this.catalogName);
    }

    @Before
    public void createDefaultNamespace() {
        this.sql("CREATE NAMESPACE IF NOT EXISTS %s", this.catalogName + ".default");
    }

    @After
    public void dropDefaultNamespace() {
        this.sql("DROP NAMESPACE IF EXISTS %s", this.catalogName + ".default");
    }

    @Test
    public void testListFunctionsViaCatalog() throws NoSuchNamespaceException {
        Assertions.assertThat((Object[])this.asFunctionCatalog.listFunctions(EMPTY_NAMESPACE)).anyMatch(func -> "iceberg_version".equals(func.name()));
        Assertions.assertThat((Object[])this.asFunctionCatalog.listFunctions(SYSTEM_NAMESPACE)).anyMatch(func -> "iceberg_version".equals(func.name()));
        Assert.assertArrayEquals((String)"Listing functions in an existing namespace that's not system should not throw", (Object[])new Identifier[0], (Object[])this.asFunctionCatalog.listFunctions(DEFAULT_NAMESPACE));
        AssertHelpers.assertThrows((String)"Listing functions in a namespace that does not exist should throw", NoSuchNamespaceException.class, (String)"Namespace 'db' not found", () -> this.asFunctionCatalog.listFunctions(DB_NAMESPACE));
    }

    @Test
    public void testLoadFunctions() throws NoSuchFunctionException {
        for (String[] namespace : ImmutableList.of((Object)EMPTY_NAMESPACE, (Object)SYSTEM_NAMESPACE)) {
            Identifier identifier = Identifier.of((String[])namespace, (String)"iceberg_version");
            UnboundFunction func = this.asFunctionCatalog.loadFunction(identifier);
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)func).isNotNull()).isInstanceOf(UnboundFunction.class)).isExactlyInstanceOf(IcebergVersionFunction.class);
        }
        AssertHelpers.assertThrows((String)"Cannot load a function if it's not used with the system namespace or the empty namespace", NoSuchFunctionException.class, (String)"Undefined function: default.iceberg_version", () -> this.asFunctionCatalog.loadFunction(Identifier.of((String[])DEFAULT_NAMESPACE, (String)"iceberg_version")));
        Identifier undefinedFunction = Identifier.of((String[])SYSTEM_NAMESPACE, (String)"undefined_function");
        AssertHelpers.assertThrows((String)"Cannot load a function that does not exist", NoSuchFunctionException.class, (String)"Undefined function: system.undefined_function", () -> this.asFunctionCatalog.loadFunction(undefinedFunction));
        AssertHelpers.assertThrows((String)"Using an undefined function from SQL should fail analysis", AnalysisException.class, (String)"Undefined function", () -> this.sql("SELECT undefined_function(1, 2)", new Object[0]));
    }

    @Test
    public void testCallingFunctionInSQLEndToEnd() {
        String buildVersion = IcebergBuild.version();
        Assert.assertEquals((String)"Should be able to use the Iceberg version function from the fully qualified system namespace", (Object)buildVersion, (Object)this.scalarSql("SELECT %s.system.iceberg_version()", this.catalogName));
        Assert.assertEquals((String)"Should be able to use the Iceberg version function when fully qualified without specifying a namespace", (Object)buildVersion, (Object)this.scalarSql("SELECT %s.iceberg_version()", this.catalogName));
        this.sql("USE %s", this.catalogName);
        Assert.assertEquals((String)"Should be able to call iceberg_version from system namespace without fully qualified name when using Iceberg catalog", (Object)buildVersion, (Object)this.scalarSql("SELECT system.iceberg_version()", new Object[0]));
        Assert.assertEquals((String)"Should be able to call iceberg_version from empty namespace without fully qualified name when using Iceberg catalog", (Object)buildVersion, (Object)this.scalarSql("SELECT iceberg_version()", new Object[0]));
    }

    private FunctionCatalog castToFunctionCatalog(String name) {
        return (FunctionCatalog)spark.sessionState().catalogManager().catalog(name);
    }
}

