/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.spark.BaseCatalog;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSparkCatalogOperations
extends SparkCatalogTestBase {
    public TestSparkCatalogOperations(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Before
    public void createTable() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", this.tableName);
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testAlterTable() throws NoSuchTableException {
        BaseCatalog catalog = (BaseCatalog)spark.sessionState().catalogManager().catalog(this.catalogName);
        Identifier identifier = Identifier.of((String[])this.tableIdent.namespace().levels(), (String)this.tableIdent.name());
        String fieldName = "location";
        String propsKey = "note";
        String propsValue = "jazz";
        Table table = catalog.alterTable(identifier, new TableChange[]{TableChange.addColumn((String[])new String[]{fieldName}, (DataType)DataTypes.StringType, (boolean)true), TableChange.setProperty((String)propsKey, (String)propsValue)});
        Assert.assertNotNull((String)"Should return updated table", (Object)table);
        StructField expectedField = DataTypes.createStructField((String)fieldName, (DataType)DataTypes.StringType, (boolean)true);
        Assert.assertEquals((String)"Adding a column to a table should return the updated table with the new column", (Object)table.schema().fields()[2], (Object)expectedField);
        Assert.assertTrue((String)"Adding a property to a table should return the updated table with the new property", (boolean)table.properties().containsKey(propsKey));
        Assert.assertEquals((String)"Altering a table to add a new property should add the correct value", (Object)propsValue, table.properties().get(propsKey));
    }

    @Test
    public void testInvalidateTable() {
        this.sql("SELECT count(1) FROM %s", this.tableName);
        Catalog anotherCatalog = this.validationCatalog;
        Schema schema = anotherCatalog.loadTable(this.tableIdent).schema();
        anotherCatalog.dropTable(this.tableIdent);
        anotherCatalog.createTable(this.tableIdent, schema);
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("SELECT count(1) FROM %s", this.tableName);
    }
}

