/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkDistributionAndOrderingUtil;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.spark.sql.connector.distributions.ClusteredDistribution;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestSparkDistributionAndOrderingUtil
extends SparkTestBaseWithCatalog {
    private static final Distribution UNSPECIFIED_DISTRIBUTION = Distributions.unspecified();
    private static final Distribution FILE_CLUSTERED_DISTRIBUTION = Distributions.clustered((Expression[])new Expression[]{Expressions.column((String)MetadataColumns.FILE_PATH.name())});
    private static final Distribution SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION = Distributions.clustered((Expression[])new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition")});
    private static final SortOrder[] EMPTY_ORDERING = new SortOrder[0];
    private static final SortOrder[] FILE_POSITION_ORDERING = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING)};
    private static final SortOrder[] SPEC_ID_PARTITION_FILE_ORDERING = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING)};
    private static final SortOrder[] SPEC_ID_PARTITION_FILE_POSITION_ORDERING = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING)};

    @After
    public void dropTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testDefaultWriteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkWriteDistributionAndOrdering(table, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @Test
    public void testHashWriteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "hash").commit();
        this.checkWriteDistributionAndOrdering(table, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @Test
    public void testRangeWriteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "range").commit();
        this.checkWriteDistributionAndOrdering(table, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @Test
    public void testDefaultWriteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testHashWriteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkWriteDistributionAndOrdering(table, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testRangeWriteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultWritePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testHashWritePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "hash").commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testRangeWritePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "range").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultWritePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testHashWritePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testRangeWritePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultCopyOnWriteDeleteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, FILE_POSITION_ORDERING);
    }

    @Test
    public void testNoneCopyOnWriteDeleteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @Test
    public void testHashCopyOnWriteDeleteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, FILE_POSITION_ORDERING);
    }

    @Test
    public void testRangeCopyOnWriteDeleteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])FILE_POSITION_ORDERING);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, FILE_POSITION_ORDERING);
    }

    @Test
    public void testDefaultCopyOnWriteDeleteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testNoneCopyOnWriteDeleteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testHashCopyOnWriteDeleteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testRangeCopyOnWriteDeleteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultCopyOnWriteDeletePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testNoneCopyOnWriteDeletePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testHashCopyOnWriteDeletePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testRangeCopyOnWriteDeletePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultCopyOnWriteDeletePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testNoneCopyOnWriteDeletePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testHashCopyOnWriteDeletePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testRangeCopyOnWriteDeletePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultCopyOnWriteUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, FILE_POSITION_ORDERING);
    }

    @Test
    public void testNoneCopyOnWriteUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @Test
    public void testHashCopyOnWriteUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, FILE_POSITION_ORDERING);
    }

    @Test
    public void testRangeCopyOnWriteUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])FILE_POSITION_ORDERING);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, FILE_POSITION_ORDERING);
    }

    @Test
    public void testDefaultCopyOnWriteUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testNoneCopyOnWriteUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testHashCopyOnWriteUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testRangeCopyOnWriteUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultCopyOnWriteUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testNoneCopyOnWriteUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testHashCopyOnWriteUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testRangeCopyOnWriteUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultCopyOnWriteUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testNoneCopyOnWriteUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testHashCopyOnWriteUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testRangeCopyOnWriteUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultCopyOnWriteMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @Test
    public void testNoneCopyOnWriteMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @Test
    public void testHashCopyOnWriteMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @Test
    public void testRangeCopyOnWriteMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @Test
    public void testDefaultCopyOnWriteMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testNoneCopyOnWriteMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testHashCopyOnWriteMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testRangeCopyOnWriteMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultCopyOnWriteMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testNoneCopyOnWriteMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testHashCopyOnWriteMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testRangeCopyOnWriteMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultCopyOnWriteMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testNoneCopyOnWriteMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testHashCopyOnWriteMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testRangeCopyOnWriteMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultPositionDeltaDeleteUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testNonePositionDeltaDeleteUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testHashPositionDeltaDeleteUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testRangePositionDeltaDeleteUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])SPEC_ID_PARTITION_FILE_ORDERING);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testDefaultPositionDeltaDeletePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testNonePositionDeltaDeletePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testHashPositionDeltaDeletePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testRangePositionDeltaDeletePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])SPEC_ID_PARTITION_FILE_ORDERING);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testDefaultPositionDeltaUpdateUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testNonePositionDeltaUpdateUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testHashPositionDeltaUpdateUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testRangePositionDeltaUpdateUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])SPEC_ID_PARTITION_FILE_ORDERING);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testDefaultPositionDeltaUpdatePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testNonePositionDeltaUpdatePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testHashPositionDeltaUpdatePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testRangePositionDeltaUpdatePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])SPEC_ID_PARTITION_FILE_ORDERING);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testDefaultPositionDeltaMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.column((String)MetadataColumns.FILE_PATH.name())};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testNonePositionDeltaMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testHashPositionDeltaMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.column((String)MetadataColumns.FILE_PATH.name())};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testRangePositionDeltaMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        SortOrder[] expectedDistributionOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedDistributionOrdering);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
    }

    @Test
    public void testDefaultPositionDeltaMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.column((String)MetadataColumns.FILE_PATH.name())};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testNonePositionDeltaMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testHashPositionDeltaMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.column((String)MetadataColumns.FILE_PATH.name())};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testRangePositionDeltaMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedDistributionOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedDistributionOrdering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testDefaultPositionDeltaMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testNonePositionDeltaMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testHashPositionDeltaMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testRangePositionDeltaMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        SortOrder[] expectedDistributionOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedDistributionOrdering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testNonePositionDeltaMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @Test
    public void testDefaultPositionDeltaMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testHashPositionDeltaMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @Test
    public void testRangePositionDeltaMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        SortOrder[] expectedDistributionOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedDistributionOrdering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    private void checkWriteDistributionAndOrdering(Table table, Distribution expectedDistribution, SortOrder[] expectedOrdering) {
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        DistributionMode distributionMode = writeConf.distributionMode();
        Distribution distribution = SparkDistributionAndOrderingUtil.buildRequiredDistribution((Table)table, (DistributionMode)distributionMode);
        Assert.assertEquals((String)"Distribution must match", (Object)expectedDistribution, (Object)distribution);
        Object[] ordering = SparkDistributionAndOrderingUtil.buildRequiredOrdering((Table)table, (Distribution)distribution);
        Assert.assertArrayEquals((String)"Ordering must match", (Object[])expectedOrdering, (Object[])ordering);
    }

    private void checkCopyOnWriteDistributionAndOrdering(Table table, RowLevelOperation.Command command, Distribution expectedDistribution, SortOrder[] expectedOrdering) {
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        DistributionMode mode = this.copyOnWriteDistributionMode(command, writeConf);
        Distribution distribution = SparkDistributionAndOrderingUtil.buildCopyOnWriteDistribution((Table)table, (RowLevelOperation.Command)command, (DistributionMode)mode);
        Assert.assertEquals((String)"Distribution must match", (Object)expectedDistribution, (Object)distribution);
        Object[] ordering = SparkDistributionAndOrderingUtil.buildCopyOnWriteOrdering((Table)table, (RowLevelOperation.Command)command, (Distribution)distribution);
        Assert.assertArrayEquals((String)"Ordering must match", (Object[])expectedOrdering, (Object[])ordering);
    }

    private DistributionMode copyOnWriteDistributionMode(RowLevelOperation.Command command, SparkWriteConf writeConf) {
        switch (command) {
            case DELETE: {
                return writeConf.deleteDistributionMode();
            }
            case UPDATE: {
                return writeConf.updateDistributionMode();
            }
            case MERGE: {
                return writeConf.copyOnWriteMergeDistributionMode();
            }
        }
        throw new IllegalArgumentException("Unexpected command: " + command);
    }

    private void checkPositionDeltaDistributionAndOrdering(Table table, RowLevelOperation.Command command, Distribution expectedDistribution, SortOrder[] expectedOrdering) {
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        DistributionMode mode = this.positionDeltaDistributionMode(command, writeConf);
        Distribution distribution = SparkDistributionAndOrderingUtil.buildPositionDeltaDistribution((Table)table, (RowLevelOperation.Command)command, (DistributionMode)mode);
        Assert.assertEquals((String)"Distribution must match", (Object)expectedDistribution, (Object)distribution);
        Object[] ordering = SparkDistributionAndOrderingUtil.buildPositionDeltaOrdering((Table)table, (RowLevelOperation.Command)command);
        Assert.assertArrayEquals((String)"Ordering must match", (Object[])expectedOrdering, (Object[])ordering);
    }

    private DistributionMode positionDeltaDistributionMode(RowLevelOperation.Command command, SparkWriteConf writeConf) {
        switch (command) {
            case DELETE: {
                return writeConf.deleteDistributionMode();
            }
            case UPDATE: {
                return writeConf.updateDistributionMode();
            }
            case MERGE: {
                return writeConf.positionDeltaMergeDistributionMode();
            }
        }
        throw new IllegalArgumentException("Unexpected command: " + command);
    }
}

