/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkV2Filters;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.filter.And;
import org.apache.spark.sql.connector.expressions.filter.Not;
import org.apache.spark.sql.connector.expressions.filter.Or;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.Assert;
import org.junit.Test;

public class TestSparkV2Filters {
    @Test
    public void testV2Filters() {
        HashMap attrMap = Maps.newHashMap();
        attrMap.put("id", "id");
        attrMap.put("`i.d`", "i.d");
        attrMap.put("`i``d`", "i`d");
        attrMap.put("`d`.b.`dd```", "d.b.dd`");
        attrMap.put("a.`aa```.c", "a.aa`.c");
        attrMap.forEach((quoted, unquoted) -> {
            NamedReference namedReference = FieldReference.apply((String)quoted);
            Expression[] attrOnly = new Expression[]{namedReference};
            LiteralValue value = new LiteralValue((Object)1, DataTypes.IntegerType);
            Expression[] attrAndValue = new Expression[]{namedReference, value};
            Expression[] valueAndAttr = new Expression[]{value, namedReference};
            Predicate isNull = new Predicate("IS_NULL", attrOnly);
            UnboundPredicate expectedIsNull = Expressions.isNull((String)unquoted);
            org.apache.iceberg.expressions.Expression actualIsNull = SparkV2Filters.convert((Predicate)isNull);
            Assert.assertEquals((String)"IsNull must match", (Object)expectedIsNull.toString(), (Object)actualIsNull.toString());
            Predicate isNotNull = new Predicate("IS_NOT_NULL", attrOnly);
            UnboundPredicate expectedIsNotNull = Expressions.notNull((String)unquoted);
            org.apache.iceberg.expressions.Expression actualIsNotNull = SparkV2Filters.convert((Predicate)isNotNull);
            Assert.assertEquals((String)"IsNotNull must match", (Object)expectedIsNotNull.toString(), (Object)actualIsNotNull.toString());
            Predicate lt1 = new Predicate("<", attrAndValue);
            UnboundPredicate expectedLt1 = Expressions.lessThan((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualLt1 = SparkV2Filters.convert((Predicate)lt1);
            Assert.assertEquals((String)"LessThan must match", (Object)expectedLt1.toString(), (Object)actualLt1.toString());
            Predicate lt2 = new Predicate("<", valueAndAttr);
            UnboundPredicate expectedLt2 = Expressions.greaterThan((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualLt2 = SparkV2Filters.convert((Predicate)lt2);
            Assert.assertEquals((String)"LessThan must match", (Object)expectedLt2.toString(), (Object)actualLt2.toString());
            Predicate ltEq1 = new Predicate("<=", attrAndValue);
            UnboundPredicate expectedLtEq1 = Expressions.lessThanOrEqual((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualLtEq1 = SparkV2Filters.convert((Predicate)ltEq1);
            Assert.assertEquals((String)"LessThanOrEqual must match", (Object)expectedLtEq1.toString(), (Object)actualLtEq1.toString());
            Predicate ltEq2 = new Predicate("<=", valueAndAttr);
            UnboundPredicate expectedLtEq2 = Expressions.greaterThanOrEqual((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualLtEq2 = SparkV2Filters.convert((Predicate)ltEq2);
            Assert.assertEquals((String)"LessThanOrEqual must match", (Object)expectedLtEq2.toString(), (Object)actualLtEq2.toString());
            Predicate gt1 = new Predicate(">", attrAndValue);
            UnboundPredicate expectedGt1 = Expressions.greaterThan((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualGt1 = SparkV2Filters.convert((Predicate)gt1);
            Assert.assertEquals((String)"GreaterThan must match", (Object)expectedGt1.toString(), (Object)actualGt1.toString());
            Predicate gt2 = new Predicate(">", valueAndAttr);
            UnboundPredicate expectedGt2 = Expressions.lessThan((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualGt2 = SparkV2Filters.convert((Predicate)gt2);
            Assert.assertEquals((String)"GreaterThan must match", (Object)expectedGt2.toString(), (Object)actualGt2.toString());
            Predicate gtEq1 = new Predicate(">=", attrAndValue);
            UnboundPredicate expectedGtEq1 = Expressions.greaterThanOrEqual((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualGtEq1 = SparkV2Filters.convert((Predicate)gtEq1);
            Assert.assertEquals((String)"GreaterThanOrEqual must match", (Object)expectedGtEq1.toString(), (Object)actualGtEq1.toString());
            Predicate gtEq2 = new Predicate(">=", valueAndAttr);
            UnboundPredicate expectedGtEq2 = Expressions.lessThanOrEqual((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualGtEq2 = SparkV2Filters.convert((Predicate)gtEq2);
            Assert.assertEquals((String)"GreaterThanOrEqual must match", (Object)expectedGtEq2.toString(), (Object)actualGtEq2.toString());
            Predicate eq1 = new Predicate("=", attrAndValue);
            UnboundPredicate expectedEq1 = Expressions.equal((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualEq1 = SparkV2Filters.convert((Predicate)eq1);
            Assert.assertEquals((String)"EqualTo must match", (Object)expectedEq1.toString(), (Object)actualEq1.toString());
            Predicate eq2 = new Predicate("=", valueAndAttr);
            UnboundPredicate expectedEq2 = Expressions.equal((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualEq2 = SparkV2Filters.convert((Predicate)eq2);
            Assert.assertEquals((String)"EqualTo must match", (Object)expectedEq2.toString(), (Object)actualEq2.toString());
            Predicate eqNullSafe1 = new Predicate("<=>", attrAndValue);
            UnboundPredicate expectedEqNullSafe1 = Expressions.equal((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualEqNullSafe1 = SparkV2Filters.convert((Predicate)eqNullSafe1);
            Assert.assertEquals((String)"EqualNullSafe must match", (Object)expectedEqNullSafe1.toString(), (Object)actualEqNullSafe1.toString());
            Predicate eqNullSafe2 = new Predicate("<=>", valueAndAttr);
            UnboundPredicate expectedEqNullSafe2 = Expressions.equal((String)unquoted, (Object)1);
            org.apache.iceberg.expressions.Expression actualEqNullSafe2 = SparkV2Filters.convert((Predicate)eqNullSafe2);
            Assert.assertEquals((String)"EqualNullSafe must match", (Object)expectedEqNullSafe2.toString(), (Object)actualEqNullSafe2.toString());
            LiteralValue str = new LiteralValue((Object)UTF8String.fromString((String)"iceberg"), DataTypes.StringType);
            Expression[] attrAndStr = new Expression[]{namedReference, str};
            Predicate startsWith = new Predicate("STARTS_WITH", attrAndStr);
            UnboundPredicate expectedStartsWith = Expressions.startsWith((String)unquoted, (String)"iceberg");
            org.apache.iceberg.expressions.Expression actualStartsWith = SparkV2Filters.convert((Predicate)startsWith);
            Assert.assertEquals((String)"StartsWith must match", (Object)expectedStartsWith.toString(), (Object)actualStartsWith.toString());
            Predicate in = new Predicate("IN", attrAndValue);
            UnboundPredicate expectedIn = Expressions.in((String)unquoted, (Object[])new Integer[]{1});
            org.apache.iceberg.expressions.Expression actualIn = SparkV2Filters.convert((Predicate)in);
            Assert.assertEquals((String)"In must match", (Object)expectedIn.toString(), (Object)actualIn.toString());
            And and = new And(lt1, eq1);
            org.apache.iceberg.expressions.Expression expectedAnd = Expressions.and((org.apache.iceberg.expressions.Expression)expectedLt1, (org.apache.iceberg.expressions.Expression)expectedEq1);
            org.apache.iceberg.expressions.Expression actualAnd = SparkV2Filters.convert((Predicate)and);
            Assert.assertEquals((String)"And must match", (Object)expectedAnd.toString(), (Object)actualAnd.toString());
            Expression[] attrAndAttr = new Expression[]{namedReference, namedReference};
            Predicate invalid = new Predicate("<", attrAndAttr);
            And andWithInvalidLeft = new And(invalid, eq1);
            org.apache.iceberg.expressions.Expression convertedAnd = SparkV2Filters.convert((Predicate)andWithInvalidLeft);
            Assert.assertEquals((String)"And must match", (Object)convertedAnd, null);
            Or or = new Or(lt1, eq1);
            org.apache.iceberg.expressions.Expression expectedOr = Expressions.or((org.apache.iceberg.expressions.Expression)expectedLt1, (org.apache.iceberg.expressions.Expression)expectedEq1);
            org.apache.iceberg.expressions.Expression actualOr = SparkV2Filters.convert((Predicate)or);
            Assert.assertEquals((String)"Or must match", (Object)expectedOr.toString(), (Object)actualOr.toString());
            Or orWithInvalidLeft = new Or(invalid, eq1);
            org.apache.iceberg.expressions.Expression convertedOr = SparkV2Filters.convert((Predicate)orWithInvalidLeft);
            Assert.assertEquals((String)"Or must match", (Object)convertedOr, null);
            Not not = new Not(lt1);
            org.apache.iceberg.expressions.Expression expectedNot = Expressions.not((org.apache.iceberg.expressions.Expression)expectedLt1);
            org.apache.iceberg.expressions.Expression actualNot = SparkV2Filters.convert((Predicate)not);
            Assert.assertEquals((String)"Not must match", (Object)expectedNot.toString(), (Object)actualNot.toString());
        });
    }

    @Test
    public void testTimestampFilterConversion() {
        Instant instant = Instant.parse("2018-10-18T00:00:57.907Z");
        long epochMicros = ChronoUnit.MICROS.between(Instant.EPOCH, instant);
        NamedReference namedReference = FieldReference.apply((String)"x");
        LiteralValue ts = new LiteralValue((Object)epochMicros, DataTypes.TimestampType);
        Expression[] attrAndValue = new Expression[]{namedReference, ts};
        Predicate predicate = new Predicate(">", attrAndValue);
        org.apache.iceberg.expressions.Expression tsExpression = SparkV2Filters.convert((Predicate)predicate);
        UnboundPredicate rawExpression = Expressions.greaterThan((String)"x", (Object)epochMicros);
        Assert.assertEquals((String)"Generated Timestamp expression should be correct", (Object)rawExpression.toString(), (Object)tsExpression.toString());
    }

    @Test
    public void testDateFilterConversion() {
        LocalDate localDate = LocalDate.parse("2018-10-18");
        long epochDay = localDate.toEpochDay();
        NamedReference namedReference = FieldReference.apply((String)"x");
        LiteralValue ts = new LiteralValue((Object)epochDay, DataTypes.DateType);
        Expression[] attrAndValue = new Expression[]{namedReference, ts};
        Predicate predicate = new Predicate(">", attrAndValue);
        org.apache.iceberg.expressions.Expression dateExpression = SparkV2Filters.convert((Predicate)predicate);
        UnboundPredicate rawExpression = Expressions.greaterThan((String)"x", (Object)epochDay);
        Assert.assertEquals((String)"Generated date expression should be correct", (Object)rawExpression.toString(), (Object)dateExpression.toString());
    }

    @Test
    public void testNestedInInsideNot() {
        NamedReference namedReference1 = FieldReference.apply((String)"col1");
        LiteralValue v1 = new LiteralValue((Object)1, DataTypes.IntegerType);
        LiteralValue v2 = new LiteralValue((Object)2, DataTypes.IntegerType);
        Expression[] attrAndValue1 = new Expression[]{namedReference1, v1};
        Predicate equal = new Predicate("=", attrAndValue1);
        NamedReference namedReference2 = FieldReference.apply((String)"col2");
        Expression[] attrAndValue2 = new Expression[]{namedReference2, v1, v2};
        Predicate in = new Predicate("IN", attrAndValue2);
        Not filter = new Not((Predicate)new And(equal, in));
        org.apache.iceberg.expressions.Expression converted = SparkV2Filters.convert((Predicate)filter);
        Assert.assertNull((String)"Expression should not be converted", (Object)converted);
    }

    @Test
    public void testNotIn() {
        NamedReference namedReference = FieldReference.apply((String)"col");
        LiteralValue v1 = new LiteralValue((Object)1, DataTypes.IntegerType);
        LiteralValue v2 = new LiteralValue((Object)2, DataTypes.IntegerType);
        Expression[] attrAndValue = new Expression[]{namedReference, v1, v2};
        Predicate in = new Predicate("IN", attrAndValue);
        Not not = new Not(in);
        org.apache.iceberg.expressions.Expression actual = SparkV2Filters.convert((Predicate)not);
        org.apache.iceberg.expressions.Expression expected = Expressions.and((org.apache.iceberg.expressions.Expression)Expressions.notNull((String)"col"), (org.apache.iceberg.expressions.Expression)Expressions.notIn((String)"col", (Object[])new Integer[]{1, 2}));
        Assert.assertEquals((String)"Expressions should match", (Object)expected.toString(), (Object)actual.toString());
    }
}

