/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteJobOrder;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.actions.RewriteDataFiles;
import org.apache.iceberg.actions.RewriteDataFilesCommitManager;
import org.apache.iceberg.actions.RewriteFileGroup;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.spark.FileRewriteCoordinator;
import org.apache.iceberg.spark.ScanTaskSetManager;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.SparkTestBase;
import org.apache.iceberg.spark.actions.RewriteDataFilesSparkAction;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.source.ThreeColumnRecord;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestRewriteDataFilesAction
extends SparkTestBase {
    private static final int SCALE = 400000;
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private final FileRewriteCoordinator coordinator = FileRewriteCoordinator.get();
    private final ScanTaskSetManager manager = ScanTaskSetManager.get();
    private String tableLocation = null;

    @Before
    public void setupTableLocation() throws Exception {
        File tableDir = this.temp.newFolder();
        this.tableLocation = tableDir.toURI().toString();
    }

    private RewriteDataFilesSparkAction basicRewrite(Table table) {
        table.refresh();
        return (RewriteDataFilesSparkAction)this.actions().rewriteDataFiles(table).option("min-input-files", "1");
    }

    @Test
    public void testEmptyTable() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        HashMap options = Maps.newHashMap();
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        Assert.assertNull((String)"Table must be empty", (Object)table.currentSnapshot());
        this.basicRewrite(table).execute();
        Assert.assertNull((String)"Table must stay empty", (Object)table.currentSnapshot());
    }

    @Test
    public void testBinPackUnpartitionedTable() {
        Table table = this.createTable(4);
        this.shouldHaveFiles(table, 4);
        List<Object[]> expectedRecords = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = this.basicRewrite(table).execute();
        Assert.assertEquals((String)"Action should rewrite 4 data files", (long)4L, (long)result.rewrittenDataFilesCount());
        Assert.assertEquals((String)"Action should add 1 data file", (long)1L, (long)result.addedDataFilesCount());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 1);
        List<Object[]> actual = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actual);
    }

    @Test
    public void testBinPackPartitionedTable() {
        Table table = this.createTablePartitioned(4, 2);
        this.shouldHaveFiles(table, 8);
        List<Object[]> expectedRecords = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = this.basicRewrite(table).execute();
        Assert.assertEquals((String)"Action should rewrite 8 data files", (long)8L, (long)result.rewrittenDataFilesCount());
        Assert.assertEquals((String)"Action should add 4 data file", (long)4L, (long)result.addedDataFilesCount());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 4);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @Test
    public void testBinPackWithFilter() {
        Table table = this.createTablePartitioned(4, 2);
        this.shouldHaveFiles(table, 8);
        List<Object[]> expectedRecords = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = this.basicRewrite(table).filter((Expression)Expressions.equal((String)"c1", (Object)1)).filter((Expression)Expressions.startsWith((String)"c2", (String)"foo")).execute();
        Assert.assertEquals((String)"Action should rewrite 2 data files", (long)2L, (long)result.rewrittenDataFilesCount());
        Assert.assertEquals((String)"Action should add 1 data file", (long)1L, (long)result.addedDataFilesCount());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        this.shouldHaveFiles(table, 7);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @Test
    public void testBinPackAfterPartitionChange() {
        Table table = this.createTable();
        this.writeRecords(20, 400000, 20);
        this.shouldHaveFiles(table, 20);
        table.updateSpec().addField((Term)Expressions.ref((String)"c1")).commit();
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("min-input-files", "1")).option("min-file-size-bytes", Integer.toString(this.averageFileSize(table) + 1000))).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table) + 1001))).execute();
        Assert.assertEquals((String)"Should have 1 fileGroup because all files were not correctly partitioned", (long)1L, (long)result.rewriteResults().size());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveFiles(table, 20);
    }

    @Test
    public void testBinPackWithDeletes() throws Exception {
        int i;
        Table table = this.createTablePartitioned(4, 2);
        table.updateProperties().set("format-version", "2").commit();
        this.shouldHaveFiles(table, 8);
        table.refresh();
        List<DataFile> dataFiles = TestHelpers.dataFiles(table);
        int total = (int)dataFiles.stream().mapToLong(ContentFile::recordCount).sum();
        RowDelta rowDelta = table.newRowDelta();
        for (i = 0; i < 3; ++i) {
            this.writePosDeletesToFile(table, dataFiles.get(i), 1).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        }
        for (i = 3; i < 5; ++i) {
            this.writePosDeletesToFile(table, dataFiles.get(i), 2).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        }
        rowDelta.commit();
        table.refresh();
        List<Object[]> expectedRecords = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.actions().rewriteDataFiles(table).option("min-file-size-bytes", "0")).option("target-file-size-bytes", Long.toString(0x7FFFFFFFFFFFFFFEL))).option("max-file-size-bytes", Long.toString(Long.MAX_VALUE))).option("delete-file-threshold", "2")).execute();
        Assert.assertEquals((String)"Action should rewrite 2 data files", (long)2L, (long)result.rewrittenDataFilesCount());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
        Assert.assertEquals((String)"7 rows are removed", (long)(total - 7), (long)actualRecords.size());
    }

    @Test
    public void testBinPackWithDeleteAllData() {
        HashMap options = Maps.newHashMap();
        options.put("format-version", "2");
        Table table = this.createTablePartitioned(1, 1, 1, options);
        this.shouldHaveFiles(table, 1);
        table.refresh();
        List<DataFile> dataFiles = TestHelpers.dataFiles(table);
        int total = (int)dataFiles.stream().mapToLong(ContentFile::recordCount).sum();
        RowDelta rowDelta = table.newRowDelta();
        this.writePosDeletesToFile(table, dataFiles.get(0), total).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
        table.refresh();
        List<Object[]> expectedRecords = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)this.actions().rewriteDataFiles(table).option("delete-file-threshold", "1")).execute();
        Assert.assertEquals((String)"Action should rewrite 1 data files", (long)1L, (long)result.rewrittenDataFilesCount());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
        Assert.assertEquals((String)"Data manifest should not have existing data file", (long)0L, (long)((ManifestFile)table.currentSnapshot().dataManifests(table.io()).get(0)).existingFilesCount().intValue());
        Assert.assertEquals((String)"Data manifest should have 1 delete data file", (long)1L, (long)((ManifestFile)table.currentSnapshot().dataManifests(table.io()).get(0)).deletedFilesCount().intValue());
        Assert.assertEquals((String)"Delete manifest added row count should equal total count", (long)total, (long)((ManifestFile)table.currentSnapshot().deleteManifests(table.io()).get(0)).addedRowsCount());
    }

    @Test
    public void testBinPackWithStartingSequenceNumber() {
        Table table = this.createTablePartitioned(4, 2);
        this.shouldHaveFiles(table, 8);
        List<Object[]> expectedRecords = this.currentData();
        table.updateProperties().set("format-version", "2").commit();
        table.refresh();
        long oldSequenceNumber = table.currentSnapshot().sequenceNumber();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("use-starting-sequence-number", "true")).execute();
        Assert.assertEquals((String)"Action should rewrite 8 data files", (long)8L, (long)result.rewrittenDataFilesCount());
        Assert.assertEquals((String)"Action should add 4 data file", (long)4L, (long)result.addedDataFilesCount());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 4);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
        table.refresh();
        Assert.assertTrue((String)"Table sequence number should be incremented", (oldSequenceNumber < table.currentSnapshot().sequenceNumber() ? 1 : 0) != 0);
        Dataset rows = SparkTableUtil.loadMetadataTable((SparkSession)spark, (Table)table, (MetadataTableType)MetadataTableType.ENTRIES);
        for (Row row : rows.collectAsList()) {
            if (row.getInt(0) != 1) continue;
            Assert.assertEquals((String)"Expect old sequence number for added entries", (long)oldSequenceNumber, (long)row.getLong(2));
        }
    }

    @Test
    public void testBinPackWithStartingSequenceNumberV1Compatibility() {
        ImmutableMap properties = ImmutableMap.of((Object)"format-version", (Object)"1");
        Table table = this.createTablePartitioned(4, 2, 400000, (Map<String, String>)properties);
        this.shouldHaveFiles(table, 8);
        List<Object[]> expectedRecords = this.currentData();
        table.refresh();
        long oldSequenceNumber = table.currentSnapshot().sequenceNumber();
        Assert.assertEquals((String)"Table sequence number should be 0", (long)0L, (long)oldSequenceNumber);
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("use-starting-sequence-number", "true")).execute();
        Assert.assertEquals((String)"Action should rewrite 8 data files", (long)8L, (long)result.rewrittenDataFilesCount());
        Assert.assertEquals((String)"Action should add 4 data file", (long)4L, (long)result.addedDataFilesCount());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 4);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
        table.refresh();
        Assert.assertEquals((String)"Table sequence number should still be 0", (long)oldSequenceNumber, (long)table.currentSnapshot().sequenceNumber());
        Dataset rows = SparkTableUtil.loadMetadataTable((SparkSession)spark, (Table)table, (MetadataTableType)MetadataTableType.ENTRIES);
        for (Row row : rows.collectAsList()) {
            Assert.assertEquals((String)"Expect sequence number 0 for all entries", (long)oldSequenceNumber, (long)row.getLong(2));
        }
    }

    @Test
    public void testRewriteLargeTableHasResiduals() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).build();
        HashMap options = Maps.newHashMap();
        options.put("write.parquet.row-group-size-bytes", "100");
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records = Lists.newArrayList();
        for (int i = 0; i < 100; ++i) {
            records.add(new ThreeColumnRecord(i, String.valueOf(i), String.valueOf(i % 4)));
        }
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class);
        this.writeDF((Dataset<Row>)df);
        List<Object[]> expectedRecords = this.currentData();
        table.refresh();
        CloseableIterable tasks = ((TableScan)((TableScan)table.newScan().ignoreResiduals()).filter((Expression)Expressions.equal((String)"c3", (Object)"0"))).planFiles();
        for (FileScanTask task : tasks) {
            Assert.assertEquals((String)"Residuals must be ignored", (Object)Expressions.alwaysTrue(), (Object)task.residual());
        }
        this.shouldHaveFiles(table, 2);
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = this.basicRewrite(table).filter((Expression)Expressions.equal((String)"c3", (Object)"0")).execute();
        Assert.assertEquals((String)"Action should rewrite 2 data files", (long)2L, (long)result.rewrittenDataFilesCount());
        Assert.assertEquals((String)"Action should add 1 data file", (long)1L, (long)result.addedDataFilesCount());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @Test
    public void testBinPackSplitLargeFile() {
        Table table = this.createTable(1);
        this.shouldHaveFiles(table, 1);
        List<Object[]> expectedRecords = this.currentData();
        long targetSize = this.testDataSize(table) / 2L;
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("target-file-size-bytes", Long.toString(targetSize))).option("max-file-size-bytes", Long.toString(targetSize * 2L - 2000L))).execute();
        Assert.assertEquals((String)"Action should delete 1 data files", (long)1L, (long)result.rewrittenDataFilesCount());
        Assert.assertEquals((String)"Action should add 2 data files", (long)2L, (long)result.addedDataFilesCount());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 2);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @Test
    public void testBinPackCombineMixedFiles() {
        Table table = this.createTable(1);
        this.shouldHaveFiles(table, 1);
        this.writeRecords(1, 400000);
        this.writeRecords(1, 1200000);
        this.shouldHaveFiles(table, 3);
        List<Object[]> expectedRecords = this.currentData();
        int targetSize = this.averageFileSize(table);
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("target-file-size-bytes", Integer.toString(targetSize + 1000))).option("max-file-size-bytes", Integer.toString(targetSize + 80000))).option("min-file-size-bytes", Integer.toString(targetSize - 1000))).execute();
        Assert.assertEquals((String)"Action should delete 3 data files", (long)3L, (long)result.rewrittenDataFilesCount());
        Assert.assertEquals((String)"Action should add 3 data files", (long)3L, (long)result.addedDataFilesCount());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 3);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @Test
    public void testBinPackCombineMediumFiles() {
        Table table = this.createTable(4);
        this.shouldHaveFiles(table, 4);
        List<Object[]> expectedRecords = this.currentData();
        int targetSize = (int)this.testDataSize(table) / 3;
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("target-file-size-bytes", Integer.toString(targetSize))).option("max-file-size-bytes", Integer.toString((int)((double)targetSize * 1.8)))).option("min-file-size-bytes", Integer.toString(targetSize - 100))).execute();
        Assert.assertEquals((String)"Action should delete 4 data files", (long)4L, (long)result.rewrittenDataFilesCount());
        Assert.assertEquals((String)"Action should add 3 data files", (long)3L, (long)result.addedDataFilesCount());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 3);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @Test
    public void testPartialProgressEnabled() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        table.updateProperties().set("commit.retry.num-retries", "10").commit();
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("partial-progress.enabled", "true")).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("partial-progress.max-commits", "10")).execute();
        Assert.assertEquals((String)"Should have 10 fileGroups", (long)result.rewriteResults().size(), (long)10L);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        this.shouldHaveSnapshots(table, 11);
        this.shouldHaveACleanCache(table);
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
    }

    @Test
    public void testMultipleGroups() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("min-input-files", "1")).execute();
        Assert.assertEquals((String)"Should have 10 fileGroups", (long)result.rewriteResults().size(), (long)10L);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
    }

    @Test
    public void testPartialProgressMaxCommits() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("partial-progress.enabled", "true")).option("partial-progress.max-commits", "3")).execute();
        Assert.assertEquals((String)"Should have 10 fileGroups", (long)result.rewriteResults().size(), (long)10L);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 4);
        this.shouldHaveACleanCache(table);
    }

    @Test
    public void testSingleCommitWithRewriteFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000));
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        GroupInfoMatcher failGroup = new GroupInfoMatcher(1, 3, 7);
        ((RewriteDataFilesSparkAction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Rewrite Failed")}).when((Object)spyRewrite)).rewriteFiles((RewriteDataFilesSparkAction.RewriteExecutionContext)ArgumentMatchers.any(), (RewriteFileGroup)ArgumentMatchers.argThat((ArgumentMatcher)failGroup));
        AssertHelpers.assertThrows((String)"Should fail entire rewrite if part fails", RuntimeException.class, () -> spyRewrite.execute());
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 1);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @Test
    public void testSingleCommitWithCommitFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000));
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        RewriteDataFilesCommitManager util = (RewriteDataFilesCommitManager)Mockito.spy((Object)new RewriteDataFilesCommitManager(table));
        ((RewriteDataFilesCommitManager)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Commit Failure")}).when((Object)util)).commitFileGroups((Set)ArgumentMatchers.any());
        ((RewriteDataFilesSparkAction)Mockito.doReturn((Object)util).when((Object)spyRewrite)).commitManager(table.currentSnapshot().snapshotId());
        AssertHelpers.assertThrows((String)"Should fail entire rewrite if commit fails", RuntimeException.class, () -> spyRewrite.execute());
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 1);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @Test
    public void testParallelSingleCommitWithRewriteFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("max-concurrent-file-group-rewrites", "3");
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        GroupInfoMatcher failGroup = new GroupInfoMatcher(1, 3, 7);
        ((RewriteDataFilesSparkAction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Rewrite Failed")}).when((Object)spyRewrite)).rewriteFiles((RewriteDataFilesSparkAction.RewriteExecutionContext)ArgumentMatchers.any(), (RewriteFileGroup)ArgumentMatchers.argThat((ArgumentMatcher)failGroup));
        AssertHelpers.assertThrows((String)"Should fail entire rewrite if part fails", RuntimeException.class, () -> spyRewrite.execute());
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 1);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @Test
    public void testPartialProgressWithRewriteFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("partial-progress.enabled", "true")).option("partial-progress.max-commits", "3");
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        GroupInfoMatcher failGroup = new GroupInfoMatcher(1, 3, 7);
        ((RewriteDataFilesSparkAction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Rewrite Failed")}).when((Object)spyRewrite)).rewriteFiles((RewriteDataFilesSparkAction.RewriteExecutionContext)ArgumentMatchers.any(), (RewriteFileGroup)ArgumentMatchers.argThat((ArgumentMatcher)failGroup));
        RewriteDataFiles.Result result = spyRewrite.execute();
        Assert.assertEquals((String)"Should have 7 fileGroups", (long)result.rewriteResults().size(), (long)7L);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 3);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @Test
    public void testParallelPartialProgressWithRewriteFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("max-concurrent-file-group-rewrites", "3")).option("partial-progress.enabled", "true")).option("partial-progress.max-commits", "3");
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        GroupInfoMatcher failGroup = new GroupInfoMatcher(1, 3, 7);
        ((RewriteDataFilesSparkAction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Rewrite Failed")}).when((Object)spyRewrite)).rewriteFiles((RewriteDataFilesSparkAction.RewriteExecutionContext)ArgumentMatchers.any(), (RewriteFileGroup)ArgumentMatchers.argThat((ArgumentMatcher)failGroup));
        RewriteDataFiles.Result result = spyRewrite.execute();
        Assert.assertEquals((String)"Should have 7 fileGroups", (long)result.rewriteResults().size(), (long)7L);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 3);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @Test
    public void testParallelPartialProgressWithCommitFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("max-concurrent-file-group-rewrites", "3")).option("partial-progress.enabled", "true")).option("partial-progress.max-commits", "3");
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        RewriteDataFilesCommitManager util = (RewriteDataFilesCommitManager)Mockito.spy((Object)new RewriteDataFilesCommitManager(table));
        ((RewriteDataFilesCommitManager)Mockito.doCallRealMethod().doThrow(new Throwable[]{new RuntimeException("Commit Failed")}).doCallRealMethod().when((Object)util)).commitFileGroups((Set)ArgumentMatchers.any());
        ((RewriteDataFilesSparkAction)Mockito.doReturn((Object)util).when((Object)spyRewrite)).commitManager(table.currentSnapshot().snapshotId());
        RewriteDataFiles.Result result = spyRewrite.execute();
        Assert.assertEquals((String)"Should have 6 fileGroups", (long)6L, (long)result.rewriteResults().size());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 3);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @Test
    public void testInvalidOptions() {
        Table table = this.createTable(20);
        AssertHelpers.assertThrows((String)"No negative values for partial progress max commits", IllegalArgumentException.class, () -> ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("partial-progress.enabled", "true")).option("partial-progress.max-commits", "-5")).execute());
        AssertHelpers.assertThrows((String)"No negative values for max concurrent groups", IllegalArgumentException.class, () -> ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-concurrent-file-group-rewrites", "-5")).execute());
        AssertHelpers.assertThrows((String)"No unknown options allowed", IllegalArgumentException.class, () -> ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("foobarity", "-5")).execute());
        AssertHelpers.assertThrows((String)"Cannot set rewrite-job-order to foo", IllegalArgumentException.class, () -> ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("rewrite-job-order", "foo")).execute());
    }

    @Test
    public void testSortMultipleGroups() {
        Table table = this.createTable(20);
        this.shouldHaveFiles(table, 20);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("c2")).commit();
        this.shouldHaveLastCommitUnsorted(table, "c2");
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort().option("rewrite-all", "true")).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).execute();
        Assert.assertEquals((String)"Should have 10 fileGroups", (long)result.rewriteResults().size(), (long)10L);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
    }

    @Test
    public void testSimpleSort() {
        Table table = this.createTable(20);
        this.shouldHaveFiles(table, 20);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("c2")).commit();
        this.shouldHaveLastCommitUnsorted(table, "c2");
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort().option("min-input-files", "1")).option("rewrite-all", "true")).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table)))).execute();
        Assert.assertEquals((String)"Should have 1 fileGroups", (long)result.rewriteResults().size(), (long)1L);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveMultipleFiles(table);
        this.shouldHaveLastCommitSorted(table, "c2");
    }

    @Test
    public void testSortAfterPartitionChange() {
        Table table = this.createTable(20);
        this.shouldHaveFiles(table, 20);
        table.updateSpec().addField((Term)Expressions.bucket((String)"c1", (int)4)).commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("c2")).commit();
        this.shouldHaveLastCommitUnsorted(table, "c2");
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort().option("min-input-files", "1")).option("rewrite-all", "true")).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table)))).execute();
        Assert.assertEquals((String)"Should have 1 fileGroup because all files were not correctly partitioned", (long)result.rewriteResults().size(), (long)1L);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveMultipleFiles(table);
        this.shouldHaveLastCommitSorted(table, "c2");
    }

    @Test
    public void testSortCustomSortOrder() {
        Table table = this.createTable(20);
        this.shouldHaveLastCommitUnsorted(table, "c2");
        this.shouldHaveFiles(table, 20);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort(((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).asc("c2")).build()).option("rewrite-all", "true")).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table)))).execute();
        Assert.assertEquals((String)"Should have 1 fileGroups", (long)result.rewriteResults().size(), (long)1L);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveMultipleFiles(table);
        this.shouldHaveLastCommitSorted(table, "c2");
    }

    @Test
    public void testSortCustomSortOrderRequiresRepartition() {
        int partitions = 4;
        Table table = this.createTable();
        this.writeRecords(20, 400000, partitions);
        this.shouldHaveLastCommitUnsorted(table, "c3");
        table.updateSpec().addField("c1").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("c2")).apply();
        this.shouldHaveFiles(table, 20);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort(((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).asc("c3")).build()).option("rewrite-all", "true")).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table) / partitions))).execute();
        Assert.assertEquals((String)"Should have 1 fileGroups", (long)result.rewriteResults().size(), (long)1L);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveMultipleFiles(table);
        this.shouldHaveLastCommitUnsorted(table, "c2");
        this.shouldHaveLastCommitSorted(table, "c3");
    }

    @Test
    public void testAutoSortShuffleOutput() {
        Table table = this.createTable(20);
        this.shouldHaveLastCommitUnsorted(table, "c2");
        this.shouldHaveFiles(table, 20);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort(((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).asc("c2")).build()).option("max-file-size-bytes", Integer.toString(this.averageFileSize(table) / 2 + 2))).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table) / 2))).option("min-input-files", "1")).execute();
        Assert.assertEquals((String)"Should have 1 fileGroups", (long)result.rewriteResults().size(), (long)1L);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        Assert.assertTrue((String)"Should have written 40+ files", (Iterables.size((Iterable)table.currentSnapshot().addedDataFiles(table.io())) >= 40 ? 1 : 0) != 0);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveMultipleFiles(table);
        this.shouldHaveLastCommitSorted(table, "c2");
    }

    @Test
    public void testCommitStateUnknownException() {
        Table table = this.createTable(20);
        this.shouldHaveFiles(table, 20);
        List<Object[]> originalData = this.currentData();
        RewriteDataFilesSparkAction action = this.basicRewrite(table);
        RewriteDataFilesSparkAction spyAction = (RewriteDataFilesSparkAction)Mockito.spy((Object)action);
        RewriteDataFilesCommitManager util = (RewriteDataFilesCommitManager)Mockito.spy((Object)new RewriteDataFilesCommitManager(table));
        ((RewriteDataFilesCommitManager)Mockito.doAnswer(invocationOnMock -> {
            invocationOnMock.callRealMethod();
            throw new CommitStateUnknownException((Throwable)new RuntimeException("Unknown State"));
        }).when((Object)util)).commitFileGroups((Set)ArgumentMatchers.any());
        ((RewriteDataFilesSparkAction)Mockito.doReturn((Object)util).when((Object)spyAction)).commitManager(table.currentSnapshot().snapshotId());
        AssertHelpers.assertThrows((String)"Should propagate CommitStateUnknown Exception", CommitStateUnknownException.class, () -> spyAction.execute());
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
    }

    @Test
    public void testZOrderSort() {
        int originalFiles = 20;
        Table table = this.createTable(originalFiles);
        this.shouldHaveLastCommitUnsorted(table, "c2");
        this.shouldHaveFiles(table, originalFiles);
        List<Object[]> originalData = this.currentData();
        double originalFilesC2 = this.percentFilesRequired(table, "c2", "foo23");
        double originalFilesC3 = this.percentFilesRequired(table, "c3", "bar21");
        double originalFilesC2C3 = this.percentFilesRequired(table, new String[]{"c2", "c3"}, new String[]{"foo23", "bar23"});
        Assert.assertTrue((String)"Should require all files to scan c2", (originalFilesC2 > 0.99 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should require all files to scan c3", (originalFilesC3 > 0.99 ? 1 : 0) != 0);
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).zOrder(new String[]{"c2", "c3"}).option("max-file-size-bytes", Integer.toString(this.averageFileSize(table) / 2 + 2))).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table) / 2))).option("min-input-files", "1")).execute();
        Assert.assertEquals((String)"Should have 1 fileGroups", (long)1L, (long)result.rewriteResults().size());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        int zOrderedFilesTotal = Iterables.size((Iterable)table.currentSnapshot().addedDataFiles(table.io()));
        Assert.assertTrue((String)"Should have written 40+ files", (zOrderedFilesTotal >= 40 ? 1 : 0) != 0);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        double filesScannedC2 = this.percentFilesRequired(table, "c2", "foo23");
        double filesScannedC3 = this.percentFilesRequired(table, "c3", "bar21");
        double filesScannedC2C3 = this.percentFilesRequired(table, new String[]{"c2", "c3"}, new String[]{"foo23", "bar23"});
        Assert.assertTrue((String)"Should have reduced the number of files required for c2", (filesScannedC2 < originalFilesC2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have reduced the number of files required for c3", (filesScannedC3 < originalFilesC3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have reduced the number of files required for a c2,c3 predicate", (filesScannedC2C3 < originalFilesC2C3 ? 1 : 0) != 0);
    }

    @Test
    public void testZOrderAllTypesSort() {
        Table table = this.createTypeTestTable();
        this.shouldHaveFiles(table, 10);
        List originalRaw = spark.read().format("iceberg").load(this.tableLocation).sort("longCol", new String[0]).collectAsList();
        List<Object[]> originalData = this.rowsToJava(originalRaw);
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).zOrder(new String[]{"longCol", "intCol", "floatCol", "doubleCol", "dateCol", "timestampCol", "stringCol", "binaryCol", "booleanCol"}).option("min-input-files", "1")).option("rewrite-all", "true")).execute();
        Assert.assertEquals((String)"Should have 1 fileGroups", (long)1L, (long)result.rewriteResults().size());
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        int zOrderedFilesTotal = Iterables.size((Iterable)table.currentSnapshot().addedDataFiles(table.io()));
        Assert.assertEquals((String)"Should have written 1 file", (long)1L, (long)zOrderedFilesTotal);
        table.refresh();
        List postRaw = spark.read().format("iceberg").load(this.tableLocation).sort("longCol", new String[0]).collectAsList();
        List<Object[]> postRewriteData = this.rowsToJava(postRaw);
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
    }

    @Test
    public void testInvalidAPIUsage() {
        Table table = this.createTable(1);
        SortOrder sortOrder = ((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).asc("c2")).build();
        AssertHelpers.assertThrows((String)"Should be unable to set Strategy more than once", IllegalArgumentException.class, (String)"Must use only one rewriter type", () -> this.actions().rewriteDataFiles(table).binPack().sort());
        AssertHelpers.assertThrows((String)"Should be unable to set Strategy more than once", IllegalArgumentException.class, (String)"Must use only one rewriter type", () -> this.actions().rewriteDataFiles(table).sort(sortOrder).binPack());
        AssertHelpers.assertThrows((String)"Should be unable to set Strategy more than once", IllegalArgumentException.class, (String)"Must use only one rewriter type", () -> this.actions().rewriteDataFiles(table).sort(sortOrder).binPack());
    }

    @Test
    public void testRewriteJobOrderBytesAsc() {
        Table table = this.createTablePartitioned(4, 2);
        this.writeRecords(1, 400000, 1);
        this.writeRecords(2, 400000, 2);
        this.writeRecords(3, 400000, 3);
        this.writeRecords(4, 400000, 4);
        table.updateProperties().set("format-version", "2").commit();
        RewriteDataFilesSparkAction basicRewrite = this.basicRewrite(table).binPack();
        List expected = this.toGroupStream(table, basicRewrite).mapToLong(RewriteFileGroup::sizeInBytes).boxed().collect(Collectors.toList());
        RewriteDataFilesSparkAction jobOrderRewrite = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("rewrite-job-order", RewriteJobOrder.BYTES_ASC.orderName())).binPack();
        List actual = this.toGroupStream(table, jobOrderRewrite).mapToLong(RewriteFileGroup::sizeInBytes).boxed().collect(Collectors.toList());
        expected.sort(Comparator.naturalOrder());
        Assert.assertEquals((String)"Size in bytes order should be ascending", actual, expected);
        Collections.reverse(expected);
        Assert.assertNotEquals((String)"Size in bytes order should not be descending", actual, expected);
    }

    @Test
    public void testRewriteJobOrderBytesDesc() {
        Table table = this.createTablePartitioned(4, 2);
        this.writeRecords(1, 400000, 1);
        this.writeRecords(2, 400000, 2);
        this.writeRecords(3, 400000, 3);
        this.writeRecords(4, 400000, 4);
        table.updateProperties().set("format-version", "2").commit();
        RewriteDataFilesSparkAction basicRewrite = this.basicRewrite(table).binPack();
        List expected = this.toGroupStream(table, basicRewrite).mapToLong(RewriteFileGroup::sizeInBytes).boxed().collect(Collectors.toList());
        RewriteDataFilesSparkAction jobOrderRewrite = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("rewrite-job-order", RewriteJobOrder.BYTES_DESC.orderName())).binPack();
        List actual = this.toGroupStream(table, jobOrderRewrite).mapToLong(RewriteFileGroup::sizeInBytes).boxed().collect(Collectors.toList());
        expected.sort(Comparator.reverseOrder());
        Assert.assertEquals((String)"Size in bytes order should be descending", actual, expected);
        Collections.reverse(expected);
        Assert.assertNotEquals((String)"Size in bytes order should not be ascending", actual, expected);
    }

    @Test
    public void testRewriteJobOrderFilesAsc() {
        Table table = this.createTablePartitioned(4, 2);
        this.writeRecords(1, 400000, 1);
        this.writeRecords(2, 400000, 2);
        this.writeRecords(3, 400000, 3);
        this.writeRecords(4, 400000, 4);
        table.updateProperties().set("format-version", "2").commit();
        RewriteDataFilesSparkAction basicRewrite = this.basicRewrite(table).binPack();
        List expected = this.toGroupStream(table, basicRewrite).mapToLong(RewriteFileGroup::numFiles).boxed().collect(Collectors.toList());
        RewriteDataFilesSparkAction jobOrderRewrite = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("rewrite-job-order", RewriteJobOrder.FILES_ASC.orderName())).binPack();
        List actual = this.toGroupStream(table, jobOrderRewrite).mapToLong(RewriteFileGroup::numFiles).boxed().collect(Collectors.toList());
        expected.sort(Comparator.naturalOrder());
        Assert.assertEquals((String)"Number of files order should be ascending", actual, expected);
        Collections.reverse(expected);
        Assert.assertNotEquals((String)"Number of files order should not be descending", actual, expected);
    }

    @Test
    public void testRewriteJobOrderFilesDesc() {
        Table table = this.createTablePartitioned(4, 2);
        this.writeRecords(1, 400000, 1);
        this.writeRecords(2, 400000, 2);
        this.writeRecords(3, 400000, 3);
        this.writeRecords(4, 400000, 4);
        table.updateProperties().set("format-version", "2").commit();
        RewriteDataFilesSparkAction basicRewrite = this.basicRewrite(table).binPack();
        List expected = this.toGroupStream(table, basicRewrite).mapToLong(RewriteFileGroup::numFiles).boxed().collect(Collectors.toList());
        RewriteDataFilesSparkAction jobOrderRewrite = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("rewrite-job-order", RewriteJobOrder.FILES_DESC.orderName())).binPack();
        List actual = this.toGroupStream(table, jobOrderRewrite).mapToLong(RewriteFileGroup::numFiles).boxed().collect(Collectors.toList());
        expected.sort(Comparator.reverseOrder());
        Assert.assertEquals((String)"Number of files order should be descending", actual, expected);
        Collections.reverse(expected);
        Assert.assertNotEquals((String)"Number of files order should not be ascending", actual, expected);
    }

    private Stream<RewriteFileGroup> toGroupStream(Table table, RewriteDataFilesSparkAction rewrite) {
        rewrite.validateAndInitOptions();
        StructLikeMap fileGroupsByPartition = rewrite.planFileGroups(table.currentSnapshot().snapshotId());
        return rewrite.toGroupStream(new RewriteDataFilesSparkAction.RewriteExecutionContext(fileGroupsByPartition), (Map)fileGroupsByPartition);
    }

    protected List<Object[]> currentData() {
        return this.rowsToJava(spark.read().format("iceberg").load(this.tableLocation).sort("c1", new String[]{"c2", "c3"}).collectAsList());
    }

    protected long testDataSize(Table table) {
        return Streams.stream((Iterable)table.newScan().planFiles()).mapToLong(ContentScanTask::length).sum();
    }

    protected void shouldHaveMultipleFiles(Table table) {
        table.refresh();
        int numFiles = Iterables.size((Iterable)table.newScan().planFiles());
        Assert.assertTrue((String)String.format("Should have multiple files, had %d", numFiles), (numFiles > 1 ? 1 : 0) != 0);
    }

    protected void shouldHaveFiles(Table table, int numExpected) {
        table.refresh();
        int numFiles = Iterables.size((Iterable)table.newScan().planFiles());
        Assert.assertEquals((String)"Did not have the expected number of files", (long)numExpected, (long)numFiles);
    }

    protected void shouldHaveSnapshots(Table table, int expectedSnapshots) {
        table.refresh();
        int actualSnapshots = Iterables.size((Iterable)table.snapshots());
        Assert.assertEquals((String)"Table did not have the expected number of snapshots", (long)expectedSnapshots, (long)actualSnapshots);
    }

    protected void shouldHaveNoOrphans(Table table) {
        Assert.assertEquals((String)"Should not have found any orphan files", (Object)ImmutableList.of(), (Object)this.actions().deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute().orphanFileLocations());
    }

    protected void shouldHaveACleanCache(Table table) {
        Assert.assertEquals((String)"Should not have any entries in cache", (Object)ImmutableSet.of(), this.cacheContents(table));
    }

    protected <T> void shouldHaveLastCommitSorted(Table table, String column) {
        List<Pair<Pair<T, T>, Pair<T, T>>> overlappingFiles = this.checkForOverlappingFiles(table, column);
        Assert.assertEquals((String)"Found overlapping files", Collections.emptyList(), overlappingFiles);
    }

    protected <T> void shouldHaveLastCommitUnsorted(Table table, String column) {
        List<Pair<Pair<T, T>, Pair<T, T>>> overlappingFiles = this.checkForOverlappingFiles(table, column);
        Assert.assertNotEquals((String)"Found no overlapping files", Collections.emptyList(), overlappingFiles);
    }

    private <T> Pair<T, T> boundsOf(DataFile file, Types.NestedField field, Class<T> javaClass) {
        int columnId = field.fieldId();
        return Pair.of(javaClass.cast(Conversions.fromByteBuffer((Type)field.type(), (ByteBuffer)((ByteBuffer)file.lowerBounds().get(columnId)))), javaClass.cast(Conversions.fromByteBuffer((Type)field.type(), (ByteBuffer)((ByteBuffer)file.upperBounds().get(columnId)))));
    }

    private <T> List<Pair<Pair<T, T>, Pair<T, T>>> checkForOverlappingFiles(Table table, String column) {
        table.refresh();
        Types.NestedField field = table.schema().caseInsensitiveFindField(column);
        Class javaClass = field.type().typeId().javaClass();
        Snapshot snapshot = table.currentSnapshot();
        Map<StructLike, List<DataFile>> filesByPartition = Streams.stream((Iterable)snapshot.addedDataFiles(table.io())).collect(Collectors.groupingBy(ContentFile::partition));
        Stream overlaps = filesByPartition.entrySet().stream().flatMap(entry -> {
            List datafiles = (List)entry.getValue();
            Preconditions.checkArgument((datafiles.size() > 1 ? 1 : 0) != 0, (String)"This test is checking for overlaps in a situation where no overlaps can actually occur because the partition %s does not contain multiple datafiles", entry.getKey());
            List boundComparisons = Lists.cartesianProduct((List[])new List[]{datafiles, datafiles}).stream().filter(tuple -> tuple.get(0) != tuple.get(1)).map(tuple -> Pair.of(this.boundsOf((DataFile)tuple.get(0), field, javaClass), this.boundsOf((DataFile)tuple.get(1), field, javaClass))).collect(Collectors.toList());
            Comparator comparator = Comparators.forType((Type.PrimitiveType)field.type().asPrimitiveType());
            List overlappingFiles = boundComparisons.stream().filter(filePair -> {
                Pair left = (Pair)filePair.first();
                Object lMin = left.first();
                Object lMax = left.second();
                Pair right = (Pair)filePair.second();
                Object rMin = right.first();
                Object rMax = right.second();
                boolean boundsDoNotOverlap = comparator.compare(rMax, lMax) >= 0 && comparator.compare(rMin, lMax) >= 0 || comparator.compare(lMax, rMax) >= 0 && comparator.compare(lMin, rMax) >= 0;
                return !boundsDoNotOverlap;
            }).collect(Collectors.toList());
            return overlappingFiles.stream();
        });
        return overlaps.collect(Collectors.toList());
    }

    protected Table createTable() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        HashMap options = Maps.newHashMap();
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        table.updateProperties().set("write.parquet.row-group-size-bytes", Integer.toString(20480)).commit();
        Assert.assertNull((String)"Table must be empty", (Object)table.currentSnapshot());
        return table;
    }

    protected Table createTable(int files) {
        Table table = this.createTable();
        this.writeRecords(files, 400000);
        return table;
    }

    protected Table createTablePartitioned(int partitions, int files, int numRecords, Map<String, String> options) {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").truncate("c2", 2).build();
        Table table = TABLES.create(SCHEMA, spec, options, this.tableLocation);
        Assert.assertNull((String)"Table must be empty", (Object)table.currentSnapshot());
        this.writeRecords(files, numRecords, partitions);
        return table;
    }

    protected Table createTablePartitioned(int partitions, int files) {
        return this.createTablePartitioned(partitions, files, 400000, Maps.newHashMap());
    }

    private Table createTypeTestTable() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"longCol", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"intCol", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"floatCol", (Type)Types.FloatType.get()), Types.NestedField.optional((int)4, (String)"doubleCol", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)5, (String)"dateCol", (Type)Types.DateType.get()), Types.NestedField.optional((int)6, (String)"timestampCol", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)7, (String)"stringCol", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"booleanCol", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"binaryCol", (Type)Types.BinaryType.get())});
        HashMap options = Maps.newHashMap();
        Table table = TABLES.create(schema, PartitionSpec.unpartitioned(), (Map)options, this.tableLocation);
        spark.range(0L, 10L, 1L, 10).withColumnRenamed("id", "longCol").withColumn("intCol", functions.expr((String)"CAST(longCol AS INT)")).withColumn("floatCol", functions.expr((String)"CAST(longCol AS FLOAT)")).withColumn("doubleCol", functions.expr((String)"CAST(longCol AS DOUBLE)")).withColumn("dateCol", functions.date_add((Column)functions.current_date(), (int)1)).withColumn("timestampCol", functions.expr((String)"TO_TIMESTAMP(dateCol)")).withColumn("stringCol", functions.expr((String)"CAST(dateCol AS STRING)")).withColumn("booleanCol", functions.expr((String)"longCol > 5")).withColumn("binaryCol", functions.expr((String)"CAST(longCol AS BINARY)")).write().format("iceberg").mode("append").save(this.tableLocation);
        return table;
    }

    protected int averageFileSize(Table table) {
        table.refresh();
        return (int)Streams.stream((Iterable)table.newScan().planFiles()).mapToLong(ContentScanTask::length).average().getAsDouble();
    }

    private void writeRecords(int files, int numRecords) {
        this.writeRecords(files, numRecords, 0);
    }

    private void writeRecords(int files, int numRecords, int partitions) {
        ArrayList records = Lists.newArrayList();
        int rowDimension = (int)Math.ceil(Math.sqrt(numRecords));
        List<Pair> data = IntStream.range(0, rowDimension).boxed().flatMap(x -> IntStream.range(0, rowDimension).boxed().map(y -> Pair.of((Object)x, (Object)y))).collect(Collectors.toList());
        Collections.shuffle(data, new Random(42L));
        if (partitions > 0) {
            data.forEach(i -> records.add(new ThreeColumnRecord((Integer)i.first() % partitions, "foo" + i.first(), "bar" + i.second())));
        } else {
            data.forEach(i -> records.add(new ThreeColumnRecord((Integer)i.first(), "foo" + i.first(), "bar" + i.second())));
        }
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).repartition(files);
        this.writeDF((Dataset<Row>)df);
    }

    private void writeDF(Dataset<Row> df) {
        df.select("c1", new String[]{"c2", "c3"}).sortWithinPartitions("c1", new String[]{"c2"}).write().format("iceberg").mode("append").save(this.tableLocation);
    }

    private List<DeleteFile> writePosDeletesToFile(Table table, DataFile dataFile, int outputDeleteFiles) {
        return this.writePosDeletes(table, dataFile.partition(), dataFile.path().toString(), outputDeleteFiles);
    }

    private List<DeleteFile> writePosDeletes(Table table, StructLike partition, String path, int outputDeleteFiles) {
        ArrayList results = Lists.newArrayList();
        int rowPosition = 0;
        for (int file = 0; file < outputDeleteFiles; ++file) {
            OutputFile outputFile = table.io().newOutputFile(table.locationProvider().newDataLocation(UUID.randomUUID().toString()));
            EncryptedOutputFile encryptedOutputFile = EncryptedFiles.encryptedOutput((OutputFile)outputFile, (EncryptionKeyMetadata)EncryptionKeyMetadata.EMPTY);
            GenericAppenderFactory appenderFactory = new GenericAppenderFactory(table.schema(), table.spec(), null, null, null);
            PositionDeleteWriter posDeleteWriter = appenderFactory.set("write.metadata.metrics.default", "full").newPosDeleteWriter(encryptedOutputFile, FileFormat.PARQUET, partition);
            PositionDelete posDelete = PositionDelete.create();
            posDeleteWriter.write(posDelete.set((CharSequence)path, (long)rowPosition, null));
            try {
                posDeleteWriter.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            results.add(posDeleteWriter.toDeleteFile());
            ++rowPosition;
        }
        return results;
    }

    private SparkActions actions() {
        return SparkActions.get();
    }

    private Set<String> cacheContents(Table table) {
        return ImmutableSet.builder().addAll((Iterable)this.manager.fetchSetIds(table)).addAll((Iterable)this.coordinator.fetchSetIds(table)).build();
    }

    private double percentFilesRequired(Table table, String col, String value) {
        return this.percentFilesRequired(table, new String[]{col}, new String[]{value});
    }

    private double percentFilesRequired(Table table, String[] cols, String[] values) {
        Preconditions.checkArgument((cols.length == values.length ? 1 : 0) != 0);
        True restriction = Expressions.alwaysTrue();
        for (int i = 0; i < cols.length; ++i) {
            restriction = Expressions.and((Expression)restriction, (Expression)Expressions.equal((String)cols[i], (Object)values[i]));
        }
        int totalFiles = Iterables.size((Iterable)table.newScan().planFiles());
        int filteredFiles = Iterables.size((Iterable)((TableScan)table.newScan().filter((Expression)restriction)).planFiles());
        return (double)filteredFiles / (double)totalFiles;
    }

    class GroupInfoMatcher
    implements ArgumentMatcher<RewriteFileGroup> {
        private final Set<Integer> groupIDs;

        GroupInfoMatcher(Integer ... globalIndex) {
            this.groupIDs = ImmutableSet.copyOf((Object[])globalIndex);
        }

        public boolean matches(RewriteFileGroup argument) {
            return this.groupIDs.contains(argument.info().globalIndex());
        }
    }
}

