/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.ValidationHelpers;
import org.apache.iceberg.actions.RewriteManifests;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.SparkTestBase;
import org.apache.iceberg.spark.actions.RewriteManifestsSparkAction;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.source.ThreeColumnRecord;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestRewriteManifestsAction
extends SparkTestBase {
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private final String snapshotIdInheritanceEnabled;
    private final String useCaching;
    private final int formatVersion;
    private final boolean shouldStageManifests;
    private String tableLocation = null;

    @Parameterized.Parameters(name="snapshotIdInheritanceEnabled = {0}, useCaching = {1}, formatVersion = {2}")
    public static Object[] parameters() {
        return new Object[][]{{"true", "true", 1}, {"false", "true", 1}, {"true", "false", 2}, {"false", "false", 2}};
    }

    public TestRewriteManifestsAction(String snapshotIdInheritanceEnabled, String useCaching, int formatVersion) {
        this.snapshotIdInheritanceEnabled = snapshotIdInheritanceEnabled;
        this.useCaching = useCaching;
        this.formatVersion = formatVersion;
        this.shouldStageManifests = formatVersion == 1 && snapshotIdInheritanceEnabled.equals("false");
    }

    @Before
    public void setupTableLocation() throws Exception {
        File tableDir = this.temp.newFolder();
        this.tableLocation = tableDir.toURI().toString();
    }

    @Test
    public void testRewriteManifestsEmptyTable() throws IOException {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        Assert.assertNull((String)"Table must be empty", (Object)table.currentSnapshot());
        SparkActions actions = SparkActions.get();
        ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).stagingLocation(this.temp.newFolder().toString()).execute();
        Assert.assertNull((String)"Table must stay empty", (Object)table.currentSnapshot());
    }

    @Test
    public void testRewriteSmallManifestsNonPartitionedTable() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        this.writeRecords(records1);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(2, "DDDDDDDDDD", "DDDD")});
        this.writeRecords(records2);
        table.refresh();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests before rewrite", (long)2L, (long)manifests.size());
        SparkActions actions = SparkActions.get();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).execute();
        Assert.assertEquals((String)"Action should rewrite 2 manifests", (long)2L, (long)Iterables.size((Iterable)result.rewrittenManifests()));
        Assert.assertEquals((String)"Action should add 1 manifests", (long)1L, (long)Iterables.size((Iterable)result.addedManifests()));
        this.assertManifestsLocation(result.addedManifests());
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 1 manifests after rewrite", (long)1L, (long)newManifests.size());
        Assert.assertEquals((long)4L, (long)((ManifestFile)newManifests.get(0)).existingFilesCount().intValue());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasAddedFiles());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasDeletedFiles());
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(records1);
        expectedRecords.addAll(records2);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.sort("c1", new String[]{"c2"}).as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assert.assertEquals((String)"Rows must match", (Object)expectedRecords, (Object)actualRecords);
    }

    @Test
    public void testRewriteManifestsWithCommitStateUnknownException() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        this.writeRecords(records1);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(2, "DDDDDDDDDD", "DDDD")});
        this.writeRecords(records2);
        table.refresh();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests before rewrite", (long)2L, (long)manifests.size());
        SparkActions actions = SparkActions.get();
        RewriteManifests newRewriteManifests = table.rewriteManifests();
        RewriteManifests spyNewRewriteManifests = (RewriteManifests)Mockito.spy((Object)newRewriteManifests);
        ((RewriteManifests)Mockito.doAnswer(invocation -> {
            newRewriteManifests.commit();
            throw new CommitStateUnknownException((Throwable)new RuntimeException("Datacenter on Fire"));
        }).when((Object)spyNewRewriteManifests)).commit();
        Table spyTable = (Table)Mockito.spy((Object)table);
        Mockito.when((Object)spyTable.rewriteManifests()).thenReturn((Object)spyNewRewriteManifests);
        AssertHelpers.assertThrowsCause((String)"Should throw a Commit State Unknown Exception", RuntimeException.class, (String)"Datacenter on Fire", () -> actions.rewriteManifests(spyTable).rewriteIf(manifest -> true).execute());
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 1 manifests after rewrite", (long)1L, (long)newManifests.size());
        Assert.assertEquals((long)4L, (long)((ManifestFile)newManifests.get(0)).existingFilesCount().intValue());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasAddedFiles());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasDeletedFiles());
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(records1);
        expectedRecords.addAll(records2);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.sort("c1", new String[]{"c2"}).as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assert.assertEquals((String)"Rows must match", (Object)expectedRecords, (Object)actualRecords);
    }

    @Test
    public void testRewriteSmallManifestsPartitionedTable() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").truncate("c2", 2).build();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        this.writeRecords(records1);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(2, "DDDDDDDDDD", "DDDD")});
        this.writeRecords(records2);
        ArrayList records3 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(3, "EEEEEEEEEE", "EEEE"), new ThreeColumnRecord(3, "FFFFFFFFFF", "FFFF")});
        this.writeRecords(records3);
        ArrayList records4 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(4, "GGGGGGGGGG", "GGGG"), new ThreeColumnRecord(4, "HHHHHHHHHG", "HHHH")});
        this.writeRecords(records4);
        table.refresh();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 4 manifests before rewrite", (long)4L, (long)manifests.size());
        SparkActions actions = SparkActions.get();
        long manifestEntrySizeBytes = this.computeManifestEntrySizeBytes(manifests);
        long targetManifestSizeBytes = (long)(4.2 * (double)manifestEntrySizeBytes);
        table.updateProperties().set("commit.manifest.target-size-bytes", String.valueOf(targetManifestSizeBytes)).commit();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).execute();
        Assert.assertEquals((String)"Action should rewrite 4 manifests", (long)4L, (long)Iterables.size((Iterable)result.rewrittenManifests()));
        Assert.assertEquals((String)"Action should add 2 manifests", (long)2L, (long)Iterables.size((Iterable)result.addedManifests()));
        this.assertManifestsLocation(result.addedManifests());
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests after rewrite", (long)2L, (long)newManifests.size());
        Assert.assertEquals((long)4L, (long)((ManifestFile)newManifests.get(0)).existingFilesCount().intValue());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasAddedFiles());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasDeletedFiles());
        Assert.assertEquals((long)4L, (long)((ManifestFile)newManifests.get(1)).existingFilesCount().intValue());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(1)).hasAddedFiles());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(1)).hasDeletedFiles());
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(records1);
        expectedRecords.addAll(records2);
        expectedRecords.addAll(records3);
        expectedRecords.addAll(records4);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.sort("c1", new String[]{"c2"}).as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assert.assertEquals((String)"Rows must match", (Object)expectedRecords, (Object)actualRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRewriteImportedManifests() throws IOException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c3").build();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        File parquetTableDir = this.temp.newFolder("parquet_table");
        String parquetTableLocation = parquetTableDir.toURI().toString();
        try {
            Dataset inputDF = spark.createDataFrame((List)records, ThreeColumnRecord.class);
            inputDF.select("c1", new String[]{"c2", "c3"}).write().format("parquet").mode("overwrite").option("path", parquetTableLocation).partitionBy(new String[]{"c3"}).saveAsTable("parquet_table");
            File stagingDir = this.temp.newFolder("staging-dir");
            SparkTableUtil.importSparkTable((SparkSession)spark, (TableIdentifier)new TableIdentifier("parquet_table"), (Table)table, (String)stagingDir.toString());
            inputDF.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
            table.refresh();
            Snapshot snapshot = table.currentSnapshot();
            SparkActions actions = SparkActions.get();
            String rewriteStagingLocation = this.temp.newFolder().toString();
            RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).stagingLocation(rewriteStagingLocation).execute();
            Assert.assertEquals((String)"Action should rewrite all manifests", (Object)snapshot.allManifests(table.io()), (Object)result.rewrittenManifests());
            Assert.assertEquals((String)"Action should add 1 manifest", (long)1L, (long)Iterables.size((Iterable)result.addedManifests()));
            this.assertManifestsLocation(result.addedManifests(), rewriteStagingLocation);
        }
        finally {
            spark.sql("DROP TABLE parquet_table");
        }
    }

    @Test
    public void testRewriteLargeManifestsPartitionedTable() throws IOException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c3").build();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records = Lists.newArrayList();
        for (int i = 0; i < 50; ++i) {
            records.add(new ThreeColumnRecord(i, String.valueOf(i), "0"));
        }
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class);
        this.writeDF((Dataset<Row>)df.repartition(50, new Column[]{df.col("c1")}));
        table.refresh();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 1 manifests before rewrite", (long)1L, (long)manifests.size());
        table.updateProperties().set("commit.manifest.target-size-bytes", String.valueOf(((ManifestFile)manifests.get(0)).length() / 2L)).commit();
        SparkActions actions = SparkActions.get();
        String stagingLocation = this.temp.newFolder().toString();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).stagingLocation(stagingLocation).execute();
        Assert.assertEquals((String)"Action should rewrite 1 manifest", (long)1L, (long)Iterables.size((Iterable)result.rewrittenManifests()));
        Assert.assertEquals((String)"Action should add 2 manifests", (long)2L, (long)Iterables.size((Iterable)result.addedManifests()));
        this.assertManifestsLocation(result.addedManifests(), stagingLocation);
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests after rewrite", (long)2L, (long)newManifests.size());
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.sort("c1", new String[]{"c2"}).as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assert.assertEquals((String)"Rows must match", (Object)records, (Object)actualRecords);
    }

    @Test
    public void testRewriteManifestsWithPredicate() throws IOException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").truncate("c2", 2).build();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        this.writeRecords(records1);
        this.writeRecords(records1);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(2, "DDDDDDDDDD", "DDDD")});
        this.writeRecords(records2);
        table.refresh();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 3 manifests before rewrite", (long)3L, (long)manifests.size());
        SparkActions actions = SparkActions.get();
        String stagingLocation = this.temp.newFolder().toString();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> manifest.path().equals(((ManifestFile)manifests.get(0)).path()) || manifest.path().equals(((ManifestFile)manifests.get(1)).path())).stagingLocation(stagingLocation).option("use-caching", this.useCaching)).execute();
        Assert.assertEquals((String)"Action should rewrite 2 manifest", (long)2L, (long)Iterables.size((Iterable)result.rewrittenManifests()));
        Assert.assertEquals((String)"Action should add 1 manifests", (long)1L, (long)Iterables.size((Iterable)result.addedManifests()));
        this.assertManifestsLocation(result.addedManifests(), stagingLocation);
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests after rewrite", (long)2L, (long)newManifests.size());
        Assert.assertFalse((String)"First manifest must be rewritten", (boolean)newManifests.contains(manifests.get(0)));
        Assert.assertFalse((String)"Second manifest must be rewritten", (boolean)newManifests.contains(manifests.get(1)));
        Assert.assertTrue((String)"Third manifest must not be rewritten", (boolean)newManifests.contains(manifests.get(2)));
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.add((ThreeColumnRecord)records1.get(0));
        expectedRecords.add((ThreeColumnRecord)records1.get(0));
        expectedRecords.add((ThreeColumnRecord)records1.get(1));
        expectedRecords.add((ThreeColumnRecord)records1.get(1));
        expectedRecords.addAll(records2);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.sort("c1", new String[]{"c2"}).as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assert.assertEquals((String)"Rows must match", (Object)expectedRecords, (Object)actualRecords);
    }

    @Test
    public void testRewriteSmallManifestsNonPartitionedV2Table() {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThan(1);
        PartitionSpec spec = PartitionSpec.unpartitioned();
        ImmutableMap properties = ImmutableMap.of((Object)"format-version", (Object)"2");
        Table table = TABLES.create(SCHEMA, spec, (Map)properties, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA")});
        this.writeRecords(records1);
        table.refresh();
        Snapshot snapshot1 = table.currentSnapshot();
        DataFile file1 = (DataFile)Iterables.getOnlyElement((Iterable)snapshot1.addedDataFiles(table.io()));
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "CCCC", "CCCC")});
        this.writeRecords(records2);
        table.refresh();
        Snapshot snapshot2 = table.currentSnapshot();
        DataFile file2 = (DataFile)Iterables.getOnlyElement((Iterable)snapshot2.addedDataFiles(table.io()));
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests before rewrite", (long)2L, (long)manifests.size());
        SparkActions actions = SparkActions.get();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).option("use-caching", this.useCaching)).execute();
        Assert.assertEquals((String)"Action should rewrite 2 manifests", (long)2L, (long)Iterables.size((Iterable)result.rewrittenManifests()));
        Assert.assertEquals((String)"Action should add 1 manifests", (long)1L, (long)Iterables.size((Iterable)result.addedManifests()));
        this.assertManifestsLocation(result.addedManifests());
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 1 manifests after rewrite", (long)1L, (long)newManifests.size());
        ManifestFile newManifest = (ManifestFile)Iterables.getOnlyElement((Iterable)newManifests);
        Assert.assertEquals((long)2L, (long)newManifest.existingFilesCount().intValue());
        Assert.assertFalse((boolean)newManifest.hasAddedFiles());
        Assert.assertFalse((boolean)newManifest.hasDeletedFiles());
        ValidationHelpers.validateDataManifest(table, newManifest, ValidationHelpers.dataSeqs(1L, 2L), ValidationHelpers.fileSeqs(1L, 2L), ValidationHelpers.snapshotIds(snapshot1.snapshotId(), snapshot2.snapshotId()), ValidationHelpers.files(new ContentFile[]{file1, file2}));
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(records1);
        expectedRecords.addAll(records2);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.sort("c1", new String[]{"c2"}).as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assert.assertEquals((String)"Rows must match", (Object)expectedRecords, (Object)actualRecords);
    }

    private void writeRecords(List<ThreeColumnRecord> records) {
        Dataset df = spark.createDataFrame(records, ThreeColumnRecord.class);
        this.writeDF((Dataset<Row>)df);
    }

    private void writeDF(Dataset<Row> df) {
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").option("distribution-mode", "none").mode("append").save(this.tableLocation);
    }

    private long computeManifestEntrySizeBytes(List<ManifestFile> manifests) {
        long totalSize = 0L;
        int numEntries = 0;
        for (ManifestFile manifest : manifests) {
            totalSize += manifest.length();
            numEntries += manifest.addedFilesCount() + manifest.existingFilesCount() + manifest.deletedFilesCount();
        }
        return totalSize / (long)numEntries;
    }

    private void assertManifestsLocation(Iterable<ManifestFile> manifests) {
        this.assertManifestsLocation(manifests, null);
    }

    private void assertManifestsLocation(Iterable<ManifestFile> manifests, String stagingLocation) {
        if (this.shouldStageManifests && stagingLocation != null) {
            Assertions.assertThat(manifests).allMatch(manifest -> manifest.path().startsWith(stagingLocation));
        } else {
            Assertions.assertThat(manifests).allMatch(manifest -> manifest.path().startsWith(this.tableLocation));
        }
    }
}

