/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

public class GenericsHelpers {
    private static final OffsetDateTime EPOCH = Instant.ofEpochMilli(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private GenericsHelpers() {
    }

    public static void assertEqualsSafe(Types.StructType struct, Record expected, Row actual) {
        List fields = struct.fields();
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = ((Types.NestedField)fields.get(i)).type();
            Object expectedValue = expected.get(i);
            Object actualValue = actual.get(i);
            GenericsHelpers.assertEqualsSafe(fieldType, expectedValue, actualValue);
        }
    }

    private static void assertEqualsSafe(Types.ListType list, Collection<?> expected, List<?> actual) {
        Type elementType = list.elementType();
        ArrayList expectedElements = Lists.newArrayList(expected);
        for (int i = 0; i < expectedElements.size(); ++i) {
            Object expectedValue = expectedElements.get(i);
            Object actualValue = actual.get(i);
            GenericsHelpers.assertEqualsSafe(elementType, expectedValue, actualValue);
        }
    }

    private static void assertEqualsSafe(Types.MapType map, java.util.Map<?, ?> expected, java.util.Map<?, ?> actual) {
        Type keyType = map.keyType();
        Type valueType = map.valueType();
        Assert.assertEquals((String)"Should have the same number of keys", (long)expected.keySet().size(), (long)actual.keySet().size());
        for (Object expectedKey : expected.keySet()) {
            Object matchingKey = null;
            for (Object actualKey : actual.keySet()) {
                try {
                    GenericsHelpers.assertEqualsSafe(keyType, expectedKey, actualKey);
                    matchingKey = actualKey;
                    break;
                }
                catch (AssertionError assertionError) {
                }
            }
            Assert.assertNotNull((String)"Should have a matching key", matchingKey);
            GenericsHelpers.assertEqualsSafe(valueType, expected.get(expectedKey), actual.get(matchingKey));
        }
    }

    private static void assertEqualsSafe(Type type, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        switch (type.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                Assert.assertEquals((String)"Primitive value should be equal to expected", (Object)expected, (Object)actual);
                break;
            }
            case DATE: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a LocalDate", new Object[0])).isInstanceOf(LocalDate.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Date", new Object[0])).isInstanceOf(Date.class);
                Assert.assertEquals((String)"ISO-8601 date should be equal", (Object)expected.toString(), (Object)actual.toString());
                break;
            }
            case TIMESTAMP: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Timestamp", new Object[0])).isInstanceOf(Timestamp.class);
                Timestamp ts = (Timestamp)actual;
                OffsetDateTime actualTs = EPOCH.plusNanos(ts.getTime() * 1000000L + (long)(ts.getNanos() % 1000000));
                Types.TimestampType timestampType = (Types.TimestampType)type;
                if (timestampType.shouldAdjustToUTC()) {
                    ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect an OffsetDateTime", new Object[0])).isInstanceOf(OffsetDateTime.class);
                    Assert.assertEquals((String)"Timestamp should be equal", (Object)expected, (Object)actualTs);
                    break;
                }
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect an LocalDateTime", new Object[0])).isInstanceOf(LocalDateTime.class);
                Assert.assertEquals((String)"Timestamp should be equal", (Object)expected, (Object)actualTs.toLocalDateTime());
                break;
            }
            case STRING: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a String", new Object[0])).isInstanceOf(String.class);
                Assert.assertEquals((String)"Strings should be equal", (Object)String.valueOf(expected), (Object)actual);
                break;
            }
            case UUID: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a UUID", new Object[0])).isInstanceOf(UUID.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a String", new Object[0])).isInstanceOf(String.class);
                Assert.assertEquals((String)"UUID string representation should match", (Object)expected.toString(), (Object)actual);
                break;
            }
            case FIXED: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a byte[]", new Object[0])).isInstanceOf(byte[].class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                Assert.assertArrayEquals((String)"Bytes should match", (byte[])((byte[])expected), (byte[])((byte[])actual));
                break;
            }
            case BINARY: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a ByteBuffer", new Object[0])).isInstanceOf(ByteBuffer.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                Assert.assertArrayEquals((String)"Bytes should match", (byte[])((ByteBuffer)expected).array(), (byte[])((byte[])actual));
                break;
            }
            case DECIMAL: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a BigDecimal", new Object[0])).isInstanceOf(BigDecimal.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a BigDecimal", new Object[0])).isInstanceOf(BigDecimal.class);
                Assert.assertEquals((String)"BigDecimals should be equal", (Object)expected, (Object)actual);
                break;
            }
            case STRUCT: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Record", new Object[0])).isInstanceOf(Record.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Row", new Object[0])).isInstanceOf(Row.class);
                GenericsHelpers.assertEqualsSafe(type.asNestedType().asStructType(), (Record)expected, (Row)actual);
                break;
            }
            case LIST: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Collection", new Object[0])).isInstanceOf(Collection.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Seq", new Object[0])).isInstanceOf(Seq.class);
                List asList = (List)JavaConverters.seqAsJavaListConverter((Seq)((Seq)actual)).asJava();
                GenericsHelpers.assertEqualsSafe(type.asNestedType().asListType(), (Collection)expected, asList);
                break;
            }
            case MAP: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Collection", new Object[0])).isInstanceOf(java.util.Map.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Map", new Object[0])).isInstanceOf(Map.class);
                java.util.Map asMap = (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)((Map)actual)).asJava();
                GenericsHelpers.assertEqualsSafe(type.asNestedType().asMapType(), (java.util.Map)expected, asMap);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a supported type: " + type);
            }
        }
    }

    public static void assertEqualsUnsafe(Types.StructType struct, Record expected, InternalRow actual) {
        List fields = struct.fields();
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = ((Types.NestedField)fields.get(i)).type();
            Object expectedValue = expected.get(i);
            Object actualValue = actual.get(i, SparkSchemaUtil.convert((Type)fieldType));
            GenericsHelpers.assertEqualsUnsafe(fieldType, expectedValue, actualValue);
        }
    }

    private static void assertEqualsUnsafe(Types.ListType list, Collection<?> expected, ArrayData actual) {
        Type elementType = list.elementType();
        ArrayList expectedElements = Lists.newArrayList(expected);
        for (int i = 0; i < expectedElements.size(); ++i) {
            Object expectedValue = expectedElements.get(i);
            Object actualValue = actual.get(i, SparkSchemaUtil.convert((Type)elementType));
            GenericsHelpers.assertEqualsUnsafe(elementType, expectedValue, actualValue);
        }
    }

    private static void assertEqualsUnsafe(Types.MapType map, java.util.Map<?, ?> expected, MapData actual) {
        Type keyType = map.keyType();
        Type valueType = map.valueType();
        ArrayList expectedElements = Lists.newArrayList(expected.entrySet());
        ArrayData actualKeys = actual.keyArray();
        ArrayData actualValues = actual.valueArray();
        for (int i = 0; i < expectedElements.size(); ++i) {
            Map.Entry expectedPair = (Map.Entry)expectedElements.get(i);
            Object actualKey = actualKeys.get(i, SparkSchemaUtil.convert((Type)keyType));
            Object actualValue = actualValues.get(i, SparkSchemaUtil.convert((Type)keyType));
            GenericsHelpers.assertEqualsUnsafe(keyType, expectedPair.getKey(), actualKey);
            GenericsHelpers.assertEqualsUnsafe(valueType, expectedPair.getValue(), actualValue);
        }
    }

    private static void assertEqualsUnsafe(Type type, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        switch (type.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                Assert.assertEquals((String)"Primitive value should be equal to expected", (Object)expected, (Object)actual);
                break;
            }
            case DATE: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a LocalDate", new Object[0])).isInstanceOf(LocalDate.class);
                int expectedDays = (int)ChronoUnit.DAYS.between(EPOCH_DAY, (LocalDate)expected);
                Assert.assertEquals((String)"Primitive value should be equal to expected", (Object)expectedDays, (Object)actual);
                break;
            }
            case TIMESTAMP: {
                Types.TimestampType timestampType = (Types.TimestampType)type;
                if (timestampType.shouldAdjustToUTC()) {
                    ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect an OffsetDateTime", new Object[0])).isInstanceOf(OffsetDateTime.class);
                    long expectedMicros = ChronoUnit.MICROS.between(EPOCH, (OffsetDateTime)expected);
                    Assert.assertEquals((String)"Primitive value should be equal to expected", (Object)expectedMicros, (Object)actual);
                    break;
                }
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect an LocalDateTime", new Object[0])).isInstanceOf(LocalDateTime.class);
                long expectedMicros = ChronoUnit.MICROS.between(EPOCH, ((LocalDateTime)expected).atZone(ZoneId.of("UTC")));
                Assert.assertEquals((String)"Primitive value should be equal to expected", (Object)expectedMicros, (Object)actual);
                break;
            }
            case STRING: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a UTF8String", new Object[0])).isInstanceOf(UTF8String.class);
                Assert.assertEquals((String)"Strings should be equal", (Object)expected, (Object)actual.toString());
                break;
            }
            case UUID: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a UUID", new Object[0])).isInstanceOf(UUID.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a UTF8String", new Object[0])).isInstanceOf(UTF8String.class);
                Assert.assertEquals((String)"UUID string representation should match", (Object)expected.toString(), (Object)actual.toString());
                break;
            }
            case FIXED: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a byte[]", new Object[0])).isInstanceOf(byte[].class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                Assert.assertArrayEquals((String)"Bytes should match", (byte[])((byte[])expected), (byte[])((byte[])actual));
                break;
            }
            case BINARY: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a ByteBuffer", new Object[0])).isInstanceOf(ByteBuffer.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                Assert.assertArrayEquals((String)"Bytes should match", (byte[])((ByteBuffer)expected).array(), (byte[])((byte[])actual));
                break;
            }
            case DECIMAL: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a BigDecimal", new Object[0])).isInstanceOf(BigDecimal.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Decimal", new Object[0])).isInstanceOf(Decimal.class);
                Assert.assertEquals((String)"BigDecimals should be equal", (Object)expected, (Object)((Decimal)actual).toJavaBigDecimal());
                break;
            }
            case STRUCT: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Record", new Object[0])).isInstanceOf(Record.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be an InternalRow", new Object[0])).isInstanceOf(InternalRow.class);
                GenericsHelpers.assertEqualsUnsafe(type.asNestedType().asStructType(), (Record)expected, (InternalRow)actual);
                break;
            }
            case LIST: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Collection", new Object[0])).isInstanceOf(Collection.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be an ArrayData", new Object[0])).isInstanceOf(ArrayData.class);
                GenericsHelpers.assertEqualsUnsafe(type.asNestedType().asListType(), (Collection)expected, (ArrayData)actual);
                break;
            }
            case MAP: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Map", new Object[0])).isInstanceOf(java.util.Map.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be an ArrayBasedMapData", new Object[0])).isInstanceOf(MapData.class);
                GenericsHelpers.assertEqualsUnsafe(type.asNestedType().asMapType(), (java.util.Map)expected, (MapData)actual);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a supported type: " + type);
            }
        }
    }
}

