/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.data.AvroDataTest;
import org.apache.iceberg.spark.data.GenericsHelpers;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.SparkParquetReaders;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestSparkParquetReader
extends AvroDataTest {
    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        Assume.assumeTrue((String)"Parquet Avro cannot write non-string map keys", (null == TypeUtil.find((Schema)schema, type -> type.isMapType() && type.asMapType().keyType() != Types.StringType.get()) ? 1 : 0) != 0);
        List<GenericData.Record> expected = RandomData.generateList(schema, 100, 0L);
        File testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)testFile.delete());
        try (FileAppender writer = Parquet.write((org.apache.iceberg.io.OutputFile)Files.localOutput((File)testFile)).schema(schema).named("test").build();){
            writer.addAll(expected);
        }
        var5_5 = null;
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).createReaderFunc(type -> SparkParquetReaders.buildReader((Schema)schema, (MessageType)type)).build();){
            CloseableIterator rows = reader.iterator();
            for (GenericData.Record record : expected) {
                Assert.assertTrue((String)"Should have expected number of rows", (boolean)rows.hasNext());
                TestHelpers.assertEqualsUnsafe(schema.asStruct(), record, (InternalRow)rows.next());
            }
            Assert.assertFalse((String)"Should not have extra rows", (boolean)rows.hasNext());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    protected List<InternalRow> rowsFromFile(InputFile inputFile, Schema schema) throws IOException {
        try (CloseableIterable reader = Parquet.read((InputFile)inputFile).project(schema).createReaderFunc(type -> SparkParquetReaders.buildReader((Schema)schema, (MessageType)type)).build();){
            ArrayList arrayList = Lists.newArrayList((Iterable)reader);
            return arrayList;
        }
    }

    protected Table tableFromInputFile(InputFile inputFile, Schema schema) throws IOException {
        HadoopTables tables = new HadoopTables();
        Table table = tables.create(schema, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of(), this.temp.newFolder().getCanonicalPath());
        table.newAppend().appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withFormat(FileFormat.PARQUET).withInputFile(inputFile).withMetrics(ParquetUtil.fileMetrics((InputFile)inputFile, (MetricsConfig)MetricsConfig.getDefault())).withFileSizeInBytes(inputFile.getLength()).build()).commit();
        return table;
    }

    @Test
    public void testInt96TimestampProducedBySparkIsReadCorrectly() throws IOException {
        String outputFilePath = String.format("%s/%s", this.temp.getRoot().getAbsolutePath(), "parquet_int96.parquet");
        HadoopOutputFile outputFile = HadoopOutputFile.fromPath((Path)new Path(outputFilePath), (Configuration)new Configuration());
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"ts", (Type)Types.TimestampType.withZone())});
        StructType sparkSchema = new StructType(new StructField[]{new StructField("ts", DataTypes.TimestampType, true, Metadata.empty())});
        ArrayList rows = Lists.newArrayList(RandomData.generateSpark(schema, 10, 0L));
        try (ParquetWriter writer = new NativeSparkWriterBuilder((OutputFile)outputFile).set("org.apache.spark.sql.parquet.row.attributes", sparkSchema.json()).set("spark.sql.parquet.writeLegacyFormat", "false").set("spark.sql.parquet.outputTimestampType", "INT96").set("spark.sql.parquet.fieldId.write.enabled", "true").build();){
            for (InternalRow row : rows) {
                writer.write((Object)row);
            }
        }
        InputFile parquetInputFile = Files.localInput((String)outputFilePath);
        List<InternalRow> readRows = this.rowsFromFile(parquetInputFile, schema);
        Assert.assertEquals((long)rows.size(), (long)readRows.size());
        Assertions.assertThat(readRows).isEqualTo((Object)rows);
        Table int96Table = this.tableFromInputFile(parquetInputFile, schema);
        ArrayList tableRecords = Lists.newArrayList((Iterable)IcebergGenerics.read((Table)int96Table).build());
        Assert.assertEquals((long)rows.size(), (long)tableRecords.size());
        for (int i = 0; i < tableRecords.size(); ++i) {
            GenericsHelpers.assertEqualsUnsafe(schema.asStruct(), (Record)tableRecords.get(i), (InternalRow)rows.get(i));
        }
    }

    private static class NativeSparkWriterBuilder
    extends ParquetWriter.Builder<InternalRow, NativeSparkWriterBuilder> {
        private final Map<String, String> config = Maps.newHashMap();

        NativeSparkWriterBuilder(OutputFile path) {
            super(path);
        }

        public NativeSparkWriterBuilder set(String property, String value) {
            this.config.put(property, value);
            return this.self();
        }

        protected NativeSparkWriterBuilder self() {
            return this;
        }

        protected WriteSupport<InternalRow> getWriteSupport(Configuration configuration) {
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                configuration.set(entry.getKey(), entry.getValue());
            }
            return new ParquetWriteSupport();
        }
    }
}

