/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.parquet.vectorized;

import java.io.File;
import java.io.IOException;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Function;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.parquet.vectorized.TestParquetVectorizedReads;
import org.junit.Ignore;
import org.junit.Test;

public class TestParquetDictionaryFallbackToPlainEncodingVectorizedReads
extends TestParquetVectorizedReads {
    private static final int NUM_ROWS = 1000000;

    @Override
    protected int getNumRows() {
        return 1000000;
    }

    @Override
    Iterable<GenericData.Record> generateData(Schema schema, int numRecords, long seed, float nullPercentage, Function<GenericData.Record, GenericData.Record> transform) {
        Iterable data = RandomData.generateFallbackData(schema, numRecords, seed, numRecords / 20);
        return transform == IDENTITY ? data : Iterables.transform(data, transform);
    }

    @Override
    FileAppender<GenericData.Record> parquetWriter(Schema schema, File testFile) throws IOException {
        return Parquet.write((OutputFile)Files.localOutput((File)testFile)).schema(schema).named("test").set("write.parquet.dict-size-bytes", "512000").build();
    }

    @Override
    @Test
    @Ignore
    public void testMostlyNullsForOptionalFields() {
    }

    @Override
    @Test
    @Ignore
    public void testVectorizedReadsWithNewContainers() throws IOException {
    }
}

