/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.time.Duration;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore;
import org.apache.spark.sql.execution.ui.SQLExecutionUIData;
import org.apache.spark.sql.execution.ui.SQLPlanMetric;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import scala.Option;

public class SparkSQLExecutionHelper {
    private SparkSQLExecutionHelper() {
    }

    public static String lastExecutedMetricValue(SparkSession spark, String metricName) {
        SQLAppStatusStore statusStore = spark.sharedState().statusStore();
        SQLExecutionUIData lastExecution = (SQLExecutionUIData)statusStore.executionsList().last();
        Option sqlPlanMetric = lastExecution.metrics().find(metric -> metric.name().equals(metricName));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)sqlPlanMetric.isDefined()).as(String.format("Metric '%s' not found in last execution", metricName), new Object[0])).isTrue();
        long metricId = ((SQLPlanMetric)sqlPlanMetric.get()).accumulatorId();
        Awaitility.await().atMost(Duration.ofSeconds(3L)).pollInterval(Duration.ofMillis(100L)).untilAsserted(() -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)((SQLExecutionUIData)statusStore.execution(lastExecution.executionId()).get())).isNotNull();
        });
        SQLExecutionUIData exec = (SQLExecutionUIData)statusStore.execution(lastExecution.executionId()).get();
        ((ObjectAssert)Assertions.assertThat((Object)exec.metricValues()).as("Metric values were not finalized", new Object[0])).isNotNull();
        String metricValue = (String)exec.metricValues().get((Object)metricId).getOrElse(null);
        ((AbstractStringAssert)Assertions.assertThat((String)metricValue).as(String.format("Metric '%s' was not finalized", metricName), new Object[0])).isNotNull();
        return metricValue;
    }
}

