/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.data.GenericsHelpers;
import org.apache.iceberg.spark.source.SparkScanBuilder;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SerializableFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFilteredScan {
    private static final Configuration CONF = new Configuration();
    private static final HadoopTables TABLES = new HadoopTables(CONF);
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)3, (String)"data", (Type)Types.StringType.get())});
    private static final PartitionSpec BUCKET_BY_ID = PartitionSpec.builderFor((Schema)SCHEMA).bucket("id", 4).build();
    private static final PartitionSpec PARTITION_BY_DAY = PartitionSpec.builderFor((Schema)SCHEMA).day("ts").build();
    private static final PartitionSpec PARTITION_BY_HOUR = PartitionSpec.builderFor((Schema)SCHEMA).hour("ts").build();
    private static final PartitionSpec PARTITION_BY_DATA = PartitionSpec.builderFor((Schema)SCHEMA).identity("data").build();
    private static final PartitionSpec PARTITION_BY_ID = PartitionSpec.builderFor((Schema)SCHEMA).identity("id").build();
    private static SparkSession spark = null;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private final String format;
    private final boolean vectorized;
    private File parent = null;
    private File unpartitioned = null;
    private List<Record> records = null;

    @BeforeClass
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
        SerializableFunction bucket4 = Transforms.bucket((int)4).bind((Type)Types.LongType.get());
        spark.udf().register("bucket4", ((Function)bucket4)::apply, (DataType)IntegerType$.MODULE$);
        SerializableFunction day = Transforms.day().bind((Type)Types.TimestampType.withZone());
        spark.udf().register("ts_day", arg_0 -> TestFilteredScan.lambda$startSpark$9f79e71b$1((Function)day, arg_0), (DataType)IntegerType$.MODULE$);
        SerializableFunction hour = Transforms.hour().bind((Type)Types.TimestampType.withZone());
        spark.udf().register("ts_hour", arg_0 -> TestFilteredScan.lambda$startSpark$5001b11d$1((Function)hour, arg_0), (DataType)IntegerType$.MODULE$);
        spark.udf().register("data_ident", (UDF1 & Serializable)data -> data, (DataType)StringType$.MODULE$);
        spark.udf().register("id_ident", (UDF1 & Serializable)id -> id, (DataType)LongType$.MODULE$);
    }

    @AfterClass
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        currentSpark.stop();
    }

    @Parameterized.Parameters(name="format = {0}, vectorized = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{"parquet", false}, {"parquet", true}, {"avro", false}, {"orc", false}, {"orc", true}};
    }

    public TestFilteredScan(String format, boolean vectorized) {
        this.format = format;
        this.vectorized = vectorized;
    }

    @Before
    public void writeUnpartitionedTable() throws IOException {
        this.parent = this.temp.newFolder("TestFilteredScan");
        this.unpartitioned = new File(this.parent, "unpartitioned");
        File dataFolder = new File(this.unpartitioned, "data");
        Assert.assertTrue((String)"Mkdir should succeed", (boolean)dataFolder.mkdirs());
        Table table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), this.unpartitioned.toString());
        Schema tableSchema = table.schema();
        FileFormat fileFormat = FileFormat.fromString((String)this.format);
        File testFile = new File(dataFolder, fileFormat.addExtension(UUID.randomUUID().toString()));
        this.records = this.testRecords(tableSchema);
        try (FileAppender writer = new GenericAppenderFactory(tableSchema).newAppender(Files.localOutput((File)testFile), fileFormat);){
            writer.addAll(this.records);
        }
        DataFile file = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withRecordCount((long)this.records.size()).withFileSizeInBytes(testFile.length()).withPath(testFile.toString()).build();
        table.newAppend().appendFile(file).commit();
    }

    @Test
    public void testUnpartitionedIDFilters() {
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)this.unpartitioned.toString()));
        SparkScanBuilder builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options);
        for (int i = 0; i < 10; ++i) {
            this.pushFilters((ScanBuilder)builder, new Filter[]{EqualTo.apply((String)"id", (Object)i)});
            Batch scan = builder.build().toBatch();
            InputPartition[] partitions = scan.planInputPartitions();
            Assert.assertEquals((String)"Should only create one task for a small file", (long)1L, (long)partitions.length);
            TestFilteredScan.assertEqualsSafe(SCHEMA.asStruct(), this.expected(i), TestFilteredScan.read(this.unpartitioned.toString(), this.vectorized, "id = " + i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnpartitionedCaseInsensitiveIDFilters() {
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)this.unpartitioned.toString()));
        String caseSensitivityBeforeTest = spark.conf().get("spark.sql.caseSensitive");
        spark.conf().set("spark.sql.caseSensitive", "false");
        try {
            for (int i = 0; i < 10; ++i) {
                SparkScanBuilder builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options).caseSensitive(false);
                this.pushFilters((ScanBuilder)builder, new Filter[]{EqualTo.apply((String)"ID", (Object)i)});
                Batch scan = builder.build().toBatch();
                InputPartition[] tasks = scan.planInputPartitions();
                Assert.assertEquals((String)"Should only create one task for a small file", (long)1L, (long)tasks.length);
                TestFilteredScan.assertEqualsSafe(SCHEMA.asStruct(), this.expected(i), TestFilteredScan.read(this.unpartitioned.toString(), this.vectorized, "id = " + i));
            }
        }
        finally {
            spark.conf().set("spark.sql.caseSensitive", caseSensitivityBeforeTest);
        }
    }

    @Test
    public void testUnpartitionedTimestampFilter() {
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)this.unpartitioned.toString()));
        SparkScanBuilder builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options);
        this.pushFilters((ScanBuilder)builder, new Filter[]{LessThan.apply((String)"ts", (Object)"2017-12-22T00:00:00+00:00")});
        Batch scan = builder.build().toBatch();
        InputPartition[] tasks = scan.planInputPartitions();
        Assert.assertEquals((String)"Should only create one task for a small file", (long)1L, (long)tasks.length);
        TestFilteredScan.assertEqualsSafe(SCHEMA.asStruct(), this.expected(5, 6, 7, 8, 9), TestFilteredScan.read(this.unpartitioned.toString(), this.vectorized, "ts < cast('2017-12-22 00:00:00+00:00' as timestamp)"));
    }

    @Test
    public void testBucketPartitionedIDFilters() {
        Table table = this.buildPartitionedTable("bucketed_by_id", BUCKET_BY_ID, "bucket4", "id");
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)table.location()));
        Batch unfiltered = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options).build().toBatch();
        Assert.assertEquals((String)"Unfiltered table should created 4 read tasks", (long)4L, (long)unfiltered.planInputPartitions().length);
        for (int i = 0; i < 10; ++i) {
            SparkScanBuilder builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options);
            this.pushFilters((ScanBuilder)builder, new Filter[]{EqualTo.apply((String)"id", (Object)i)});
            Batch scan = builder.build().toBatch();
            InputPartition[] tasks = scan.planInputPartitions();
            Assert.assertEquals((String)"Should create one task for a single bucket", (long)1L, (long)tasks.length);
            TestFilteredScan.assertEqualsSafe(SCHEMA.asStruct(), this.expected(i), TestFilteredScan.read(table.location(), this.vectorized, "id = " + i));
        }
    }

    @Test
    public void testDayPartitionedTimestampFilters() {
        Table table = this.buildPartitionedTable("partitioned_by_day", PARTITION_BY_DAY, "ts_day", "ts");
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)table.location()));
        Batch unfiltered = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options).build().toBatch();
        Assert.assertEquals((String)"Unfiltered table should created 2 read tasks", (long)2L, (long)unfiltered.planInputPartitions().length);
        SparkScanBuilder builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options);
        this.pushFilters((ScanBuilder)builder, new Filter[]{LessThan.apply((String)"ts", (Object)"2017-12-22T00:00:00+00:00")});
        Batch scan = builder.build().toBatch();
        InputPartition[] tasks = scan.planInputPartitions();
        Assert.assertEquals((String)"Should create one task for 2017-12-21", (long)1L, (long)tasks.length);
        TestFilteredScan.assertEqualsSafe(SCHEMA.asStruct(), this.expected(5, 6, 7, 8, 9), TestFilteredScan.read(table.location(), this.vectorized, "ts < cast('2017-12-22 00:00:00+00:00' as timestamp)"));
        builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options);
        this.pushFilters((ScanBuilder)builder, new Filter[]{And.apply((Filter)GreaterThan.apply((String)"ts", (Object)"2017-12-22T06:00:00+00:00"), (Filter)LessThan.apply((String)"ts", (Object)"2017-12-22T08:00:00+00:00"))});
        scan = builder.build().toBatch();
        tasks = scan.planInputPartitions();
        Assert.assertEquals((String)"Should create one task for 2017-12-22", (long)1L, (long)tasks.length);
        TestFilteredScan.assertEqualsSafe(SCHEMA.asStruct(), this.expected(1, 2), TestFilteredScan.read(table.location(), this.vectorized, "ts > cast('2017-12-22 06:00:00+00:00' as timestamp) and ts < cast('2017-12-22 08:00:00+00:00' as timestamp)"));
    }

    @Test
    public void testHourPartitionedTimestampFilters() {
        Table table = this.buildPartitionedTable("partitioned_by_hour", PARTITION_BY_HOUR, "ts_hour", "ts");
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)table.location()));
        Batch unfiltered = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options).build().toBatch();
        Assert.assertEquals((String)"Unfiltered table should created 9 read tasks", (long)9L, (long)unfiltered.planInputPartitions().length);
        SparkScanBuilder builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options);
        this.pushFilters((ScanBuilder)builder, new Filter[]{LessThan.apply((String)"ts", (Object)"2017-12-22T00:00:00+00:00")});
        Batch scan = builder.build().toBatch();
        InputPartition[] tasks = scan.planInputPartitions();
        Assert.assertEquals((String)"Should create 4 tasks for 2017-12-21: 15, 17, 21, 22", (long)4L, (long)tasks.length);
        TestFilteredScan.assertEqualsSafe(SCHEMA.asStruct(), this.expected(8, 9, 7, 6, 5), TestFilteredScan.read(table.location(), this.vectorized, "ts < cast('2017-12-22 00:00:00+00:00' as timestamp)"));
        builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options);
        this.pushFilters((ScanBuilder)builder, new Filter[]{And.apply((Filter)GreaterThan.apply((String)"ts", (Object)"2017-12-22T06:00:00+00:00"), (Filter)LessThan.apply((String)"ts", (Object)"2017-12-22T08:00:00+00:00"))});
        scan = builder.build().toBatch();
        tasks = scan.planInputPartitions();
        Assert.assertEquals((String)"Should create 2 tasks for 2017-12-22: 6, 7", (long)2L, (long)tasks.length);
        TestFilteredScan.assertEqualsSafe(SCHEMA.asStruct(), this.expected(2, 1), TestFilteredScan.read(table.location(), this.vectorized, "ts > cast('2017-12-22 06:00:00+00:00' as timestamp) and ts < cast('2017-12-22 08:00:00+00:00' as timestamp)"));
    }

    @Test
    public void testFilterByNonProjectedColumn() {
        Schema actualProjection = SCHEMA.select(new String[]{"id", "data"});
        ArrayList expected = Lists.newArrayList();
        for (Record rec : this.expected(5, 6, 7, 8, 9)) {
            expected.add(TestFilteredScan.projectFlat(actualProjection, rec));
        }
        TestFilteredScan.assertEqualsSafe(actualProjection.asStruct(), expected, TestFilteredScan.read(this.unpartitioned.toString(), this.vectorized, "ts < cast('2017-12-22 00:00:00+00:00' as timestamp)", "id", "data"));
        actualProjection = SCHEMA.select(new String[]{"id"});
        expected = Lists.newArrayList();
        for (Record rec : this.expected(1, 2)) {
            expected.add(TestFilteredScan.projectFlat(actualProjection, rec));
        }
        TestFilteredScan.assertEqualsSafe(actualProjection.asStruct(), expected, TestFilteredScan.read(this.unpartitioned.toString(), this.vectorized, "ts > cast('2017-12-22 06:00:00+00:00' as timestamp) and ts < cast('2017-12-22 08:00:00+00:00' as timestamp)", "id", new String[0]));
    }

    @Test
    public void testPartitionedByDataStartsWithFilter() {
        Table table = this.buildPartitionedTable("partitioned_by_data", PARTITION_BY_DATA, "data_ident", "data");
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)table.location()));
        SparkScanBuilder builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options);
        this.pushFilters((ScanBuilder)builder, new Filter[]{new StringStartsWith("data", "junc")});
        Batch scan = builder.build().toBatch();
        Assert.assertEquals((long)1L, (long)scan.planInputPartitions().length);
    }

    @Test
    public void testPartitionedByDataNotStartsWithFilter() {
        Table table = this.buildPartitionedTable("partitioned_by_data", PARTITION_BY_DATA, "data_ident", "data");
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)table.location()));
        SparkScanBuilder builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options);
        this.pushFilters((ScanBuilder)builder, new Filter[]{new Not((Filter)new StringStartsWith("data", "junc"))});
        Batch scan = builder.build().toBatch();
        Assert.assertEquals((long)9L, (long)scan.planInputPartitions().length);
    }

    @Test
    public void testPartitionedByIdStartsWith() {
        Table table = this.buildPartitionedTable("partitioned_by_id", PARTITION_BY_ID, "id_ident", "id");
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)table.location()));
        SparkScanBuilder builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options);
        this.pushFilters((ScanBuilder)builder, new Filter[]{new StringStartsWith("data", "junc")});
        Batch scan = builder.build().toBatch();
        Assert.assertEquals((long)1L, (long)scan.planInputPartitions().length);
    }

    @Test
    public void testPartitionedByIdNotStartsWith() {
        Table table = this.buildPartitionedTable("partitioned_by_id", PARTITION_BY_ID, "id_ident", "id");
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)table.location()));
        SparkScanBuilder builder = new SparkScanBuilder(spark, TABLES.load(options.get((Object)"path")), options);
        this.pushFilters((ScanBuilder)builder, new Filter[]{new Not((Filter)new StringStartsWith("data", "junc"))});
        Batch scan = builder.build().toBatch();
        Assert.assertEquals((long)9L, (long)scan.planInputPartitions().length);
    }

    @Test
    public void testUnpartitionedStartsWith() {
        Dataset df = spark.read().format("iceberg").option("vectorization-enabled", String.valueOf(this.vectorized)).load(this.unpartitioned.toString());
        List matchedData = df.select("data", new String[0]).where("data LIKE 'jun%'").as(Encoders.STRING()).collectAsList();
        Assert.assertEquals((long)1L, (long)matchedData.size());
        Assert.assertEquals((Object)"junction", matchedData.get(0));
    }

    @Test
    public void testUnpartitionedNotStartsWith() {
        Dataset df = spark.read().format("iceberg").option("vectorization-enabled", String.valueOf(this.vectorized)).load(this.unpartitioned.toString());
        List matchedData = df.select("data", new String[0]).where("data NOT LIKE 'jun%'").as(Encoders.STRING()).collectAsList();
        List expected = this.testRecords(SCHEMA).stream().map(r -> r.getField("data").toString()).filter(d -> !d.startsWith("jun")).collect(Collectors.toList());
        Assert.assertEquals((long)9L, (long)matchedData.size());
        Assert.assertEquals((Object)Sets.newHashSet(expected), (Object)Sets.newHashSet((Iterable)matchedData));
    }

    private static Record projectFlat(Schema projection, Record record) {
        GenericRecord result = GenericRecord.create((Schema)projection);
        List fields = projection.asStruct().fields();
        for (int i = 0; i < fields.size(); ++i) {
            Types.NestedField field = (Types.NestedField)fields.get(i);
            result.set(i, record.getField(field.name()));
        }
        return result;
    }

    public static void assertEqualsUnsafe(Types.StructType struct, List<Record> expected, List<UnsafeRow> actual) {
        int numRecords = Math.min(expected.size(), actual.size());
        for (int i = 0; i < numRecords; ++i) {
            GenericsHelpers.assertEqualsUnsafe(struct, expected.get(i), (InternalRow)actual.get(i));
        }
        Assert.assertEquals((String)"Number of results should match expected", (long)expected.size(), (long)actual.size());
    }

    public static void assertEqualsSafe(Types.StructType struct, List<Record> expected, List<Row> actual) {
        int numRecords = Math.min(expected.size(), actual.size());
        for (int i = 0; i < numRecords; ++i) {
            GenericsHelpers.assertEqualsSafe(struct, expected.get(i), actual.get(i));
        }
        Assert.assertEquals((String)"Number of results should match expected", (long)expected.size(), (long)actual.size());
    }

    private List<Record> expected(int ... ordinals) {
        ArrayList expected = Lists.newArrayListWithExpectedSize((int)ordinals.length);
        for (int ord : ordinals) {
            expected.add(this.records.get(ord));
        }
        return expected;
    }

    private void pushFilters(ScanBuilder scan, Filter ... filters) {
        Assertions.assertThat((Object)scan).isInstanceOf(SupportsPushDownFilters.class);
        SupportsPushDownFilters filterable = (SupportsPushDownFilters)scan;
        filterable.pushFilters(filters);
    }

    private Table buildPartitionedTable(String desc, PartitionSpec spec, String udf, String partitionColumn) {
        File location = new File(this.parent, desc);
        Table table = TABLES.create(SCHEMA, spec, location.toString());
        table.updateProperties().set("read.split.target-size", "2048").commit();
        Dataset allRows = spark.read().format("iceberg").option("vectorization-enabled", String.valueOf(this.vectorized)).load(this.unpartitioned.toString());
        allRows.coalesce(1).withColumn("part", functions.callUDF((String)udf, (Column[])new Column[]{functions.column((String)partitionColumn)})).sortWithinPartitions("part", new String[0]).drop("part").write().format("iceberg").mode("append").save(table.location());
        table.refresh();
        return table;
    }

    private List<Record> testRecords(Schema schema) {
        return Lists.newArrayList((Object[])new Record[]{TestFilteredScan.record(schema, 0L, TestFilteredScan.parse("2017-12-22T09:20:44.294658+00:00"), "junction"), TestFilteredScan.record(schema, 1L, TestFilteredScan.parse("2017-12-22T07:15:34.582910+00:00"), "alligator"), TestFilteredScan.record(schema, 2L, TestFilteredScan.parse("2017-12-22T06:02:09.243857+00:00"), ""), TestFilteredScan.record(schema, 3L, TestFilteredScan.parse("2017-12-22T03:10:11.134509+00:00"), "clapping"), TestFilteredScan.record(schema, 4L, TestFilteredScan.parse("2017-12-22T00:34:00.184671+00:00"), "brush"), TestFilteredScan.record(schema, 5L, TestFilteredScan.parse("2017-12-21T22:20:08.935889+00:00"), "trap"), TestFilteredScan.record(schema, 6L, TestFilteredScan.parse("2017-12-21T21:55:30.589712+00:00"), "element"), TestFilteredScan.record(schema, 7L, TestFilteredScan.parse("2017-12-21T17:31:14.532797+00:00"), "limited"), TestFilteredScan.record(schema, 8L, TestFilteredScan.parse("2017-12-21T15:21:51.237521+00:00"), "global"), TestFilteredScan.record(schema, 9L, TestFilteredScan.parse("2017-12-21T15:02:15.230570+00:00"), "goldfish")});
    }

    private static List<Row> read(String table, boolean vectorized, String expr) {
        return TestFilteredScan.read(table, vectorized, expr, "*", new String[0]);
    }

    private static List<Row> read(String table, boolean vectorized, String expr, String select0, String ... selectN) {
        Dataset dataset = spark.read().format("iceberg").option("vectorization-enabled", String.valueOf(vectorized)).load(table).filter(expr).select(select0, selectN);
        return dataset.collectAsList();
    }

    private static OffsetDateTime parse(String timestamp) {
        return OffsetDateTime.parse(timestamp);
    }

    private static Record record(Schema schema, Object ... values) {
        GenericRecord rec = GenericRecord.create((Schema)schema);
        for (int i = 0; i < values.length; ++i) {
            rec.set(i, values[i]);
        }
        return rec;
    }

    private static /* synthetic */ Integer lambda$startSpark$5001b11d$1(Function hour, Timestamp timestamp) throws Exception {
        return (Integer)hour.apply(DateTimeUtils.fromJavaTimestamp((Timestamp)timestamp));
    }

    private static /* synthetic */ Integer lambda$startSpark$9f79e71b$1(Function day, Timestamp timestamp) throws Exception {
        return (Integer)day.apply(DateTimeUtils.fromJavaTimestamp((Timestamp)timestamp));
    }
}

