/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestMetadataTableReadableMetrics
extends SparkTestBaseWithCatalog {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static final Types.StructType LEAF_STRUCT_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"leafLongCol", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"leafDoubleCol", (Type)Types.DoubleType.get())});
    private static final Types.StructType NESTED_STRUCT_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"leafStructCol", (Type)LEAF_STRUCT_TYPE)});
    private static final Schema NESTED_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)4, (String)"nestedStructCol", (Type)NESTED_STRUCT_TYPE)});
    private static final Schema PRIMITIVE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"booleanCol", (Type)Types.BooleanType.get()), Types.NestedField.required((int)2, (String)"intCol", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"longCol", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"floatCol", (Type)Types.FloatType.get()), Types.NestedField.required((int)5, (String)"doubleCol", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)6, (String)"decimalCol", (Type)Types.DecimalType.of((int)10, (int)2)), Types.NestedField.optional((int)7, (String)"stringCol", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"fixedCol", (Type)Types.FixedType.ofLength((int)3)), Types.NestedField.optional((int)9, (String)"binaryCol", (Type)Types.BinaryType.get())});

    public TestMetadataTableReadableMetrics() {
        super(SparkCatalogConfig.HIVE);
    }

    protected String tableName() {
        return this.tableName.split("\\.")[2];
    }

    protected String database() {
        return this.tableName.split("\\.")[1];
    }

    private Table createPrimitiveTable() throws IOException {
        Table table = catalog.createTable(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{this.database()}), (String)this.tableName()), PRIMITIVE_SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of());
        ArrayList records = Lists.newArrayList((Object[])new Record[]{this.createPrimitiveRecord(false, 1, 1L, 0.0f, 1.0, new BigDecimal("1.00"), "1", Base64.getDecoder().decode("1111"), ByteBuffer.wrap(Base64.getDecoder().decode("1111"))), this.createPrimitiveRecord(true, 2, 2L, 0.0f, 2.0, new BigDecimal("2.00"), "2", Base64.getDecoder().decode("2222"), ByteBuffer.wrap(Base64.getDecoder().decode("2222"))), this.createPrimitiveRecord(false, 1, 1L, Float.NaN, Double.NaN, null, "1", null, null), this.createPrimitiveRecord(false, 2, 2L, Float.NaN, 2.0, new BigDecimal("2.00"), "2", null, null)});
        DataFile dataFile = FileHelpers.writeDataFile((Table)table, (OutputFile)Files.localOutput((File)this.temp.newFile()), (List)records);
        table.newAppend().appendFile(dataFile).commit();
        return table;
    }

    private Pair<Table, DataFile> createNestedTable() throws IOException {
        Table table = catalog.createTable(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{this.database()}), (String)this.tableName()), NESTED_SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of());
        ArrayList records = Lists.newArrayList((Object[])new Record[]{this.createNestedRecord(0L, 0.0), this.createNestedRecord(1L, Double.NaN), this.createNestedRecord(null, null)});
        DataFile dataFile = FileHelpers.writeDataFile((Table)table, (OutputFile)Files.localOutput((File)this.temp.newFile()), (List)records);
        table.newAppend().appendFile(dataFile).commit();
        return Pair.of((Object)table, (Object)dataFile);
    }

    @After
    public void dropTable() {
        this.sql("DROP TABLE %s", this.tableName);
    }

    private Dataset<Row> filesDf() {
        return spark.read().format("iceberg").load(this.database() + "." + this.tableName() + ".files");
    }

    protected GenericRecord createPrimitiveRecord(boolean booleanCol, int intCol, long longCol, float floatCol, double doubleCol, BigDecimal decimalCol, String stringCol, byte[] fixedCol, ByteBuffer binaryCol) {
        GenericRecord record = GenericRecord.create((Schema)PRIMITIVE_SCHEMA);
        record.set(0, (Object)booleanCol);
        record.set(1, (Object)intCol);
        record.set(2, (Object)longCol);
        record.set(3, (Object)Float.valueOf(floatCol));
        record.set(4, (Object)doubleCol);
        record.set(5, (Object)decimalCol);
        record.set(6, (Object)stringCol);
        record.set(7, (Object)fixedCol);
        record.set(8, (Object)binaryCol);
        return record;
    }

    private GenericRecord createNestedRecord(Long longCol, Double doubleCol) {
        GenericRecord record = GenericRecord.create((Schema)NESTED_SCHEMA);
        GenericRecord nested = GenericRecord.create((Types.StructType)NESTED_STRUCT_TYPE);
        GenericRecord leaf = GenericRecord.create((Types.StructType)LEAF_STRUCT_TYPE);
        leaf.set(0, (Object)longCol);
        leaf.set(1, (Object)doubleCol);
        nested.set(0, (Object)leaf);
        record.set(0, (Object)nested);
        return record;
    }

    @Test
    public void testPrimitiveColumns() throws Exception {
        Table table = this.createPrimitiveTable();
        DataFile dataFile = (DataFile)table.currentSnapshot().addedDataFiles(table.io()).iterator().next();
        Map columnSizeStats = dataFile.columnSizes();
        Object[] binaryCol = this.row(columnSizeStats.get(PRIMITIVE_SCHEMA.findField("binaryCol").fieldId()), 4L, 2L, null, Base64.getDecoder().decode("1111"), Base64.getDecoder().decode("2222"));
        Object[] booleanCol = this.row(columnSizeStats.get(PRIMITIVE_SCHEMA.findField("booleanCol").fieldId()), 4L, 0L, null, false, true);
        Object[] decimalCol = this.row(columnSizeStats.get(PRIMITIVE_SCHEMA.findField("decimalCol").fieldId()), 4L, 1L, null, new BigDecimal("1.00"), new BigDecimal("2.00"));
        Object[] doubleCol = this.row(columnSizeStats.get(PRIMITIVE_SCHEMA.findField("doubleCol").fieldId()), 4L, 0L, 1L, 1.0, 2.0);
        Object[] fixedCol = this.row(columnSizeStats.get(PRIMITIVE_SCHEMA.findField("fixedCol").fieldId()), 4L, 2L, null, Base64.getDecoder().decode("1111"), Base64.getDecoder().decode("2222"));
        Object[] floatCol = this.row(columnSizeStats.get(PRIMITIVE_SCHEMA.findField("floatCol").fieldId()), 4L, 0L, 2L, Float.valueOf(0.0f), Float.valueOf(0.0f));
        Object[] intCol = this.row(columnSizeStats.get(PRIMITIVE_SCHEMA.findField("intCol").fieldId()), 4L, 0L, null, 1, 2);
        Object[] longCol = this.row(columnSizeStats.get(PRIMITIVE_SCHEMA.findField("longCol").fieldId()), 4L, 0L, null, 1L, 2L);
        Object[] stringCol = this.row(columnSizeStats.get(PRIMITIVE_SCHEMA.findField("stringCol").fieldId()), 4L, 0L, null, "1", "2");
        Object[] metrics = this.row(binaryCol, booleanCol, decimalCol, doubleCol, fixedCol, floatCol, intCol, longCol, stringCol);
        this.assertEquals("Row should match", (List<Object[]>)ImmutableList.of((Object)new Object[]{metrics}), this.sql("SELECT readable_metrics FROM %s.files", this.tableName));
    }

    @Test
    public void testSelectPrimitiveValues() throws Exception {
        this.createPrimitiveTable();
        this.assertEquals("select of primitive readable_metrics fields should work", (List<Object[]>)ImmutableList.of((Object)this.row(1, true)), this.sql("SELECT readable_metrics.intCol.lower_bound, readable_metrics.booleanCol.upper_bound FROM %s.files", this.tableName));
        this.assertEquals("mixed select of readable_metrics and other field should work", (List<Object[]>)ImmutableList.of((Object)this.row(0, 4L)), this.sql("SELECT content, readable_metrics.longCol.value_count FROM %s.files", this.tableName));
        this.assertEquals("mixed select of readable_metrics and other field should work, in the other order", (List<Object[]>)ImmutableList.of((Object)this.row(4L, 0)), this.sql("SELECT readable_metrics.longCol.value_count, content FROM %s.files", this.tableName));
    }

    @Test
    public void testSelectNestedValues() throws Exception {
        this.createNestedTable();
        this.assertEquals("select of nested readable_metrics fields should work", (List<Object[]>)ImmutableList.of((Object)this.row(0L, 3L)), this.sql("SELECT readable_metrics.`nestedStructCol.leafStructCol.leafLongCol`.lower_bound, readable_metrics.`nestedStructCol.leafStructCol.leafDoubleCol`.value_count FROM %s.files", this.tableName));
    }

    @Test
    public void testNestedValues() throws Exception {
        Pair<Table, DataFile> table = this.createNestedTable();
        int longColId = ((Table)table.first()).schema().findField("nestedStructCol.leafStructCol.leafLongCol").fieldId();
        int doubleColId = ((Table)table.first()).schema().findField("nestedStructCol.leafStructCol.leafDoubleCol").fieldId();
        Object[] leafDoubleCol = this.row(((DataFile)table.second()).columnSizes().get(doubleColId), 3L, 1L, 1L, 0.0, 0.0);
        Object[] leafLongCol = this.row(((DataFile)table.second()).columnSizes().get(longColId), 3L, 1L, null, 0L, 1L);
        Object[] metrics = this.row(leafDoubleCol, leafLongCol);
        ImmutableList expected = ImmutableList.of((Object)new Object[]{metrics});
        String sql = "SELECT readable_metrics FROM %s.%s";
        List<Object[]> filesReadableMetrics = this.sql(String.format(sql, this.tableName, "files"), new Object[0]);
        List<Object[]> entriesReadableMetrics = this.sql(String.format(sql, this.tableName, "entries"), new Object[0]);
        this.assertEquals("Row should match for files table", (List<Object[]>)expected, filesReadableMetrics);
        this.assertEquals("Row should match for entries table", (List<Object[]>)expected, entriesReadableMetrics);
    }
}

