/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.spark.data.AvroDataTest;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestParquetScan
extends AvroDataTest {
    private static final Configuration CONF = new Configuration();
    private static SparkSession spark = null;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private final boolean vectorized;

    @BeforeClass
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
    }

    @AfterClass
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        currentSpark.stop();
    }

    @Parameterized.Parameters(name="vectorized = {0}")
    public static Object[] parameters() {
        return new Object[]{false, true};
    }

    public TestParquetScan(boolean vectorized) {
        this.vectorized = vectorized;
    }

    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        Assume.assumeTrue((String)"Cannot handle non-string map keys in parquet-avro", (null == TypeUtil.find((Schema)schema, type -> type.isMapType() && type.asMapType().keyType() != Types.StringType.get()) ? 1 : 0) != 0);
        File parent = this.temp.newFolder("parquet");
        File location = new File(parent, "test");
        File dataFolder = new File(location, "data");
        dataFolder.mkdirs();
        File parquetFile = new File(dataFolder, FileFormat.PARQUET.addExtension(UUID.randomUUID().toString()));
        HadoopTables tables = new HadoopTables(CONF);
        Table table = tables.create(schema, PartitionSpec.unpartitioned(), location.toString());
        Schema tableSchema = table.schema();
        List<GenericData.Record> expected = RandomData.generateList(tableSchema, 100, 1L);
        try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)parquetFile)).schema(tableSchema).build();){
            writer.addAll(expected);
        }
        DataFile file = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withFileSizeInBytes(parquetFile.length()).withPath(parquetFile.toString()).withRecordCount(100L).build();
        table.newAppend().appendFile(file).commit();
        table.updateProperties().set("read.parquet.vectorization.enabled", String.valueOf(this.vectorized)).commit();
        Dataset df = spark.read().format("iceberg").load(location.toString());
        List rows = df.collectAsList();
        Assert.assertEquals((String)"Should contain 100 rows", (long)100L, (long)rows.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestHelpers.assertEqualsSafe(tableSchema.asStruct(), expected.get(i), (Row)rows.get(i));
        }
    }
}

