/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.TestAppenderFactory;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.InternalRowWrapper;
import org.apache.iceberg.spark.source.SparkAppenderFactory;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class TestSparkAppenderFactory
extends TestAppenderFactory<InternalRow> {
    private final StructType sparkType = SparkSchemaUtil.convert((Schema)SCHEMA);

    public TestSparkAppenderFactory(String fileFormat, boolean partitioned) {
        super(fileFormat, partitioned);
    }

    protected FileAppenderFactory<InternalRow> createAppenderFactory(List<Integer> equalityFieldIds, Schema eqDeleteSchema, Schema posDeleteRowSchema) {
        return SparkAppenderFactory.builderFor((Table)this.table, (Schema)this.table.schema(), (StructType)this.sparkType).equalityFieldIds(ArrayUtil.toIntArray(equalityFieldIds)).eqDeleteRowSchema(eqDeleteSchema).posDelRowSchema(posDeleteRowSchema).build();
    }

    protected InternalRow createRow(Integer id, String data) {
        GenericInternalRow row = new GenericInternalRow(2);
        row.update(0, (Object)id);
        row.update(1, (Object)UTF8String.fromString((String)data));
        return row;
    }

    protected StructLikeSet expectedRowSet(Iterable<InternalRow> rows) {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        for (InternalRow row : rows) {
            InternalRowWrapper wrapper = new InternalRowWrapper(this.sparkType);
            set.add((StructLike)wrapper.wrap(row));
        }
        return set;
    }
}

