/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.KryoHelpers;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TestSparkCatalogHadoopOverrides
extends SparkCatalogTestBase {
    private static final String configToOverride = "fs.s3a.buffer.dir";
    private static final String hadoopPrefixedConfigToOverride = "hadoop.fs.s3a.buffer.dir";
    private static final String configOverrideValue = "/tmp-overridden";

    @Parameterized.Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"testhive", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)hadoopPrefixedConfigToOverride, (Object)configOverrideValue)}, {"testhadoop", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hadoop", (Object)hadoopPrefixedConfigToOverride, (Object)configOverrideValue)}, {"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)hadoopPrefixedConfigToOverride, (Object)configOverrideValue)}};
    }

    public TestSparkCatalogHadoopOverrides(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Before
    public void createTable() {
        this.sql("CREATE TABLE IF NOT EXISTS %s (id bigint) USING iceberg", this.tableName(this.tableIdent.name()));
    }

    @After
    public void dropTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName(this.tableIdent.name()));
    }

    @Test
    public void testTableFromCatalogHasOverrides() throws Exception {
        Table table = this.getIcebergTableFromSparkCatalog();
        Configuration conf = ((Configurable)table.io()).getConf();
        String actualCatalogOverride = conf.get(configToOverride, "/whammies");
        Assert.assertEquals((String)"Iceberg tables from spark should have the overridden hadoop configurations from the spark config", (Object)configOverrideValue, (Object)actualCatalogOverride);
    }

    @Test
    public void ensureRoundTripSerializedTableRetainsHadoopConfig() throws Exception {
        Table table = this.getIcebergTableFromSparkCatalog();
        Configuration originalConf = ((Configurable)table.io()).getConf();
        String actualCatalogOverride = originalConf.get(configToOverride, "/whammies");
        Assert.assertEquals((String)"Iceberg tables from spark should have the overridden hadoop configurations from the spark config", (Object)configOverrideValue, (Object)actualCatalogOverride);
        Table serializableTable = SerializableTableWithSize.copyOf((Table)table);
        Table kryoSerializedTable = KryoHelpers.roundTripSerialize(SerializableTableWithSize.copyOf((Table)table));
        Configuration configFromKryoSerde = ((Configurable)kryoSerializedTable.io()).getConf();
        String kryoSerializedCatalogOverride = configFromKryoSerde.get(configToOverride, "/whammies");
        Assert.assertEquals((String)"Tables serialized with Kryo serialization should retain overridden hadoop configuration properties", (Object)configOverrideValue, (Object)kryoSerializedCatalogOverride);
        Table javaSerializedTable = (Table)TestHelpers.roundTripSerialize((Object)serializableTable);
        Configuration configFromJavaSerde = ((Configurable)javaSerializedTable.io()).getConf();
        String javaSerializedCatalogOverride = configFromJavaSerde.get(configToOverride, "/whammies");
        Assert.assertEquals((String)"Tables serialized with Java serialization should retain overridden hadoop configuration properties", (Object)configOverrideValue, (Object)javaSerializedCatalogOverride);
    }

    private Table getIcebergTableFromSparkCatalog() throws Exception {
        Identifier identifier = Identifier.of((String[])this.tableIdent.namespace().levels(), (String)this.tableIdent.name());
        TableCatalog catalog = (TableCatalog)spark.sessionState().catalogManager().catalog(this.catalogName);
        SparkTable sparkTable = (SparkTable)catalog.loadTable(identifier);
        return sparkTable.table();
    }
}

