/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkTestBase;
import org.apache.iceberg.spark.source.TestTables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.functions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSparkMetadataColumns
extends SparkTestBase {
    private static final String TABLE_NAME = "test_table";
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"category", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"data", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.unpartitioned();
    private static final PartitionSpec UNKNOWN_SPEC = TestHelpers.newExpectedSpecBuilder().withSchema(SCHEMA).withSpecId(1).addField("zero", 1, "id_zero").build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private final FileFormat fileFormat;
    private final boolean vectorized;
    private final int formatVersion;
    private Table table = null;

    @Parameterized.Parameters(name="fileFormat = {0}, vectorized = {1}, formatVersion = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{FileFormat.PARQUET, false, 1}, {FileFormat.PARQUET, true, 1}, {FileFormat.PARQUET, false, 2}, {FileFormat.PARQUET, true, 2}, {FileFormat.AVRO, false, 1}, {FileFormat.AVRO, false, 2}, {FileFormat.ORC, false, 1}, {FileFormat.ORC, true, 1}, {FileFormat.ORC, false, 2}, {FileFormat.ORC, true, 2}};
    }

    public TestSparkMetadataColumns(FileFormat fileFormat, boolean vectorized, int formatVersion) {
        this.fileFormat = fileFormat;
        this.vectorized = vectorized;
        this.formatVersion = formatVersion;
    }

    @BeforeClass
    public static void setupSpark() {
        ImmutableMap config = ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"cache-enabled", (Object)"true");
        spark.conf().set("spark.sql.catalog.spark_catalog", "org.apache.iceberg.spark.source.TestSparkCatalog");
        config.forEach((key, value) -> spark.conf().set("spark.sql.catalog.spark_catalog." + key, value));
    }

    @Before
    public void setupTable() throws IOException {
        this.createAndInitTable();
    }

    @After
    public void dropTable() {
        TestTables.clearTables();
    }

    @Test
    public void testSpecAndPartitionMetadataColumns() {
        Assume.assumeFalse((this.fileFormat == FileFormat.ORC && this.vectorized ? 1 : 0) != 0);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", TABLE_NAME);
        this.table.refresh();
        this.table.updateSpec().addField("data").commit();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", TABLE_NAME);
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"category", (int)8)).commit();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", TABLE_NAME);
        this.table.refresh();
        this.table.updateSpec().removeField("data").commit();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", TABLE_NAME);
        this.table.refresh();
        this.table.updateSpec().renameField("category_bucket_8", "category_bucket_8_another_name").commit();
        ImmutableList expected = ImmutableList.of((Object)this.row(0, this.row(null, null)), (Object)this.row(1, this.row("b1", null)), (Object)this.row(2, this.row("b1", 2)), (Object)this.row(3, this.row(null, 2)));
        this.assertEquals("Rows must match", (List<Object[]>)expected, this.sql("SELECT _spec_id, _partition FROM %s ORDER BY _spec_id", TABLE_NAME));
    }

    @Test
    public void testPositionMetadataColumnWithMultipleRowGroups() throws NoSuchTableException {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET ? 1 : 0) != 0);
        this.table.updateProperties().set("write.parquet.row-group-size-bytes", "100").commit();
        ArrayList ids = Lists.newArrayList();
        for (long id = 0L; id < 200L; ++id) {
            ids.add(id);
        }
        Dataset df = spark.createDataset((List)ids, Encoders.LONG()).withColumnRenamed("value", "id").withColumn("category", functions.lit((Object)"hr")).withColumn("data", functions.lit((Object)"ABCDEF"));
        df.coalesce(1).writeTo(TABLE_NAME).append();
        Assert.assertEquals((long)200L, (long)spark.table(TABLE_NAME).count());
        List<Object[]> expectedRows = ids.stream().map(xva$0 -> this.row(xva$0)).collect(Collectors.toList());
        this.assertEquals("Rows must match", expectedRows, this.sql("SELECT _pos FROM %s", TABLE_NAME));
    }

    @Test
    public void testPositionMetadataColumnWithMultipleBatches() throws NoSuchTableException {
        Assume.assumeTrue((this.fileFormat == FileFormat.PARQUET ? 1 : 0) != 0);
        this.table.updateProperties().set("read.parquet.vectorization.batch-size", "1000").commit();
        ArrayList ids = Lists.newArrayList();
        for (long id = 0L; id < 7500L; ++id) {
            ids.add(id);
        }
        Dataset df = spark.createDataset((List)ids, Encoders.LONG()).withColumnRenamed("value", "id").withColumn("category", functions.lit((Object)"hr")).withColumn("data", functions.lit((Object)"ABCDEF"));
        df.coalesce(1).writeTo(TABLE_NAME).append();
        Assert.assertEquals((long)7500L, (long)spark.table(TABLE_NAME).count());
        List<Object[]> expectedRows = ids.stream().map(xva$0 -> this.row(xva$0)).collect(Collectors.toList());
        this.assertEquals("Rows must match", expectedRows, this.sql("SELECT _pos FROM %s", TABLE_NAME));
    }

    @Test
    public void testPartitionMetadataColumnWithUnknownTransforms() {
        TableOperations ops = ((HasTableOperations)this.table).operations();
        TableMetadata base = ops.current();
        ops.commit(base, base.updatePartitionSpec(UNKNOWN_SPEC));
        AssertHelpers.assertThrows((String)"Should fail to query the partition metadata column", ValidationException.class, (String)"Cannot build table partition type, unknown transforms", () -> this.sql("SELECT _partition FROM %s", TABLE_NAME));
    }

    @Test
    public void testConflictingColumns() {
        this.table.updateSchema().addColumn(MetadataColumns.SPEC_ID.name(), (Type)Types.IntegerType.get()).addColumn(MetadataColumns.FILE_PATH.name(), (Type)Types.StringType.get()).commit();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1', -1, 'path/to/file')", TABLE_NAME);
        this.assertEquals("Rows must match", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a1")), this.sql("SELECT id, category FROM %s", TABLE_NAME));
        AssertHelpers.assertThrows((String)"Should fail to query conflicting columns", ValidationException.class, (String)"column names conflict", () -> this.sql("SELECT * FROM %s", TABLE_NAME));
        this.table.refresh();
        this.table.updateSchema().renameColumn(MetadataColumns.SPEC_ID.name(), "_renamed" + MetadataColumns.SPEC_ID.name()).renameColumn(MetadataColumns.FILE_PATH.name(), "_renamed" + MetadataColumns.FILE_PATH.name()).commit();
        this.assertEquals("Rows must match", (List<Object[]>)ImmutableList.of((Object)this.row(0, null, -1)), this.sql("SELECT _spec_id, _partition, _renamed_spec_id FROM %s", TABLE_NAME));
    }

    private void createAndInitTable() throws IOException {
        HashMap properties = Maps.newHashMap();
        properties.put("format-version", String.valueOf(this.formatVersion));
        properties.put("write.format.default", this.fileFormat.name());
        switch (this.fileFormat) {
            case PARQUET: {
                properties.put("read.parquet.vectorization.enabled", String.valueOf(this.vectorized));
                break;
            }
            case ORC: {
                properties.put("read.orc.vectorization.enabled", String.valueOf(this.vectorized));
                break;
            }
            default: {
                Preconditions.checkState((!this.vectorized ? 1 : 0) != 0, (String)"File format %s does not support vectorized reads", (Object)this.fileFormat);
            }
        }
        this.table = TestTables.create(this.temp.newFolder(), TABLE_NAME, SCHEMA, SPEC, properties);
    }
}

