/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.Files;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.DeleteReadTests;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkStructLike;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.SparkParquetWriters;
import org.apache.iceberg.spark.source.EqualityDeleteRowReader;
import org.apache.iceberg.spark.source.InternalRowWrapper;
import org.apache.iceberg.spark.source.SparkSQLExecutionHelper;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.iceberg.util.TableScanUtil;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestSparkReaderDeletes
extends DeleteReadTests {
    private static TestHiveMetastore metastore = null;
    protected static SparkSession spark = null;
    protected static HiveCatalog catalog = null;
    @Parameter
    private String format;
    @Parameter(index=1)
    private boolean vectorized;
    private static final Schema PROJECTION_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), MetadataColumns.IS_DELETED});

    @Parameters(name="format = {0}, vectorized = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{"parquet", false}, {"parquet", true}, {"orc", false}, {"avro", false}};
    }

    @BeforeAll
    public static void startMetastoreAndSpark() {
        metastore = new TestHiveMetastore();
        metastore.start();
        HiveConf hiveConf = metastore.hiveConf();
        spark = SparkSession.builder().master("local[2]").config("spark.appStateStore.asyncTracking.enable", false).config("spark.ui.liveUpdate.period", 0L).config(SQLConf.PARTITION_OVERWRITE_MODE().key(), "dynamic").config("spark.hadoop." + HiveConf.ConfVars.METASTOREURIS.varname, hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname)).enableHiveSupport().getOrCreate();
        catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of(), (Object)hiveConf);
        try {
            catalog.createNamespace(Namespace.of((String[])new String[]{"default"}));
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    @AfterAll
    public static void stopMetastoreAndSpark() throws Exception {
        catalog = null;
        metastore.stop();
        metastore = null;
        spark.stop();
        spark = null;
    }

    @AfterEach
    public void cleanup() throws IOException {
        super.cleanup();
        this.dropTable("test3");
    }

    protected Table createTable(String name, Schema schema, PartitionSpec spec) {
        Table table = catalog.createTable(TableIdentifier.of((String[])new String[]{"default", name}), schema);
        TableOperations ops = ((BaseTable)table).operations();
        TableMetadata meta = ops.current();
        ops.commit(meta, meta.upgradeToFormatVersion(2));
        table.updateProperties().set("write.format.default", this.format).commit();
        if (this.format.equals("parquet") || this.format.equals("orc")) {
            String vectorizationEnabled = this.format.equals("parquet") ? "read.parquet.vectorization.enabled" : "read.orc.vectorization.enabled";
            String batchSize = this.format.equals("parquet") ? "read.parquet.vectorization.batch-size" : "read.orc.vectorization.batch-size";
            table.updateProperties().set(vectorizationEnabled, String.valueOf(this.vectorized)).commit();
            if (this.vectorized) {
                table.updateProperties().set(batchSize, "4").commit();
            }
        }
        return table;
    }

    protected void dropTable(String name) {
        catalog.dropTable(TableIdentifier.of((String[])new String[]{"default", name}));
    }

    protected boolean countDeletes() {
        return true;
    }

    protected long deleteCount() {
        return Long.parseLong(SparkSQLExecutionHelper.lastExecutedMetricValue(spark, "number of row deletes applied"));
    }

    public StructLikeSet rowSet(String name, Table table, String ... columns) {
        return this.rowSet(name, table.schema().select(columns).asStruct(), columns);
    }

    public StructLikeSet rowSet(String name, Types.StructType projection, String ... columns) {
        Dataset df = spark.read().format("iceberg").load(TableIdentifier.of((String[])new String[]{"default", name}).toString()).selectExpr(columns);
        StructLikeSet set = StructLikeSet.create((Types.StructType)projection);
        df.collectAsList().forEach(row -> {
            SparkStructLike rowWrapper = new SparkStructLike(projection);
            set.add((StructLike)rowWrapper.wrap(row));
        });
        return set;
    }

    @TestTemplate
    public void testEqualityDeleteWithFilter() throws IOException {
        String tableName = this.table.name().substring(this.table.name().lastIndexOf(".") + 1);
        Schema deleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)dataDeletes, (Schema)deleteRowSchema);
        this.table.newRowDelta().addDeletes(eqDeletes).commit();
        Types.StructType projection = this.table.schema().select(new String[]{"*"}).asStruct();
        Dataset df = spark.read().format("iceberg").load(TableIdentifier.of((String[])new String[]{"default", tableName}).toString()).filter("data = 'a'").selectExpr(new String[]{"*"});
        StructLikeSet actual = StructLikeSet.create((Types.StructType)projection);
        df.collectAsList().forEach(row -> {
            SparkStructLike rowWrapper = new SparkStructLike(projection);
            actual.add((StructLike)rowWrapper.wrap(row));
        });
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain no rows", new Object[0])).hasSize(0);
    }

    @TestTemplate
    public void testReadEqualityDeleteRows() throws IOException {
        Schema deleteSchema1 = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteSchema1);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d")});
        Schema deleteSchema2 = this.table.schema().select(new String[]{"id"});
        GenericRecord idDelete = GenericRecord.create((Schema)deleteSchema2);
        ArrayList idDeletes = Lists.newArrayList((Object[])new Record[]{idDelete.copy("id", (Object)121), idDelete.copy("id", (Object)122)});
        DeleteFile eqDelete1 = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)dataDeletes, (Schema)deleteSchema1);
        DeleteFile eqDelete2 = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)idDeletes, (Schema)deleteSchema2);
        this.table.newRowDelta().addDeletes(eqDelete1).addDeletes(eqDelete2).commit();
        StructLikeSet expectedRowSet = this.rowSetWithIds(new int[]{29, 89, 121, 122});
        Types.StructType type = this.table.schema().asStruct();
        StructLikeSet actualRowSet = StructLikeSet.create((Types.StructType)type);
        CloseableIterable tasks = TableScanUtil.planTasks((CloseableIterable)this.table.newScan().planFiles(), (long)0x2000000L, (int)10, (long)0x400000L);
        for (CombinedScanTask task : tasks) {
            try (EqualityDeleteRowReader reader = new EqualityDeleteRowReader(task, this.table, null, this.table.schema(), false);){
                while (reader.next()) {
                    actualRowSet.add((StructLike)new InternalRowWrapper(SparkSchemaUtil.convert((Schema)this.table.schema())).wrap(((InternalRow)reader.get()).copy()));
                }
            }
        }
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actualRowSet).as("should include 4 deleted row", new Object[0])).hasSize(4);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actualRowSet).as("deleted row should be matched", new Object[0])).isEqualTo((Object)expectedRowSet);
    }

    @TestTemplate
    public void testPosDeletesAllRowsInBatch() throws IOException {
        ArrayList deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile.path(), (Object)0L), Pair.of((Object)this.dataFile.path(), (Object)1L), Pair.of((Object)this.dataFile.path(), (Object)2L), Pair.of((Object)this.dataFile.path(), (Object)3L)});
        Pair posDeletes = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)deletes);
        this.table.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        StructLikeSet expected = TestSparkReaderDeletes.rowSetWithoutIds((Table)this.table, (List)this.records, (int[])new int[]{29, 43, 61, 89});
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(4L);
    }

    @TestTemplate
    public void testPosDeletesWithDeletedColumn() throws IOException {
        ArrayList deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile.path(), (Object)0L), Pair.of((Object)this.dataFile.path(), (Object)1L), Pair.of((Object)this.dataFile.path(), (Object)2L), Pair.of((Object)this.dataFile.path(), (Object)3L)});
        Pair posDeletes = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)deletes);
        this.table.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        StructLikeSet expected = TestSparkReaderDeletes.expectedRowSet(29, 43, 61, 89);
        StructLikeSet actual = this.rowSet(this.tableName, PROJECTION_SCHEMA.asStruct(), "id", "data", "_deleted");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected row", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(4L);
    }

    @TestTemplate
    public void testEqualityDeleteWithDeletedColumn() throws IOException {
        String tableName = this.table.name().substring(this.table.name().lastIndexOf(".") + 1);
        Schema deleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)dataDeletes, (Schema)deleteRowSchema);
        this.table.newRowDelta().addDeletes(eqDeletes).commit();
        StructLikeSet expected = TestSparkReaderDeletes.expectedRowSet(29, 89, 122);
        StructLikeSet actual = this.rowSet(tableName, PROJECTION_SCHEMA.asStruct(), "id", "data", "_deleted");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected row", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(3L);
    }

    @TestTemplate
    public void testMixedPosAndEqDeletesWithDeletedColumn() throws IOException {
        Schema dataSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)dataSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)dataDeletes, (Schema)dataSchema);
        ArrayList deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile.path(), (Object)3L), Pair.of((Object)this.dataFile.path(), (Object)5L)});
        Pair posDeletes = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)deletes);
        this.table.newRowDelta().addDeletes(eqDeletes).addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        StructLikeSet expected = TestSparkReaderDeletes.expectedRowSet(29, 89, 121, 122);
        StructLikeSet actual = this.rowSet(this.tableName, PROJECTION_SCHEMA.asStruct(), "id", "data", "_deleted");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected row", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(4L);
    }

    @TestTemplate
    public void testFilterOnDeletedMetadataColumn() throws IOException {
        ArrayList deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile.path(), (Object)0L), Pair.of((Object)this.dataFile.path(), (Object)1L), Pair.of((Object)this.dataFile.path(), (Object)2L), Pair.of((Object)this.dataFile.path(), (Object)3L)});
        Pair posDeletes = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)deletes);
        this.table.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        StructLikeSet expected = TestSparkReaderDeletes.expectedRowSetWithNonDeletesOnly(29, 43, 61, 89);
        Dataset df = spark.read().format("iceberg").load(TableIdentifier.of((String[])new String[]{"default", this.tableName}).toString()).select("id", new String[]{"data", "_deleted"}).filter("_deleted = false");
        Types.StructType projection = PROJECTION_SCHEMA.asStruct();
        StructLikeSet actual = StructLikeSet.create((Types.StructType)projection);
        df.collectAsList().forEach(row -> {
            SparkStructLike rowWrapper = new SparkStructLike(projection);
            actual.add((StructLike)rowWrapper.wrap(row));
        });
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected row", new Object[0])).isEqualTo((Object)expected);
        StructLikeSet expectedDeleted = TestSparkReaderDeletes.expectedRowSetWithDeletesOnly(29, 43, 61, 89);
        df = spark.read().format("iceberg").load(TableIdentifier.of((String[])new String[]{"default", this.tableName}).toString()).select("id", new String[]{"data", "_deleted"}).filter("_deleted = true");
        StructLikeSet actualDeleted = StructLikeSet.create((Types.StructType)projection);
        df.collectAsList().forEach(row -> {
            SparkStructLike rowWrapper = new SparkStructLike(projection);
            actualDeleted.add((StructLike)rowWrapper.wrap(row));
        });
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actualDeleted).as("Table should contain expected row", new Object[0])).isEqualTo((Object)expectedDeleted);
    }

    @TestTemplate
    public void testIsDeletedColumnWithoutDeleteFile() {
        StructLikeSet expected = TestSparkReaderDeletes.expectedRowSet(new int[0]);
        StructLikeSet actual = this.rowSet(this.tableName, PROJECTION_SCHEMA.asStruct(), "id", "data", "_deleted");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected row", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(0L);
    }

    @TestTemplate
    public void testPosDeletesOnParquetFileWithMultipleRowGroups() throws IOException {
        Assumptions.assumeThat((String)this.format).isEqualTo("parquet");
        String tblName = "test3";
        Table tbl = this.createTable(tblName, SCHEMA, PartitionSpec.unpartitioned());
        ArrayList fileSplits = Lists.newArrayList();
        StructType sparkSchema = SparkSchemaUtil.convert((Schema)SCHEMA);
        Configuration conf = new Configuration();
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)testFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        Path testFilePath = new Path(testFile.getAbsolutePath());
        ParquetFileWriter parquetFileWriter = new ParquetFileWriter(conf, ParquetSchemaUtil.convert((Schema)SCHEMA, (String)"test3Schema"), testFilePath);
        parquetFileWriter.start();
        for (int i = 0; i < 2; ++i) {
            File split = File.createTempFile("junit", null, this.temp.toFile());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)split.delete()).as("Delete should succeed", new Object[0])).isTrue();
            Path splitPath = new Path(split.getAbsolutePath());
            fileSplits.add(splitPath);
            try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)split)).createWriterFunc(msgType -> SparkParquetWriters.buildWriter((StructType)sparkSchema, (MessageType)msgType)).schema(SCHEMA).overwrite().build();){
                Iterable<InternalRow> records = RandomData.generateSpark(SCHEMA, 100, 34 * i + 37);
                writer.addAll(records);
            }
            parquetFileWriter.appendFile((org.apache.parquet.io.InputFile)HadoopInputFile.fromPath((Path)splitPath, (Configuration)conf));
        }
        parquetFileWriter.end(ParquetFileWriter.mergeMetadataFiles((List)fileSplits, (Configuration)conf).getFileMetaData().getKeyValueMetaData());
        DataFile dataFile = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withInputFile((InputFile)org.apache.iceberg.hadoop.HadoopInputFile.fromPath((Path)testFilePath, (Configuration)conf)).withFormat("parquet").withRecordCount(200L).build();
        tbl.newAppend().appendFile(dataFile).commit();
        ArrayList deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)dataFile.path(), (Object)97L), Pair.of((Object)dataFile.path(), (Object)98L), Pair.of((Object)dataFile.path(), (Object)99L), Pair.of((Object)dataFile.path(), (Object)101L), Pair.of((Object)dataFile.path(), (Object)103L), Pair.of((Object)dataFile.path(), (Object)107L), Pair.of((Object)dataFile.path(), (Object)109L)});
        Pair posDeletes = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (List)deletes);
        tbl.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        Assertions.assertThat((Collection)this.rowSet(tblName, tbl, "*")).hasSize(193);
    }

    private static StructLikeSet expectedRowSet(int ... idsToRemove) {
        return TestSparkReaderDeletes.expectedRowSet(false, false, idsToRemove);
    }

    private static StructLikeSet expectedRowSetWithDeletesOnly(int ... idsToRemove) {
        return TestSparkReaderDeletes.expectedRowSet(false, true, idsToRemove);
    }

    private static StructLikeSet expectedRowSetWithNonDeletesOnly(int ... idsToRemove) {
        return TestSparkReaderDeletes.expectedRowSet(true, false, idsToRemove);
    }

    private static StructLikeSet expectedRowSet(boolean removeDeleted, boolean removeNonDeleted, int ... idsToRemove) {
        HashSet deletedIds = Sets.newHashSet((Iterable)ArrayUtil.toIntList((int[])idsToRemove));
        List records = TestSparkReaderDeletes.recordsWithDeletedColumn();
        records.forEach(record -> {
            if (deletedIds.contains(record.getField("id"))) {
                record.setField(MetadataColumns.IS_DELETED.name(), (Object)true);
            }
        });
        records.removeIf(record -> deletedIds.contains(record.getField("id")) && removeDeleted);
        records.removeIf(record -> !deletedIds.contains(record.getField("id")) && removeNonDeleted);
        StructLikeSet set = StructLikeSet.create((Types.StructType)PROJECTION_SCHEMA.asStruct());
        records.forEach(record -> set.add((StructLike)new InternalRecordWrapper(PROJECTION_SCHEMA.asStruct()).wrap((StructLike)record)));
        return set;
    }

    @NotNull
    private static List recordsWithDeletedColumn() {
        ArrayList records = Lists.newArrayList();
        GenericRecord record = GenericRecord.create((Schema)PROJECTION_SCHEMA);
        records.add(record.copy("id", (Object)29, "data", (Object)"a", "_deleted", (Object)false));
        records.add(record.copy("id", (Object)43, "data", (Object)"b", "_deleted", (Object)false));
        records.add(record.copy("id", (Object)61, "data", (Object)"c", "_deleted", (Object)false));
        records.add(record.copy("id", (Object)89, "data", (Object)"d", "_deleted", (Object)false));
        records.add(record.copy("id", (Object)100, "data", (Object)"e", "_deleted", (Object)false));
        records.add(record.copy("id", (Object)121, "data", (Object)"f", "_deleted", (Object)false));
        records.add(record.copy("id", (Object)122, "data", (Object)"g", "_deleted", (Object)false));
        return records;
    }
}

