/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkValueConverter;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSparkReaderWithBloomFilter {
    protected String tableName = null;
    protected Table table = null;
    protected List<Record> records = null;
    protected DataFile dataFile = null;
    private static TestHiveMetastore metastore = null;
    protected static SparkSession spark = null;
    protected static HiveCatalog catalog = null;
    protected final boolean vectorized;
    protected final boolean useBloomFilter;
    public static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"id_long", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"id_double", (Type)Types.DoubleType.get()), Types.NestedField.required((int)4, (String)"id_float", (Type)Types.FloatType.get()), Types.NestedField.required((int)5, (String)"id_string", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"id_boolean", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)7, (String)"id_date", (Type)Types.DateType.get()), Types.NestedField.optional((int)8, (String)"id_int_decimal", (Type)Types.DecimalType.of((int)8, (int)2)), Types.NestedField.optional((int)9, (String)"id_long_decimal", (Type)Types.DecimalType.of((int)14, (int)2)), Types.NestedField.optional((int)10, (String)"id_fixed_decimal", (Type)Types.DecimalType.of((int)31, (int)2))});
    private static final int INT_MIN_VALUE = 30;
    private static final int INT_MAX_VALUE = 329;
    private static final int INT_VALUE_COUNT = 300;
    private static final long LONG_BASE = 1000L;
    private static final double DOUBLE_BASE = 10000.0;
    private static final float FLOAT_BASE = 100000.0f;
    private static final String BINARY_PREFIX = "BINARY\u6d4b\u8bd5_";
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    public TestSparkReaderWithBloomFilter(boolean vectorized, boolean useBloomFilter) {
        this.vectorized = vectorized;
        this.useBloomFilter = useBloomFilter;
    }

    @Before
    public void writeTestDataFile() throws IOException {
        this.tableName = "test";
        this.createTable(this.tableName, SCHEMA);
        this.records = Lists.newArrayList();
        GenericRecord record = GenericRecord.create((Schema)this.table.schema());
        for (int i = 0; i < 300; ++i) {
            this.records.add((Record)record.copy((Map)ImmutableMap.of((Object)"id", (Object)(30 + i), (Object)"id_long", (Object)(1030L + (long)i), (Object)"id_double", (Object)(10030.0 + (double)i), (Object)"id_float", (Object)Float.valueOf(100030.0f + (float)i), (Object)"id_string", (Object)(BINARY_PREFIX + (30 + i)), (Object)"id_boolean", (Object)(i % 2 == 0 ? 1 : 0), (Object)"id_date", (Object)LocalDate.parse("2021-09-05"), (Object)"id_int_decimal", (Object)new BigDecimal(String.valueOf(77.77)), (Object)"id_long_decimal", (Object)new BigDecimal(String.valueOf(88.88)), (Object)"id_fixed_decimal", (Object)new BigDecimal(String.valueOf(99.99)))));
        }
        this.dataFile = this.writeDataFile(Files.localOutput((File)this.temp.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), this.records);
        this.table.newAppend().appendFile(this.dataFile).commit();
    }

    @After
    public void cleanup() throws IOException {
        this.dropTable("test");
    }

    @Parameterized.Parameters(name="vectorized = {0}, useBloomFilter = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{false, false}, {true, false}, {false, true}, {true, true}};
    }

    @BeforeClass
    public static void startMetastoreAndSpark() {
        metastore = new TestHiveMetastore();
        metastore.start();
        HiveConf hiveConf = metastore.hiveConf();
        spark = SparkSession.builder().master("local[2]").config("spark.hadoop." + HiveConf.ConfVars.METASTOREURIS.varname, hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname)).enableHiveSupport().getOrCreate();
        catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of(), (Object)hiveConf);
        try {
            catalog.createNamespace(Namespace.of((String[])new String[]{"default"}));
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    @AfterClass
    public static void stopMetastoreAndSpark() throws Exception {
        catalog = null;
        metastore.stop();
        metastore = null;
        spark.stop();
        spark = null;
    }

    protected void createTable(String name, Schema schema) {
        this.table = catalog.createTable(TableIdentifier.of((String[])new String[]{"default", name}), schema);
        TableOperations ops = ((BaseTable)this.table).operations();
        TableMetadata meta = ops.current();
        ops.commit(meta, meta.upgradeToFormatVersion(2));
        if (this.useBloomFilter) {
            this.table.updateProperties().set("write.parquet.bloom-filter-enabled.column.id", "true").set("write.parquet.bloom-filter-enabled.column.id_long", "true").set("write.parquet.bloom-filter-enabled.column.id_double", "true").set("write.parquet.bloom-filter-enabled.column.id_float", "true").set("write.parquet.bloom-filter-enabled.column.id_string", "true").set("write.parquet.bloom-filter-enabled.column.id_boolean", "true").set("write.parquet.bloom-filter-enabled.column.id_date", "true").set("write.parquet.bloom-filter-enabled.column.id_int_decimal", "true").set("write.parquet.bloom-filter-enabled.column.id_long_decimal", "true").set("write.parquet.bloom-filter-enabled.column.id_fixed_decimal", "true").commit();
        }
        this.table.updateProperties().set("write.parquet.row-group-size-bytes", "100").commit();
        if (this.vectorized) {
            this.table.updateProperties().set("read.parquet.vectorization.enabled", "true").set("read.parquet.vectorization.batch-size", "4").commit();
        }
    }

    protected void dropTable(String name) {
        catalog.dropTable(TableIdentifier.of((String[])new String[]{"default", name}));
    }

    private DataFile writeDataFile(OutputFile out, StructLike partition, List<Record> rows) throws IOException {
        FileAppender writer;
        FileFormat format = this.defaultFormat(this.table.properties());
        GenericAppenderFactory factory = new GenericAppenderFactory(this.table.schema(), this.table.spec());
        boolean useBloomFilterCol1 = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"write.parquet.bloom-filter-enabled.column.id", (boolean)false);
        factory.set("write.parquet.bloom-filter-enabled.column.id", Boolean.toString(useBloomFilterCol1));
        boolean useBloomFilterCol2 = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"write.parquet.bloom-filter-enabled.column.id_long", (boolean)false);
        factory.set("write.parquet.bloom-filter-enabled.column.id_long", Boolean.toString(useBloomFilterCol2));
        boolean useBloomFilterCol3 = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"write.parquet.bloom-filter-enabled.column.id_double", (boolean)false);
        factory.set("write.parquet.bloom-filter-enabled.column.id_double", Boolean.toString(useBloomFilterCol3));
        boolean useBloomFilterCol4 = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"write.parquet.bloom-filter-enabled.column.id_float", (boolean)false);
        factory.set("write.parquet.bloom-filter-enabled.column.id_float", Boolean.toString(useBloomFilterCol4));
        boolean useBloomFilterCol5 = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"write.parquet.bloom-filter-enabled.column.id_string", (boolean)false);
        factory.set("write.parquet.bloom-filter-enabled.column.id_string", Boolean.toString(useBloomFilterCol5));
        boolean useBloomFilterCol6 = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"write.parquet.bloom-filter-enabled.column.id_boolean", (boolean)false);
        factory.set("write.parquet.bloom-filter-enabled.column.id_boolean", Boolean.toString(useBloomFilterCol6));
        boolean useBloomFilterCol7 = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"write.parquet.bloom-filter-enabled.column.id_date", (boolean)false);
        factory.set("write.parquet.bloom-filter-enabled.column.id_date", Boolean.toString(useBloomFilterCol7));
        boolean useBloomFilterCol8 = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"write.parquet.bloom-filter-enabled.column.id_int_decimal", (boolean)false);
        factory.set("write.parquet.bloom-filter-enabled.column.id_int_decimal", Boolean.toString(useBloomFilterCol8));
        boolean useBloomFilterCol9 = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"write.parquet.bloom-filter-enabled.column.id_long_decimal", (boolean)false);
        factory.set("write.parquet.bloom-filter-enabled.column.id_long_decimal", Boolean.toString(useBloomFilterCol9));
        boolean useBloomFilterCol10 = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"write.parquet.bloom-filter-enabled.column.id_fixed_decimal", (boolean)false);
        factory.set("write.parquet.bloom-filter-enabled.column.id_fixed_decimal", Boolean.toString(useBloomFilterCol10));
        int blockSize = PropertyUtil.propertyAsInt((Map)this.table.properties(), (String)"write.parquet.row-group-size-bytes", (int)0x8000000);
        factory.set("write.parquet.row-group-size-bytes", Integer.toString(blockSize));
        try (FileAppender toClose = writer = factory.newAppender(out, format);){
            writer.addAll(rows);
        }
        return DataFiles.builder((PartitionSpec)this.table.spec()).withFormat(format).withPath(out.location()).withPartition(partition).withFileSizeInBytes(writer.length()).withSplitOffsets(writer.splitOffsets()).withMetrics(writer.metrics()).build();
    }

    private FileFormat defaultFormat(Map<String, String> properties) {
        String formatString = properties.getOrDefault("write.format.default", "parquet");
        return FileFormat.fromString((String)formatString);
    }

    @Test
    public void testReadWithFilter() {
        Dataset df = spark.read().format("iceberg").load(TableIdentifier.of((String[])new String[]{"default", this.tableName}).toString()).filter("id = 30 AND id_long = 1030 AND id_double = 10030.0 AND id_float = 100030.0 AND id_string = 'BINARY\u6d4b\u8bd5_30' AND id_boolean = true AND id_date = '2021-09-05' AND id_int_decimal = 77.77 AND id_long_decimal = 88.88 AND id_fixed_decimal = 99.99");
        Record record = SparkValueConverter.convert((Schema)this.table.schema(), (Row)((Row)df.collectAsList().get(0)));
        Assert.assertEquals((String)"Table should contain 1 row", (long)1L, (long)df.collectAsList().size());
        Assert.assertEquals((String)"Table should contain expected rows", (Object)record.get(0), (Object)30);
        df = spark.read().format("iceberg").load(TableIdentifier.of((String[])new String[]{"default", this.tableName}).toString()).filter("id = 250 AND id_long = 1250 AND id_double = 10250.0 AND id_float = 100250.0 AND id_string = 'BINARY\u6d4b\u8bd5_250' AND id_boolean = true AND id_date = '2021-09-05' AND id_int_decimal = 77.77 AND id_long_decimal = 88.88 AND id_fixed_decimal = 99.99");
        record = SparkValueConverter.convert((Schema)this.table.schema(), (Row)((Row)df.collectAsList().get(0)));
        Assert.assertEquals((String)"Table should contain 1 row", (long)1L, (long)df.collectAsList().size());
        Assert.assertEquals((String)"Table should contain expected rows", (Object)record.get(0), (Object)250);
    }
}

