/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import org.apache.iceberg.Table;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.iceberg.spark.source.SparkScan;
import org.apache.iceberg.spark.source.SparkScanBuilder;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSparkScan
extends SparkTestBaseWithCatalog {
    private final String format;

    @Parameterized.Parameters(name="format = {0}")
    public static Object[] parameters() {
        return new Object[]{"parquet", "avro", "orc"};
    }

    public TestSparkScan(String format) {
        this.format = format;
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testEstimatedRowCount() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id BIGINT, date DATE) USING iceberg TBLPROPERTIES('%s' = '%s')", this.tableName, "write.format.default", this.format);
        Dataset df = spark.range(10000L).withColumn("date", functions.date_add((Column)functions.expr((String)"DATE '1970-01-01'"), (Column)functions.expr((String)"CAST(id AS INT)"))).select("id", new String[]{"date"});
        df.coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SparkScanBuilder scanBuilder = new SparkScanBuilder(spark, table, CaseInsensitiveStringMap.empty());
        SparkScan scan = (SparkScan)scanBuilder.build();
        Statistics stats = scan.estimateStatistics();
        Assert.assertEquals((long)10000L, (long)stats.numRows().getAsLong());
    }
}

