/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestAlterTable
extends SparkCatalogTestBase {
    private final TableIdentifier renamedIdent = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"default"}), (String)"table2");

    public TestAlterTable(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Before
    public void createTable() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", this.tableName);
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        this.sql("DROP TABLE IF EXISTS %s2", this.tableName);
    }

    @Test
    public void testAddColumnNotNull() {
        AssertHelpers.assertThrows((String)"Should reject adding NOT NULL column", SparkException.class, (String)"Incompatible change: cannot add required column", () -> this.sql("ALTER TABLE %s ADD COLUMN c3 INT NOT NULL", this.tableName));
    }

    @Test
    public void testAddColumn() {
        this.sql("ALTER TABLE %s ADD COLUMN point struct<x: double NOT NULL, y: double NOT NULL> AFTER id", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"point", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)5, (String)"y", (Type)Types.DoubleType.get())})), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
        this.sql("ALTER TABLE %s ADD COLUMN point.z double COMMENT 'May be null' FIRST", this.tableName);
        Types.StructType expectedSchema2 = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"point", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)6, (String)"z", (Type)Types.DoubleType.get(), (String)"May be null"), Types.NestedField.required((int)4, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)5, (String)"y", (Type)Types.DoubleType.get())})), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema2, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
    }

    @Test
    public void testAddColumnWithArray() {
        this.sql("ALTER TABLE %s ADD COLUMN data2 array<struct<a:INT,b:INT,c:int>>", this.tableName);
        this.sql("ALTER TABLE %s ADD COLUMN data2.element.d int", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"data2", (Type)Types.ListType.ofOptional((int)4, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)6, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)7, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)8, (String)"d", (Type)Types.IntegerType.get())})))});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
    }

    @Test
    public void testAddColumnWithMap() {
        this.sql("ALTER TABLE %s ADD COLUMN data2 map<struct<x:INT>, struct<a:INT,b:INT>>", this.tableName);
        this.sql("ALTER TABLE %s ADD COLUMN data2.value.c int", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"data2", (Type)Types.MapType.ofOptional((int)4, (int)5, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)6, (String)"x", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)7, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)8, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)9, (String)"c", (Type)Types.IntegerType.get())})))});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
        AssertHelpers.assertThrows((String)"Should reject changing key of the map column", SparkException.class, (String)"Unsupported table change: Cannot add fields to map keys:", () -> this.sql("ALTER TABLE %s ADD COLUMN data2.key.y int", this.tableName));
    }

    @Test
    public void testDropColumn() {
        this.sql("ALTER TABLE %s DROP COLUMN data", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
    }

    @Test
    public void testRenameColumn() {
        this.sql("ALTER TABLE %s RENAME COLUMN id TO row_id", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
    }

    @Test
    public void testAlterColumnComment() {
        this.sql("ALTER TABLE %s ALTER COLUMN id COMMENT 'Record id'", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get(), (String)"Record id"), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
    }

    @Test
    public void testAlterColumnType() {
        this.sql("ALTER TABLE %s ADD COLUMN count int", this.tableName);
        this.sql("ALTER TABLE %s ALTER COLUMN count TYPE bigint", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"count", (Type)Types.LongType.get())});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
    }

    @Test
    public void testAlterColumnDropNotNull() {
        this.sql("ALTER TABLE %s ALTER COLUMN id DROP NOT NULL", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
    }

    @Test
    public void testAlterColumnSetNotNull() {
        this.sql("ALTER TABLE %s ALTER COLUMN id SET NOT NULL", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
        AssertHelpers.assertThrows((String)"Should reject adding NOT NULL constraint to an optional column", AnalysisException.class, (String)"Cannot change nullable column to non-nullable: data", () -> this.sql("ALTER TABLE %s ALTER COLUMN data SET NOT NULL", this.tableName));
    }

    @Test
    public void testAlterColumnPositionAfter() {
        this.sql("ALTER TABLE %s ADD COLUMN count int", this.tableName);
        this.sql("ALTER TABLE %s ALTER COLUMN count AFTER id", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"count", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
    }

    @Test
    public void testAlterColumnPositionFirst() {
        this.sql("ALTER TABLE %s ADD COLUMN count int", this.tableName);
        this.sql("ALTER TABLE %s ALTER COLUMN count FIRST", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema, (Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct());
    }

    @Test
    public void testTableRename() {
        Assume.assumeFalse((String)"Hadoop catalog does not support rename", (boolean)(this.validationCatalog instanceof HadoopCatalog));
        Assert.assertTrue((String)"Initial name should exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        Assert.assertFalse((String)"New name should not exist", (boolean)this.validationCatalog.tableExists(this.renamedIdent));
        this.sql("ALTER TABLE %s RENAME TO %s2", this.tableName, this.tableName);
        Assert.assertFalse((String)"Initial name should not exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        Assert.assertTrue((String)"New name should exist", (boolean)this.validationCatalog.tableExists(this.renamedIdent));
    }

    @Test
    public void testSetTableProperties() {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('prop'='value')", this.tableName);
        Assert.assertEquals((String)"Should have the new table property", (Object)"value", this.validationCatalog.loadTable(this.tableIdent).properties().get("prop"));
        this.sql("ALTER TABLE %s UNSET TBLPROPERTIES ('prop')", this.tableName);
        Assert.assertNull((String)"Should not have the removed table property", this.validationCatalog.loadTable(this.tableIdent).properties().get("prop"));
        AssertHelpers.assertThrows((String)"Cannot specify the 'sort-order' because it's a reserved table property", UnsupportedOperationException.class, () -> this.sql("ALTER TABLE %s SET TBLPROPERTIES ('sort-order'='value')", this.tableName));
    }
}

