/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.io.File;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestCreateTable
extends SparkCatalogTestBase {
    public TestCreateTable(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void dropTestTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testTransformIgnoreCase() {
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE IF NOT EXISTS %s (id BIGINT NOT NULL, ts timestamp) USING iceberg partitioned by (HOURS(ts))", this.tableName);
        Assert.assertTrue((String)"Table should already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE IF NOT EXISTS %s (id BIGINT NOT NULL, ts timestamp) USING iceberg partitioned by (hours(ts))", this.tableName);
        Assert.assertTrue((String)"Table should already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
    }

    @Test
    public void testTransformSingularForm() {
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE IF NOT EXISTS %s (id BIGINT NOT NULL, ts timestamp) USING iceberg partitioned by (hour(ts))", this.tableName);
        Assert.assertTrue((String)"Table should exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
    }

    @Test
    public void testTransformPluralForm() {
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE IF NOT EXISTS %s (id BIGINT NOT NULL, ts timestamp) USING iceberg partitioned by (hours(ts))", this.tableName);
        Assert.assertTrue((String)"Table should exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
    }

    @Test
    public void testCreateTable() {
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertNotNull((String)"Should load the new table", (Object)table);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Should have the expected schema", (Object)expectedSchema, (Object)table.schema().asStruct());
        Assert.assertEquals((String)"Should not be partitioned", (long)0L, (long)table.spec().fields().size());
        Assert.assertNull((String)"Should not have the default format set", table.properties().get("write.format.default"));
    }

    @Test
    public void testCreateTableInRootNamespace() {
        Assume.assumeTrue((String)"Hadoop has no default namespace configured", (boolean)"testhadoop".equals(this.catalogName));
        try {
            this.sql("CREATE TABLE %s.table (id bigint) USING iceberg", this.catalogName);
        }
        catch (Throwable throwable) {
            this.sql("DROP TABLE IF EXISTS %s.table", this.catalogName);
            throw throwable;
        }
        this.sql("DROP TABLE IF EXISTS %s.table", this.catalogName);
    }

    @Test
    public void testCreateTableUsingParquet() {
        Assume.assumeTrue((String)"Not working with session catalog because Spark will not use v2 for a Parquet table", (!"spark_catalog".equals(this.catalogName) ? 1 : 0) != 0);
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING parquet", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertNotNull((String)"Should load the new table", (Object)table);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Should have the expected schema", (Object)expectedSchema, (Object)table.schema().asStruct());
        Assert.assertEquals((String)"Should not be partitioned", (long)0L, (long)table.spec().fields().size());
        Assert.assertEquals((String)"Should not have default format parquet", (Object)"parquet", table.properties().get("write.format.default"));
        AssertHelpers.assertThrows((String)"Should reject unsupported format names", IllegalArgumentException.class, (String)"Unsupported format in USING: crocodile", () -> this.sql("CREATE TABLE %s.default.fail (id BIGINT NOT NULL, data STRING) USING crocodile", this.catalogName));
    }

    @Test
    public void testCreateTablePartitionedBy() {
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, created_at TIMESTAMP, category STRING, data STRING) USING iceberg PARTITIONED BY (category, bucket(8, id), days(created_at))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertNotNull((String)"Should load the new table", (Object)table);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"created_at", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)3, (String)"category", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Should have the expected schema", (Object)expectedSchema, (Object)table.schema().asStruct());
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)new Schema(expectedSchema.fields())).identity("category").bucket("id", 8).day("created_at").build();
        Assert.assertEquals((String)"Should be partitioned correctly", (Object)expectedSpec, (Object)table.spec());
        Assert.assertNull((String)"Should not have the default format set", table.properties().get("write.format.default"));
    }

    @Test
    public void testCreateTableColumnComments() {
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL COMMENT 'Unique identifier', data STRING COMMENT 'Data value') USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertNotNull((String)"Should load the new table", (Object)table);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get(), (String)"Unique identifier"), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get(), (String)"Data value")});
        Assert.assertEquals((String)"Should have the expected schema", (Object)expectedSchema, (Object)table.schema().asStruct());
        Assert.assertEquals((String)"Should not be partitioned", (long)0L, (long)table.spec().fields().size());
        Assert.assertNull((String)"Should not have the default format set", table.properties().get("write.format.default"));
    }

    @Test
    public void testCreateTableComment() {
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg COMMENT 'Table doc'", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertNotNull((String)"Should load the new table", (Object)table);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Should have the expected schema", (Object)expectedSchema, (Object)table.schema().asStruct());
        Assert.assertEquals((String)"Should not be partitioned", (long)0L, (long)table.spec().fields().size());
        Assert.assertNull((String)"Should not have the default format set", table.properties().get("write.format.default"));
        Assert.assertEquals((String)"Should have the table comment set in properties", (Object)"Table doc", table.properties().get("comment"));
    }

    @Test
    public void testCreateTableLocation() throws Exception {
        Assume.assumeTrue((String)"Cannot set custom locations for Hadoop catalog tables", (!(this.validationCatalog instanceof HadoopCatalog) ? 1 : 0) != 0);
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        File tableLocation = this.temp.newFolder();
        Assert.assertTrue((boolean)tableLocation.delete());
        String location = "file:" + tableLocation.toString();
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg LOCATION '%s'", this.tableName, location);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertNotNull((String)"Should load the new table", (Object)table);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Should have the expected schema", (Object)expectedSchema, (Object)table.schema().asStruct());
        Assert.assertEquals((String)"Should not be partitioned", (long)0L, (long)table.spec().fields().size());
        Assert.assertNull((String)"Should not have the default format set", table.properties().get("write.format.default"));
        Assert.assertEquals((String)"Should have a custom table location", (Object)location, (Object)table.location());
    }

    @Test
    public void testCreateTableProperties() {
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg TBLPROPERTIES (p1=2, p2='x')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertNotNull((String)"Should load the new table", (Object)table);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Should have the expected schema", (Object)expectedSchema, (Object)table.schema().asStruct());
        Assert.assertEquals((String)"Should not be partitioned", (long)0L, (long)table.spec().fields().size());
        Assert.assertEquals((String)"Should have property p1", (Object)"2", table.properties().get("p1"));
        Assert.assertEquals((String)"Should have property p2", (Object)"x", table.properties().get("p2"));
    }

    @Test
    public void testCreateTableWithFormatV2ThroughTableProperty() {
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg TBLPROPERTIES ('format-version'='2')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"should create table using format v2", (long)2L, (long)((BaseTable)table).operations().current().formatVersion());
    }

    @Test
    public void testUpgradeTableWithFormatV2ThroughTableProperty() {
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg TBLPROPERTIES ('format-version'='1')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        TableOperations ops = ((BaseTable)table).operations();
        Assert.assertEquals((String)"should create table using format v1", (long)1L, (long)ops.refresh().formatVersion());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('format-version'='2')", this.tableName);
        Assert.assertEquals((String)"should update table to use format v2", (long)2L, (long)ops.refresh().formatVersion());
    }

    @Test
    public void testDowngradeTableToFormatV1ThroughTablePropertyFails() {
        Assert.assertFalse((String)"Table should not already exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg TBLPROPERTIES ('format-version'='2')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        TableOperations ops = ((BaseTable)table).operations();
        Assert.assertEquals((String)"should create table using format v2", (long)2L, (long)ops.refresh().formatVersion());
        AssertHelpers.assertThrowsCause((String)"should fail to downgrade to v1", IllegalArgumentException.class, (String)"Cannot downgrade v2 table to v1", () -> this.sql("ALTER TABLE %s SET TBLPROPERTIES ('format-version'='1')", this.tableName));
    }
}

