/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.relocated.com.google.common.io.BaseEncoding;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.iceberg.spark.functions.BucketFunction;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSparkBucketFunction
extends SparkTestBaseWithCatalog {
    @Before
    public void useCatalog() {
        this.sql("USE %s", this.catalogName);
    }

    @Test
    public void testSpecValues() {
        new BucketFunction.BucketInt(DataTypes.IntegerType);
        Assert.assertEquals((String)"Spec example: hash(34) = 2017239379", (long)2017239379L, (long)BucketFunction.BucketInt.hash((int)34));
        new BucketFunction.BucketLong(DataTypes.LongType);
        Assert.assertEquals((String)"Spec example: hash(34L) = 2017239379", (long)2017239379L, (long)BucketFunction.BucketLong.hash((long)34L));
        new BucketFunction.BucketDecimal((DataType)DataTypes.createDecimalType((int)9, (int)2));
        Assert.assertEquals((String)"Spec example: hash(decimal2(14.20)) = -500754589", (long)-500754589L, (long)BucketFunction.BucketDecimal.hash((BigDecimal)new BigDecimal("14.20")));
        Literal date = Literal.of((CharSequence)"2017-11-16").to((Type)Types.DateType.get());
        new BucketFunction.BucketInt(DataTypes.DateType);
        Assert.assertEquals((String)"Spec example: hash(2017-11-16) = -653330422", (long)-653330422L, (long)BucketFunction.BucketInt.hash((int)((Integer)date.value())));
        Literal timestampVal = Literal.of((CharSequence)"2017-11-16T22:31:08").to((Type)Types.TimestampType.withoutZone());
        new BucketFunction.BucketLong(DataTypes.TimestampType);
        Assert.assertEquals((String)"Spec example: hash(2017-11-16T22:31:08) = -2047944441", (long)-2047944441L, (long)BucketFunction.BucketLong.hash((long)((Long)timestampVal.value())));
        new BucketFunction.BucketString();
        Assert.assertEquals((String)"Spec example: hash(\"iceberg\") = 1210000089", (long)1210000089L, (long)BucketFunction.BucketString.hash((String)"iceberg"));
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{0, 1, 2, 3});
        new BucketFunction.BucketBinary();
        Assert.assertEquals((String)"Spec example: hash([00 01 02 03]) = -188683207", (long)-188683207L, (long)BucketFunction.BucketBinary.hash((ByteBuffer)bytes));
    }

    @Test
    public void testBucketIntegers() {
        Assert.assertEquals((String)"Byte type should bucket similarly to integer", (Object)3, (Object)this.scalarSql("SELECT system.bucket(10, 8Y)", new Object[0]));
        Assert.assertEquals((String)"Short type should bucket similarly to integer", (Object)3, (Object)this.scalarSql("SELECT system.bucket(10, 8S)", new Object[0]));
        Assert.assertEquals((Object)3, (Object)this.scalarSql("SELECT system.bucket(10, 8)", new Object[0]));
        Assert.assertEquals((Object)79, (Object)this.scalarSql("SELECT system.bucket(100, 34)", new Object[0]));
        Assert.assertNull((Object)this.scalarSql("SELECT system.bucket(1, CAST(null AS INT))", new Object[0]));
    }

    @Test
    public void testBucketDates() {
        Assert.assertEquals((Object)3, (Object)this.scalarSql("SELECT system.bucket(10, date('1970-01-09'))", new Object[0]));
        Assert.assertEquals((Object)79, (Object)this.scalarSql("SELECT system.bucket(100, date('1970-02-04'))", new Object[0]));
        Assert.assertNull((Object)this.scalarSql("SELECT system.bucket(1, CAST(null AS DATE))", new Object[0]));
    }

    @Test
    public void testBucketLong() {
        Assert.assertEquals((Object)79, (Object)this.scalarSql("SELECT system.bucket(100, 34L)", new Object[0]));
        Assert.assertEquals((Object)76, (Object)this.scalarSql("SELECT system.bucket(100, 0L)", new Object[0]));
        Assert.assertEquals((Object)97, (Object)this.scalarSql("SELECT system.bucket(100, -34L)", new Object[0]));
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.bucket(2, -1L)", new Object[0]));
        Assert.assertNull((Object)this.scalarSql("SELECT system.bucket(2, CAST(null AS LONG))", new Object[0]));
    }

    @Test
    public void testBucketDecimal() {
        Assert.assertEquals((Object)56, (Object)this.scalarSql("SELECT system.bucket(64, CAST('12.34' as DECIMAL(9, 2)))", new Object[0]));
        Assert.assertEquals((Object)13, (Object)this.scalarSql("SELECT system.bucket(18, CAST('12.30' as DECIMAL(9, 2)))", new Object[0]));
        Assert.assertEquals((Object)2, (Object)this.scalarSql("SELECT system.bucket(16, CAST('12.999' as DECIMAL(9, 3)))", new Object[0]));
        Assert.assertEquals((Object)21, (Object)this.scalarSql("SELECT system.bucket(32, CAST('0.05' as DECIMAL(5, 2)))", new Object[0]));
        Assert.assertEquals((Object)85, (Object)this.scalarSql("SELECT system.bucket(128, CAST('0.05' as DECIMAL(9, 2)))", new Object[0]));
        Assert.assertEquals((Object)3, (Object)this.scalarSql("SELECT system.bucket(18, CAST('0.05' as DECIMAL(9, 2)))", new Object[0]));
        Assert.assertNull((String)"Null input should return null", (Object)this.scalarSql("SELECT system.bucket(2, CAST(null AS decimal))", new Object[0]));
    }

    @Test
    public void testBucketTimestamp() {
        Assert.assertEquals((Object)99, (Object)this.scalarSql("SELECT system.bucket(100, TIMESTAMP '1997-01-01 00:00:00 UTC+00:00')", new Object[0]));
        Assert.assertEquals((Object)85, (Object)this.scalarSql("SELECT system.bucket(100, TIMESTAMP '1997-01-31 09:26:56 UTC+00:00')", new Object[0]));
        Assert.assertEquals((Object)62, (Object)this.scalarSql("SELECT system.bucket(100, TIMESTAMP '2022-08-08 00:00:00 UTC+00:00')", new Object[0]));
        Assert.assertNull((Object)this.scalarSql("SELECT system.bucket(2, CAST(null AS timestamp))", new Object[0]));
    }

    @Test
    public void testBucketString() {
        Assert.assertEquals((Object)4, (Object)this.scalarSql("SELECT system.bucket(5, 'abcdefg')", new Object[0]));
        Assert.assertEquals((Object)122, (Object)this.scalarSql("SELECT system.bucket(128, 'abc')", new Object[0]));
        Assert.assertEquals((Object)54, (Object)this.scalarSql("SELECT system.bucket(64, 'abcde')", new Object[0]));
        Assert.assertEquals((Object)8, (Object)this.scalarSql("SELECT system.bucket(12, '\u6d4b\u8bd5')", new Object[0]));
        Assert.assertEquals((Object)1, (Object)this.scalarSql("SELECT system.bucket(16, '\u6d4b\u8bd5raul\u8bd5\u6d4b')", new Object[0]));
        Assert.assertEquals((String)"Varchar should work like string", (Object)1, (Object)this.scalarSql("SELECT system.bucket(16, CAST('\u6d4b\u8bd5raul\u8bd5\u6d4b' AS varchar(8)))", new Object[0]));
        Assert.assertEquals((String)"Char should work like string", (Object)1, (Object)this.scalarSql("SELECT system.bucket(16, CAST('\u6d4b\u8bd5raul\u8bd5\u6d4b' AS char(8)))", new Object[0]));
        Assert.assertEquals((String)"Should not fail on the empty string", (Object)0, (Object)this.scalarSql("SELECT system.bucket(16, '')", new Object[0]));
        Assert.assertNull((String)"Null input should return null as output", (Object)this.scalarSql("SELECT system.bucket(16, CAST(null AS string))", new Object[0]));
    }

    @Test
    public void testBucketBinary() {
        Assert.assertEquals((Object)1, (Object)this.scalarSql("SELECT system.bucket(10, X'0102030405060708090a0b0c0d0e0f')", new Object[0]));
        Assert.assertEquals((Object)10, (Object)this.scalarSql("SELECT system.bucket(12, %s)", this.asBytesLiteral("abcdefg")));
        Assert.assertEquals((Object)13, (Object)this.scalarSql("SELECT system.bucket(18, %s)", this.asBytesLiteral("abc\u0000\u0000")));
        Assert.assertEquals((Object)42, (Object)this.scalarSql("SELECT system.bucket(48, %s)", this.asBytesLiteral("abc")));
        Assert.assertEquals((Object)3, (Object)this.scalarSql("SELECT system.bucket(16, %s)", this.asBytesLiteral("\u6d4b\u8bd5_")));
        Assert.assertNull((String)"Null input should return null as output", (Object)this.scalarSql("SELECT system.bucket(100, CAST(null AS binary))", new Object[0]));
    }

    @Test
    public void testNumBucketsAcceptsShortAndByte() {
        Assert.assertEquals((String)"Short types should be usable for the number of buckets field", (Object)1, (Object)this.scalarSql("SELECT system.bucket(5S, 1L)", new Object[0]));
        Assert.assertEquals((String)"Byte types should be allowed for the number of buckets field", (Object)1, (Object)this.scalarSql("SELECT system.bucket(5Y, 1)", new Object[0]));
    }

    @Test
    public void testWrongNumberOfArguments() {
        AssertHelpers.assertThrows((String)"Function resolution should not work with zero arguments", AnalysisException.class, (String)"Function 'bucket' cannot process input: (): Wrong number of inputs (expected numBuckets and value)", () -> this.scalarSql("SELECT system.bucket()", new Object[0]));
        AssertHelpers.assertThrows((String)"Function resolution should not work with only one argument", AnalysisException.class, (String)"Function 'bucket' cannot process input: (int): Wrong number of inputs (expected numBuckets and value)", () -> this.scalarSql("SELECT system.bucket(1)", new Object[0]));
        AssertHelpers.assertThrows((String)"Function resolution should not work with more than two arguments", AnalysisException.class, (String)"Function 'bucket' cannot process input: (int, bigint, int): Wrong number of inputs (expected numBuckets and value)", () -> this.scalarSql("SELECT system.bucket(1, 1L, 1)", new Object[0]));
    }

    @Test
    public void testInvalidTypesCannotBeUsedForNumberOfBuckets() {
        AssertHelpers.assertThrows((String)"Decimal type should not be coercible to the number of buckets", AnalysisException.class, (String)"Function 'bucket' cannot process input: (decimal(9,2), int): Expected number of buckets to be tinyint, shortint or int", () -> this.scalarSql("SELECT system.bucket(CAST('12.34' as DECIMAL(9, 2)), 10)", new Object[0]));
        AssertHelpers.assertThrows((String)"Long type should not be coercible to the number of buckets", AnalysisException.class, (String)"Function 'bucket' cannot process input: (bigint, int): Expected number of buckets to be tinyint, shortint or int", () -> this.scalarSql("SELECT system.bucket(12L, 10)", new Object[0]));
        AssertHelpers.assertThrows((String)"String type should not be coercible to the number of buckets", AnalysisException.class, (String)"Function 'bucket' cannot process input: (string, int): Expected number of buckets to be tinyint, shortint or int", () -> this.scalarSql("SELECT system.bucket('5', 10)", new Object[0]));
        AssertHelpers.assertThrows((String)"Interval year to month  type should not be coercible to the number of buckets", AnalysisException.class, (String)"Function 'bucket' cannot process input: (interval year to month, int): Expected number of buckets to be tinyint, shortint or int", () -> this.scalarSql("SELECT system.bucket(INTERVAL '100-00' YEAR TO MONTH, 10)", new Object[0]));
        AssertHelpers.assertThrows((String)"Interval day-time type should not be coercible to the number of buckets", AnalysisException.class, (String)"Function 'bucket' cannot process input: (interval day to second, int): Expected number of buckets to be tinyint, shortint or int", () -> this.scalarSql("SELECT system.bucket(CAST('11 23:4:0' AS INTERVAL DAY TO SECOND), 10)", new Object[0]));
    }

    @Test
    public void testInvalidTypesForBucketColumn() {
        AssertHelpers.assertThrows((String)"Double type should not be bucketable", AnalysisException.class, (String)"Function 'bucket' cannot process input: (int, float): Expected column to be date, tinyint, smallint, int, bigint, decimal, timestamp, string, or binary", () -> this.scalarSql("SELECT system.bucket(10, cast(12.3456 as float))", new Object[0]));
        AssertHelpers.assertThrows((String)"Double type should not be bucketable", AnalysisException.class, (String)"Function 'bucket' cannot process input: (int, double): Expected column to be date, tinyint, smallint, int, bigint, decimal, timestamp, string, or binary", () -> this.scalarSql("SELECT system.bucket(10, cast(12.3456 as double))", new Object[0]));
        AssertHelpers.assertThrows((String)"Boolean type should not be bucketable", AnalysisException.class, (String)"Function 'bucket' cannot process input: (int, boolean)", () -> this.scalarSql("SELECT system.bucket(10, true)", new Object[0]));
        AssertHelpers.assertThrows((String)"Map types should not be bucketable", AnalysisException.class, (String)"Function 'bucket' cannot process input: (int, map<int,int>)", () -> this.scalarSql("SELECT system.bucket(10, map(1, 1))", new Object[0]));
        AssertHelpers.assertThrows((String)"Array types should not be bucketable", AnalysisException.class, (String)"Function 'bucket' cannot process input: (int, array<bigint>)", () -> this.scalarSql("SELECT system.bucket(10, array(1L))", new Object[0]));
        AssertHelpers.assertThrows((String)"Interval year-to-month type should not be bucketable", AnalysisException.class, (String)"Function 'bucket' cannot process input: (int, interval year to month)", () -> this.scalarSql("SELECT system.bucket(10, INTERVAL '100-00' YEAR TO MONTH)", new Object[0]));
        AssertHelpers.assertThrows((String)"Interval day-time type should not be bucketable", AnalysisException.class, (String)"Function 'bucket' cannot process input: (int, interval day to second)", () -> this.scalarSql("SELECT system.bucket(10, CAST('11 23:4:0' AS INTERVAL DAY TO SECOND))", new Object[0]));
    }

    @Test
    public void testThatMagicFunctionsAreInvoked() {
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.bucket(5, 6Y)", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.BucketFunction$BucketInt"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.bucket(5, 6S)", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.BucketFunction$BucketInt"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.bucket(5, 6)", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.BucketFunction$BucketInt"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.bucket(100, DATE '2022-08-08')", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.BucketFunction$BucketInt"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.bucket(5, 6L)", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.BucketFunction$BucketLong"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.bucket(100, TIMESTAMP '2022-08-08')", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.BucketFunction$BucketLong"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.bucket(5, 'abcdefg')", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.BucketFunction$BucketString"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.bucket(5, CAST('12.34' AS DECIMAL))", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.BucketFunction$BucketDecimal"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.bucket(4, X'0102030405060708')", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.BucketFunction$BucketBinary"});
    }

    private String asBytesLiteral(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        return "X'" + BaseEncoding.base16().encode(bytes) + "'";
    }
}

