/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.sql.Date;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.spark.sql.AnalysisException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSparkDaysFunction
extends SparkTestBaseWithCatalog {
    @Before
    public void useCatalog() {
        this.sql("USE %s", this.catalogName);
    }

    @Test
    public void testDates() {
        Assert.assertEquals((String)"Expected to produce 2017-12-01", (Object)Date.valueOf("2017-12-01"), (Object)this.scalarSql("SELECT system.days(date('2017-12-01'))", new Object[0]));
        Assert.assertEquals((String)"Expected to produce 1970-01-01", (Object)Date.valueOf("1970-01-01"), (Object)this.scalarSql("SELECT system.days(date('1970-01-01'))", new Object[0]));
        Assert.assertEquals((String)"Expected to produce 1969-12-31", (Object)Date.valueOf("1969-12-31"), (Object)this.scalarSql("SELECT system.days(date('1969-12-31'))", new Object[0]));
        Assert.assertNull((Object)this.scalarSql("SELECT system.days(CAST(null AS DATE))", new Object[0]));
    }

    @Test
    public void testTimestamps() {
        Assert.assertEquals((String)"Expected to produce 2017-12-01", (Object)Date.valueOf("2017-12-01"), (Object)this.scalarSql("SELECT system.days(TIMESTAMP '2017-12-01 10:12:55.038194 UTC+00:00')", new Object[0]));
        Assert.assertEquals((String)"Expected to produce 1970-01-01", (Object)Date.valueOf("1970-01-01"), (Object)this.scalarSql("SELECT system.days(TIMESTAMP '1970-01-01 00:00:01.000001 UTC+00:00')", new Object[0]));
        Assert.assertEquals((String)"Expected to produce 1969-12-31", (Object)Date.valueOf("1969-12-31"), (Object)this.scalarSql("SELECT system.days(TIMESTAMP '1969-12-31 23:59:58.999999 UTC+00:00')", new Object[0]));
        Assert.assertNull((Object)this.scalarSql("SELECT system.days(CAST(null AS DATE))", new Object[0]));
    }

    @Test
    public void testWrongNumberOfArguments() {
        AssertHelpers.assertThrows((String)"Function resolution should not work with zero arguments", AnalysisException.class, (String)"Function 'days' cannot process input: (): Wrong number of inputs", () -> this.scalarSql("SELECT system.days()", new Object[0]));
        AssertHelpers.assertThrows((String)"Function resolution should not work with more than one argument", AnalysisException.class, (String)"Function 'days' cannot process input: (date, date): Wrong number of inputs", () -> this.scalarSql("SELECT system.days(date('1969-12-31'), date('1969-12-31'))", new Object[0]));
    }

    @Test
    public void testInvalidInputTypes() {
        AssertHelpers.assertThrows((String)"Int type should not be coercible to date/timestamp", AnalysisException.class, (String)"Function 'days' cannot process input: (int): Expected value to be date or timestamp", () -> this.scalarSql("SELECT system.days(1)", new Object[0]));
        AssertHelpers.assertThrows((String)"Long type should not be coercible to date/timestamp", AnalysisException.class, (String)"Function 'days' cannot process input: (bigint): Expected value to be date or timestamp", () -> this.scalarSql("SELECT system.days(1L)", new Object[0]));
    }
}

