/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.spark.sql.AnalysisException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSparkHoursFunction
extends SparkTestBaseWithCatalog {
    @Before
    public void useCatalog() {
        this.sql("USE %s", this.catalogName);
    }

    @Test
    public void testTimestamps() {
        Assert.assertEquals((String)"Expected to produce 17501 * 24 + 10", (Object)420034, (Object)this.scalarSql("SELECT system.hours(TIMESTAMP '2017-12-01 10:12:55.038194 UTC+00:00')", new Object[0]));
        Assert.assertEquals((String)"Expected to produce 0 * 24 + 0 = 0", (Object)0, (Object)this.scalarSql("SELECT system.hours(TIMESTAMP '1970-01-01 00:00:01.000001 UTC+00:00')", new Object[0]));
        Assert.assertEquals((String)"Expected to produce -1", (Object)-1, (Object)this.scalarSql("SELECT system.hours(TIMESTAMP '1969-12-31 23:59:58.999999 UTC+00:00')", new Object[0]));
        Assert.assertNull((Object)this.scalarSql("SELECT system.hours(CAST(null AS TIMESTAMP))", new Object[0]));
    }

    @Test
    public void testWrongNumberOfArguments() {
        AssertHelpers.assertThrows((String)"Function resolution should not work with zero arguments", AnalysisException.class, (String)"Function 'hours' cannot process input: (): Wrong number of inputs", () -> this.scalarSql("SELECT system.hours()", new Object[0]));
        AssertHelpers.assertThrows((String)"Function resolution should not work with more than one argument", AnalysisException.class, (String)"Function 'hours' cannot process input: (date, date): Wrong number of inputs", () -> this.scalarSql("SELECT system.hours(date('1969-12-31'), date('1969-12-31'))", new Object[0]));
    }

    @Test
    public void testInvalidInputTypes() {
        AssertHelpers.assertThrows((String)"Int type should not be coercible to timestamp", AnalysisException.class, (String)"Function 'hours' cannot process input: (int): Expected value to be timestamp", () -> this.scalarSql("SELECT system.hours(1)", new Object[0]));
        AssertHelpers.assertThrows((String)"Long type should not be coercible to timestamp", AnalysisException.class, (String)"Function 'hours' cannot process input: (bigint): Expected value to be timestamp", () -> this.scalarSql("SELECT system.hours(1L)", new Object[0]));
    }
}

