/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.SparkStagedScan;
import org.apache.iceberg.types.TypeUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

class SparkStagedScanBuilder
implements ScanBuilder,
SupportsPushDownRequiredColumns {
    private final SparkSession spark;
    private final Table table;
    private final SparkReadConf readConf;
    private final List<String> metaColumns = Lists.newArrayList();
    private Schema schema = null;

    SparkStagedScanBuilder(SparkSession spark, Table table, CaseInsensitiveStringMap options) {
        this.spark = spark;
        this.table = table;
        this.readConf = new SparkReadConf(spark, table, (Map<String, String>)options);
        this.schema = table.schema();
    }

    public Scan build() {
        return new SparkStagedScan(this.spark, this.table, this.schemaWithMetadataColumns(), this.readConf);
    }

    public void pruneColumns(StructType requestedSchema) {
        StructType requestedProjection = this.removeMetaColumns(requestedSchema);
        this.schema = SparkSchemaUtil.prune(this.schema, requestedProjection);
        Stream.of(requestedSchema.fields()).map(StructField::name).filter(MetadataColumns::isMetadataColumn).distinct().forEach(this.metaColumns::add);
    }

    private StructType removeMetaColumns(StructType structType) {
        return new StructType((StructField[])Stream.of(structType.fields()).filter(field -> MetadataColumns.nonMetadataColumn((String)field.name())).toArray(StructField[]::new));
    }

    private Schema schemaWithMetadataColumns() {
        List fields = this.metaColumns.stream().distinct().map(name -> MetadataColumns.metadataColumn((Table)this.table, (String)name)).collect(Collectors.toList());
        Schema meta = new Schema(fields);
        return TypeUtil.join((Schema)this.schema, (Schema)meta);
    }
}

