/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;
import org.apache.spark.sql.connector.read.streaming.Offset;

class StreamingOffset
extends Offset {
    static final StreamingOffset START_OFFSET = new StreamingOffset(-1L, -1L, false);
    private static final int CURR_VERSION = 1;
    private static final String VERSION = "version";
    private static final String SNAPSHOT_ID = "snapshot_id";
    private static final String POSITION = "position";
    private static final String SCAN_ALL_FILES = "scan_all_files";
    private final long snapshotId;
    private final long position;
    private final boolean scanAllFiles;

    StreamingOffset(long snapshotId, long position, boolean scanAllFiles) {
        this.snapshotId = snapshotId;
        this.position = position;
        this.scanAllFiles = scanAllFiles;
    }

    static StreamingOffset fromJson(String json) {
        Preconditions.checkNotNull((Object)json, (Object)"Cannot parse StreamingOffset JSON: null");
        try {
            JsonNode node = (JsonNode)JsonUtil.mapper().readValue(json, JsonNode.class);
            return StreamingOffset.fromJsonNode(node);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to parse StreamingOffset from JSON string %s", json), e);
        }
    }

    static StreamingOffset fromJson(InputStream inputStream) {
        JsonNode node;
        Preconditions.checkNotNull((Object)inputStream, (Object)"Cannot parse StreamingOffset from inputStream: null");
        try {
            node = (JsonNode)JsonUtil.mapper().readValue(inputStream, JsonNode.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read StreamingOffset from json", e);
        }
        return StreamingOffset.fromJsonNode(node);
    }

    public String json() {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            generator.writeStartObject();
            generator.writeNumberField(VERSION, 1);
            generator.writeNumberField(SNAPSHOT_ID, this.snapshotId);
            generator.writeNumberField(POSITION, this.position);
            generator.writeBooleanField(SCAN_ALL_FILES, this.scanAllFiles);
            generator.writeEndObject();
            generator.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write StreamingOffset to json", e);
        }
        return writer.toString();
    }

    long snapshotId() {
        return this.snapshotId;
    }

    long position() {
        return this.position;
    }

    boolean shouldScanAllFiles() {
        return this.scanAllFiles;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StreamingOffset) {
            StreamingOffset offset = (StreamingOffset)((Object)obj);
            return offset.snapshotId == this.snapshotId && offset.position == this.position && offset.scanAllFiles == this.scanAllFiles;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.snapshotId, this.position, this.scanAllFiles});
    }

    public String toString() {
        return String.format("Streaming Offset[%d: position (%d) scan_all_files (%b)]", this.snapshotId, this.position, this.scanAllFiles);
    }

    private static StreamingOffset fromJsonNode(JsonNode node) {
        int version = JsonUtil.getInt((String)VERSION, (JsonNode)node);
        Preconditions.checkArgument((version == 1 ? 1 : 0) != 0, (String)"This version of Iceberg source only supports version %s. Version %s is not supported.", (int)1, (int)version);
        long snapshotId = JsonUtil.getLong((String)SNAPSHOT_ID, (JsonNode)node);
        int position = JsonUtil.getInt((String)POSITION, (JsonNode)node);
        boolean shouldScanAllFiles = JsonUtil.getBool((String)SCAN_ALL_FILES, (JsonNode)node);
        return new StreamingOffset(snapshotId, position, shouldScanAllFiles);
    }
}

