/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.BaseCatalog;
import org.apache.iceberg.spark.PathIdentifier;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.spark.source.StagedSparkTable;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.StagedTable;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkCatalog
extends BaseCatalog {
    private static final Set<String> DEFAULT_NS_KEYS = ImmutableSet.of((Object)"owner");
    private static final Splitter COMMA = Splitter.on((String)",");
    private static final Pattern AT_TIMESTAMP = Pattern.compile("at_timestamp_(\\d+)");
    private static final Pattern SNAPSHOT_ID = Pattern.compile("snapshot_id_(\\d+)");
    private String catalogName = null;
    private Catalog icebergCatalog = null;
    private boolean cacheEnabled = true;
    private SupportsNamespaces asNamespaceCatalog = null;
    private String[] defaultNamespace = null;
    private HadoopTables tables;
    private boolean useTimestampsWithoutZone;

    protected Catalog buildIcebergCatalog(String name, CaseInsensitiveStringMap options) {
        Configuration conf = SparkUtil.hadoopConfCatalogOverrides(SparkSession.active(), name);
        TreeMap<String, String> optionsMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        optionsMap.putAll(options.asCaseSensitiveMap());
        optionsMap.put("app-id", SparkSession.active().sparkContext().applicationId());
        optionsMap.put("user", SparkSession.active().sparkContext().sparkUser());
        return CatalogUtil.buildIcebergCatalog((String)name, optionsMap, (Object)conf);
    }

    protected TableIdentifier buildIdentifier(Identifier identifier) {
        return Spark3Util.identifierToTableIdentifier(identifier);
    }

    public SparkTable loadTable(Identifier ident) throws NoSuchTableException {
        try {
            Pair<Table, Long> icebergTable = this.load(ident);
            return new SparkTable((Table)icebergTable.first(), (Long)icebergTable.second(), !this.cacheEnabled);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(ident);
        }
    }

    public SparkTable loadTable(Identifier ident, String version) throws NoSuchTableException {
        try {
            Pair<Table, Long> icebergTable = this.load(ident);
            Preconditions.checkArgument((icebergTable.second() == null ? 1 : 0) != 0, (Object)"Cannot do time-travel based on both table identifier and AS OF");
            return new SparkTable((Table)icebergTable.first(), Long.parseLong(version), !this.cacheEnabled);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(ident);
        }
    }

    public SparkTable loadTable(Identifier ident, long timestamp) throws NoSuchTableException {
        try {
            Pair<Table, Long> icebergTable = this.load(ident);
            long timestampMillis = TimeUnit.MICROSECONDS.toMillis(timestamp);
            Preconditions.checkArgument((icebergTable.second() == null ? 1 : 0) != 0, (Object)"Cannot do time-travel based on both table identifier and AS OF");
            long snapshotIdAsOfTime = SnapshotUtil.snapshotIdAsOfTime((Table)((Table)icebergTable.first()), (long)timestampMillis);
            return new SparkTable((Table)icebergTable.first(), snapshotIdAsOfTime, !this.cacheEnabled);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(ident);
        }
    }

    public SparkTable createTable(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) throws TableAlreadyExistsException {
        Schema icebergSchema = SparkSchemaUtil.convert(schema, this.useTimestampsWithoutZone);
        try {
            Catalog.TableBuilder builder = this.newBuilder(ident, icebergSchema);
            Table icebergTable = builder.withPartitionSpec(Spark3Util.toPartitionSpec(icebergSchema, transforms)).withLocation(properties.get("location")).withProperties(Spark3Util.rebuildCreateProperties(properties)).create();
            return new SparkTable(icebergTable, !this.cacheEnabled);
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(ident);
        }
    }

    public StagedTable stageCreate(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) throws TableAlreadyExistsException {
        Schema icebergSchema = SparkSchemaUtil.convert(schema, this.useTimestampsWithoutZone);
        try {
            Catalog.TableBuilder builder = this.newBuilder(ident, icebergSchema);
            Transaction transaction = builder.withPartitionSpec(Spark3Util.toPartitionSpec(icebergSchema, transforms)).withLocation(properties.get("location")).withProperties(Spark3Util.rebuildCreateProperties(properties)).createTransaction();
            return new StagedSparkTable(transaction);
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(ident);
        }
    }

    public StagedTable stageReplace(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) throws NoSuchTableException {
        Schema icebergSchema = SparkSchemaUtil.convert(schema, this.useTimestampsWithoutZone);
        try {
            Catalog.TableBuilder builder = this.newBuilder(ident, icebergSchema);
            Transaction transaction = builder.withPartitionSpec(Spark3Util.toPartitionSpec(icebergSchema, transforms)).withLocation(properties.get("location")).withProperties(Spark3Util.rebuildCreateProperties(properties)).replaceTransaction();
            return new StagedSparkTable(transaction);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(ident);
        }
    }

    public StagedTable stageCreateOrReplace(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) {
        Schema icebergSchema = SparkSchemaUtil.convert(schema, this.useTimestampsWithoutZone);
        Catalog.TableBuilder builder = this.newBuilder(ident, icebergSchema);
        Transaction transaction = builder.withPartitionSpec(Spark3Util.toPartitionSpec(icebergSchema, transforms)).withLocation(properties.get("location")).withProperties(Spark3Util.rebuildCreateProperties(properties)).createOrReplaceTransaction();
        return new StagedSparkTable(transaction);
    }

    public SparkTable alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        TableChange.SetProperty setLocation = null;
        TableChange.SetProperty setSnapshotId = null;
        TableChange.SetProperty pickSnapshotId = null;
        ArrayList propertyChanges = Lists.newArrayList();
        ArrayList schemaChanges = Lists.newArrayList();
        for (TableChange change : changes) {
            if (change instanceof TableChange.SetProperty) {
                TableChange.SetProperty set = (TableChange.SetProperty)change;
                if ("location".equalsIgnoreCase(set.property())) {
                    setLocation = set;
                    continue;
                }
                if ("current-snapshot-id".equalsIgnoreCase(set.property())) {
                    setSnapshotId = set;
                    continue;
                }
                if ("cherry-pick-snapshot-id".equalsIgnoreCase(set.property())) {
                    pickSnapshotId = set;
                    continue;
                }
                if ("sort-order".equalsIgnoreCase(set.property())) {
                    throw new UnsupportedOperationException("Cannot specify the 'sort-order' because it's a reserved table property. Please use the command 'ALTER TABLE ... WRITE ORDERED BY' to specify write sort-orders.");
                }
                propertyChanges.add(set);
                continue;
            }
            if (change instanceof TableChange.RemoveProperty) {
                propertyChanges.add(change);
                continue;
            }
            if (change instanceof TableChange.ColumnChange) {
                schemaChanges.add(change);
                continue;
            }
            throw new UnsupportedOperationException("Cannot apply unknown table change: " + change);
        }
        try {
            Table table = (Table)this.load(ident).first();
            SparkCatalog.commitChanges(table, setLocation, setSnapshotId, pickSnapshotId, propertyChanges, schemaChanges);
            return new SparkTable(table, true);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(ident);
        }
    }

    public boolean dropTable(Identifier ident) {
        return this.dropTableWithoutPurging(ident);
    }

    public boolean purgeTable(Identifier ident) {
        try {
            boolean metadataFileExists;
            Table table = (Table)this.load(ident).first();
            ValidationException.check((boolean)PropertyUtil.propertyAsBoolean((Map)table.properties(), (String)"gc.enabled", (boolean)true), (String)"Cannot purge table: GC is disabled (deleting files may corrupt other tables)", (Object[])new Object[0]);
            String metadataFileLocation = ((HasTableOperations)table).operations().current().metadataFileLocation();
            boolean dropped = this.dropTableWithoutPurging(ident);
            if (dropped && (metadataFileExists = table.io().newInputFile(metadataFileLocation).exists())) {
                SparkActions.get().deleteReachableFiles(metadataFileLocation).io(table.io()).execute();
            }
            return dropped;
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            return false;
        }
    }

    private boolean dropTableWithoutPurging(Identifier ident) {
        if (SparkCatalog.isPathIdentifier(ident)) {
            return this.tables.dropTable(((PathIdentifier)ident).location(), false);
        }
        return this.icebergCatalog.dropTable(this.buildIdentifier(ident), false);
    }

    public void renameTable(Identifier from, Identifier to) throws NoSuchTableException, TableAlreadyExistsException {
        try {
            SparkCatalog.checkNotPathIdentifier(from, "renameTable");
            SparkCatalog.checkNotPathIdentifier(to, "renameTable");
            this.icebergCatalog.renameTable(this.buildIdentifier(from), this.buildIdentifier(to));
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(from);
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(to);
        }
    }

    public void invalidateTable(Identifier ident) {
        if (!SparkCatalog.isPathIdentifier(ident)) {
            this.icebergCatalog.invalidateTable(this.buildIdentifier(ident));
        }
    }

    public Identifier[] listTables(String[] namespace) {
        return (Identifier[])this.icebergCatalog.listTables(Namespace.of((String[])namespace)).stream().map(ident -> Identifier.of((String[])ident.namespace().levels(), (String)ident.name())).toArray(Identifier[]::new);
    }

    public String[] defaultNamespace() {
        if (this.defaultNamespace != null) {
            return this.defaultNamespace;
        }
        return new String[0];
    }

    public String[][] listNamespaces() {
        if (this.asNamespaceCatalog != null) {
            return (String[][])this.asNamespaceCatalog.listNamespaces().stream().map(Namespace::levels).toArray(x$0 -> new String[x$0][]);
        }
        return new String[0][];
    }

    public String[][] listNamespaces(String[] namespace) throws org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException {
        if (this.asNamespaceCatalog != null) {
            try {
                return (String[][])this.asNamespaceCatalog.listNamespaces(Namespace.of((String[])namespace)).stream().map(Namespace::levels).toArray(x$0 -> new String[x$0][]);
            }
            catch (NoSuchNamespaceException e) {
                throw new org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException(namespace);
            }
        }
        throw new org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException(namespace);
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException {
        if (this.asNamespaceCatalog != null) {
            try {
                return this.asNamespaceCatalog.loadNamespaceMetadata(Namespace.of((String[])namespace));
            }
            catch (NoSuchNamespaceException e) {
                throw new org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException(namespace);
            }
        }
        throw new org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException(namespace);
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        if (this.asNamespaceCatalog != null) {
            try {
                if (this.asNamespaceCatalog instanceof HadoopCatalog && DEFAULT_NS_KEYS.equals(metadata.keySet())) {
                    this.asNamespaceCatalog.createNamespace(Namespace.of((String[])namespace), (Map)ImmutableMap.of());
                }
                this.asNamespaceCatalog.createNamespace(Namespace.of((String[])namespace), metadata);
            }
            catch (AlreadyExistsException e) {
                throw new NamespaceAlreadyExistsException(namespace);
            }
        } else {
            throw new UnsupportedOperationException("Namespaces are not supported by catalog: " + this.catalogName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException {
        if (this.asNamespaceCatalog == null) throw new org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException(namespace);
        HashMap updates = Maps.newHashMap();
        HashSet removals = Sets.newHashSet();
        for (NamespaceChange change : changes) {
            if (change instanceof NamespaceChange.SetProperty) {
                NamespaceChange.SetProperty set = (NamespaceChange.SetProperty)change;
                updates.put(set.property(), set.value());
                continue;
            }
            if (!(change instanceof NamespaceChange.RemoveProperty)) throw new UnsupportedOperationException("Cannot apply unknown namespace change: " + change);
            removals.add(((NamespaceChange.RemoveProperty)change).property());
        }
        try {
            if (!updates.isEmpty()) {
                this.asNamespaceCatalog.setProperties(Namespace.of((String[])namespace), (Map)updates);
            }
            if (removals.isEmpty()) return;
            this.asNamespaceCatalog.removeProperties(Namespace.of((String[])namespace), (Set)removals);
            return;
        }
        catch (NoSuchNamespaceException e) {
            throw new org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException(namespace);
        }
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException {
        if (this.asNamespaceCatalog != null) {
            try {
                return this.asNamespaceCatalog.dropNamespace(Namespace.of((String[])namespace));
            }
            catch (NoSuchNamespaceException e) {
                throw new org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException(namespace);
            }
        }
        return false;
    }

    public final void initialize(String name, CaseInsensitiveStringMap options) {
        this.cacheEnabled = PropertyUtil.propertyAsBoolean((Map)options, (String)"cache-enabled", (boolean)true);
        long cacheExpirationIntervalMs = PropertyUtil.propertyAsLong((Map)options, (String)"cache.expiration-interval-ms", (long)CatalogProperties.CACHE_EXPIRATION_INTERVAL_MS_DEFAULT);
        if (cacheExpirationIntervalMs == 0L) {
            this.cacheEnabled = false;
        }
        Catalog catalog = this.buildIcebergCatalog(name, options);
        this.catalogName = name;
        SparkSession sparkSession = SparkSession.active();
        this.useTimestampsWithoutZone = SparkUtil.useTimestampWithoutZoneInNewTables(sparkSession.conf());
        this.tables = new HadoopTables(SparkUtil.hadoopConfCatalogOverrides(SparkSession.active(), name));
        Catalog catalog2 = this.icebergCatalog = this.cacheEnabled ? CachingCatalog.wrap((Catalog)catalog, (long)cacheExpirationIntervalMs) : catalog;
        if (catalog instanceof SupportsNamespaces) {
            this.asNamespaceCatalog = (SupportsNamespaces)catalog;
            if (options.containsKey((Object)"default-namespace")) {
                this.defaultNamespace = Splitter.on((char)'.').splitToList((CharSequence)options.get((Object)"default-namespace")).toArray(new String[0]);
            }
        }
    }

    public String name() {
        return this.catalogName;
    }

    private static void commitChanges(Table table, TableChange.SetProperty setLocation, TableChange.SetProperty setSnapshotId, TableChange.SetProperty pickSnapshotId, List<TableChange> propertyChanges, List<TableChange> schemaChanges) {
        long newSnapshotId;
        Preconditions.checkArgument((setSnapshotId == null || pickSnapshotId == null ? 1 : 0) != 0, (Object)"Cannot set the current the current snapshot ID and cherry-pick snapshot changes");
        if (setSnapshotId != null) {
            newSnapshotId = Long.parseLong(setSnapshotId.value());
            table.manageSnapshots().setCurrentSnapshot(newSnapshotId).commit();
        }
        if (pickSnapshotId != null) {
            newSnapshotId = Long.parseLong(pickSnapshotId.value());
            table.manageSnapshots().cherrypick(newSnapshotId).commit();
        }
        Transaction transaction = table.newTransaction();
        if (setLocation != null) {
            transaction.updateLocation().setLocation(setLocation.value()).commit();
        }
        if (!propertyChanges.isEmpty()) {
            Spark3Util.applyPropertyChanges(transaction.updateProperties(), propertyChanges).commit();
        }
        if (!schemaChanges.isEmpty()) {
            Spark3Util.applySchemaChanges(transaction.updateSchema(), schemaChanges).commit();
        }
        transaction.commitTransaction();
    }

    private static boolean isPathIdentifier(Identifier ident) {
        return ident instanceof PathIdentifier;
    }

    private static void checkNotPathIdentifier(Identifier identifier, String method) {
        if (identifier instanceof PathIdentifier) {
            throw new IllegalArgumentException(String.format("Cannot pass path based identifier to %s method. %s is a path.", method, identifier));
        }
    }

    private Pair<Table, Long> load(Identifier ident) {
        if (SparkCatalog.isPathIdentifier(ident)) {
            return this.loadFromPathIdentifier((PathIdentifier)ident);
        }
        try {
            return Pair.of((Object)this.icebergCatalog.loadTable(this.buildIdentifier(ident)), null);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            Table table;
            if (ident.namespace().length == 0) {
                throw e;
            }
            TableIdentifier namespaceAsIdent = this.buildIdentifier(this.namespaceToIdentifier(ident.namespace()));
            try {
                table = this.icebergCatalog.loadTable(namespaceAsIdent);
            }
            catch (Exception ignored) {
                throw e;
            }
            Matcher at = AT_TIMESTAMP.matcher(ident.name());
            if (at.matches()) {
                long asOfTimestamp = Long.parseLong(at.group(1));
                return Pair.of((Object)table, (Object)SnapshotUtil.snapshotIdAsOfTime((Table)table, (long)asOfTimestamp));
            }
            Matcher id = SNAPSHOT_ID.matcher(ident.name());
            if (id.matches()) {
                long snapshotId = Long.parseLong(id.group(1));
                return Pair.of((Object)table, (Object)snapshotId);
            }
            throw e;
        }
    }

    private Pair<String, List<String>> parseLocationString(String location) {
        int hashIndex = location.lastIndexOf(35);
        if (hashIndex != -1 && !location.endsWith("#")) {
            String baseLocation = location.substring(0, hashIndex);
            List metadata = COMMA.splitToList((CharSequence)location.substring(hashIndex + 1));
            return Pair.of((Object)baseLocation, (Object)metadata);
        }
        return Pair.of((Object)location, (Object)ImmutableList.of());
    }

    private Pair<Table, Long> loadFromPathIdentifier(PathIdentifier ident) {
        Pair<String, List<String>> parsed = this.parseLocationString(ident.location());
        String metadataTableName = null;
        Long asOfTimestamp = null;
        Long snapshotId = null;
        for (String meta : (List)parsed.second()) {
            if (MetadataTableType.from((String)meta) != null) {
                metadataTableName = meta;
                continue;
            }
            Matcher at = AT_TIMESTAMP.matcher(meta);
            if (at.matches()) {
                asOfTimestamp = Long.parseLong(at.group(1));
                continue;
            }
            Matcher id = SNAPSHOT_ID.matcher(meta);
            if (!id.matches()) continue;
            snapshotId = Long.parseLong(id.group(1));
        }
        Preconditions.checkArgument((asOfTimestamp == null || snapshotId == null ? 1 : 0) != 0, (String)"Cannot specify both snapshot-id and as-of-timestamp: %s", (Object)ident.location());
        Table table = this.tables.load((String)parsed.first() + (metadataTableName != null ? "#" + metadataTableName : ""));
        if (snapshotId != null) {
            return Pair.of((Object)table, (Object)snapshotId);
        }
        if (asOfTimestamp != null) {
            return Pair.of((Object)table, (Object)SnapshotUtil.snapshotIdAsOfTime((Table)table, (long)asOfTimestamp));
        }
        return Pair.of((Object)table, null);
    }

    private Identifier namespaceToIdentifier(String[] namespace) {
        Preconditions.checkArgument((namespace.length > 0 ? 1 : 0) != 0, (Object)"Cannot convert empty namespace to identifier");
        String[] ns = Arrays.copyOf(namespace, namespace.length - 1);
        String name = namespace[ns.length];
        return Identifier.of((String[])ns, (String)name);
    }

    private Catalog.TableBuilder newBuilder(Identifier ident, Schema schema) {
        return SparkCatalog.isPathIdentifier(ident) ? this.tables.buildTable(((PathIdentifier)ident).location(), schema) : this.icebergCatalog.buildTable(this.buildIdentifier(ident), schema);
    }

    @Override
    public Catalog icebergCatalog() {
        return this.icebergCatalog;
    }
}

